/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import com.pingidentity.sdk.IdpAuthenticationAdapterV2;
import org.sourceid.saml20.adapter.idp.authn.IdpAuthenticationAdapter;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.websso.Protocol;

public class AuthenticationPoliciesUtil {
    public static boolean isAllowInputUserIdMappingForIdpConnection(String idConnId) {
        IdpConnection idConn = MgmtFactory.getConnectionManager().getIdpConnectionBySystemId(idConnId);
        if (idConn != null) {
            Protocol protocol = idConn.getProtocol();
            return protocol != Protocol.SAML11 && protocol != Protocol.SAML10 && protocol != Protocol.WSFED;
        }
        return false;
    }

    public static boolean isAllowInputUserIdMappingForAdapter(String adapterId, boolean v2OnlyAdapters) {
        IdpAuthenticationAdapter adapter = MgmtFactory.getAdapterManager().getIdpAuthnAdapter(adapterId);
        if (adapter != null) {
            if (v2OnlyAdapters) {
                return adapter instanceof IdpAuthenticationAdapterV2;
            }
            return true;
        }
        return false;
    }
}

