/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import java.io.IOException;

public class CachedValue<T> {
    private T value;
    private long timestamp = 0L;
    private long expiryPeriodMillis;
    private ValueProvider<T> valueProvider;

    public CachedValue(ValueProvider<T> valueProvider, long expiryPeriodMillis) {
        this.valueProvider = valueProvider;
        this.expiryPeriodMillis = expiryPeriodMillis;
    }

    public synchronized long getTimestamp() {
        return this.timestamp;
    }

    public synchronized T getValue() throws IOException {
        return this.getValue(false);
    }

    public synchronized T getValue(boolean returnExpiredValueIfNecessary) throws IOException {
        if (!this.isExpired()) {
            return this.value;
        }
        try {
            this.value = this.valueProvider.retrieveValue();
            this.timestamp = this.getCurrentTimeMillis();
            return this.value;
        }
        catch (IOException e) {
            if (this.timestamp != 0L && returnExpiredValueIfNecessary) {
                return this.value;
            }
            throw e;
        }
    }

    protected long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    protected boolean isExpired() {
        return this.timestamp + this.expiryPeriodMillis < this.getCurrentTimeMillis();
    }

    public static interface ValueProvider<T> {
        public T retrieveValue() throws IOException;
    }
}

