/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.hsm.BCFIPSStarter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Properties;
import org.pingidentity.utils.EnvironmentVariableUtil;
import org.pingidentity.utils.HivemoduleGenerator;
import sun.misc.Unsafe;

public final class ConsoleUtils {
    private static final String RUN_PROPERTIES = "run.properties";

    private ConsoleUtils() {
        throw new UnsupportedOperationException("not allowed");
    }

    public static void doConsoleUtilityInitialization() throws IOException {
        ConsoleUtils.disableWarning();
        ConsoleUtils.initializeCommandLineProperties();
        ConsoleUtils.loadHivemodule();
        ConsoleUtils.loadRunProperties();
        ConsoleUtils.checkEnableBCFIPS();
    }

    public static void initializeCommandLineProperties() {
        Properties properties = new Properties();
        properties.setProperty("pf.commandline.utility", "true");
        System.setProperty("pi.masterKeyEncryptor.useCustomCredentialProvider", "true");
        System.getProperties().putAll((Map<?, ?>)properties);
    }

    public static void disableWarning() {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            Unsafe u = (Unsafe)theUnsafe.get(null);
            Class<?> cls = Class.forName("jdk.internal.module.IllegalAccessLogger");
            Field logger = cls.getDeclaredField("logger");
            u.putObjectVolatile(cls, u.staticFieldOffset(logger), null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
    }

    public static void loadRunProperties() throws IOException {
        String runPropsFile = System.getProperty(RUN_PROPERTIES, "").trim();
        if (runPropsFile.isEmpty()) {
            throw new IOException("run.properties property is not defined");
        }
        Properties runProps = new Properties();
        try (FileInputStream inputStream = new FileInputStream(runPropsFile);){
            EnvironmentVariableUtil.loadPropertyWithEnvVar((Properties)runProps, (InputStream)inputStream, (String)runPropsFile);
            for (Map.Entry<Object, Object> entry : runProps.entrySet()) {
                if (!(entry.getValue() instanceof String)) continue;
                runProps.put(entry.getKey(), ((String)entry.getValue()).trim());
            }
            System.getProperties().putAll((Map<?, ?>)runProps);
        }
        catch (IOException e) {
            throw new IOException("Error loading properties from " + runPropsFile, e);
        }
    }

    public static void checkEnableBCFIPS() {
        if (PropertyInfo.isBCFIPSMode()) {
            BCFIPSStarter bcfipsStarter = BCFIPSStarter.forCommandLineUtility();
            bcfipsStarter.start();
        }
    }

    public static void loadHivemodule() throws IOException {
        try {
            HivemoduleGenerator.generateRuntimeHivemodule();
        }
        catch (Exception e) {
            throw new IOException("Failed to load hivemodule.xml", e);
        }
    }
}

