/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import com.pingidentity.common.util.PropertyInfo;
import difflib.Delta;
import difflib.DiffUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.EventDetailAuditLogger;

public class DiffUtil {
    private static final Logger log = LogManager.getLogger(DiffUtil.class);

    private DiffUtil() {
    }

    public static List<Delta> getDeltas(List<String> origXml, List<String> savedXml) {
        return DiffUtils.diff(origXml, savedXml).getDeltas();
    }

    public static List<String> fileToLines(String dir, String filename) {
        LinkedList<String> lines = new LinkedList<String>();
        File f = new File(dir, filename);
        String line = "";
        try (BufferedReader in2 = new BufferedReader(new FileReader(f));){
            while ((line = in2.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (FileNotFoundException in2) {
        }
        catch (IOException e) {
            log.error("An exception has occured while reading from " + filename, (Throwable)e);
        }
        return lines;
    }

    public static void generateDiff(String filename, List<String> origXml, List<String> savedXml) {
        List<Delta> deltas;
        if (StringUtils.isBlank((String)PropertyInfo.getOperationalModel()) || "CLUSTERED_ENGINE".equals(PropertyInfo.getOperationalModel())) {
            return;
        }
        if (ListUtils.isEqualList(origXml, savedXml)) {
            return;
        }
        AdminAuditLogger.setFilesModified();
        if (DiffUtil.isDiffRequired() && !(deltas = DiffUtil.getDeltas(origXml, savedXml)).isEmpty()) {
            EventDetailAuditLogger.log(deltas, filename);
        }
    }

    private static boolean isDiffRequired() {
        return PropertyInfo.isEventDetailLogging() && AdminAuditLogger.getEventDetailId() != null;
    }
}

