/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import com.pingidentity.common.util.Cache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.sourceid.saml20.state.ConsistentHashTracker;

public class DistributableCache<V>
extends Cache<String, V> {
    private static final long serialVersionUID = 1L;
    private ConsistentHashTracker tracker;
    private PartitionKeyMapper partitionKeyMapper = key -> key;

    public DistributableCache(long expiryPeriodMillis, int maxSize, boolean expireByAccessOrder, ConsistentHashTracker tracker) {
        super(expiryPeriodMillis, maxSize, 16, 0.75f, expireByAccessOrder);
        this.tracker = tracker;
    }

    public DistributableCache(long expiryPeriodMillis, int maxSize, boolean expireByAccessOrder, ConsistentHashTracker tracker, PartitionKeyMapper partitionKeyMapper) {
        this(expiryPeriodMillis, maxSize, 16, 0.75f, expireByAccessOrder, tracker, partitionKeyMapper);
    }

    public DistributableCache(long expiryPeriodMillis, int maxSize, int initialCapacity, float loadFactor, boolean expireByAccessOrder, ConsistentHashTracker tracker, PartitionKeyMapper partitionKeyMapper) {
        super(expiryPeriodMillis, maxSize, initialCapacity, loadFactor, expireByAccessOrder);
        this.tracker = tracker;
        this.partitionKeyMapper = partitionKeyMapper;
    }

    public Collection<String> getKeysForRange(int startHash, int endHashExclusive) {
        return this.tracker.getRange(startHash, endHashExclusive);
    }

    public Collection<Cache.Entry<String, V>> getEntriesForRange(int startHash, int endHashExclusive) {
        Collection<String> keys = this.tracker.getRange(startHash, endHashExclusive);
        ArrayList<Cache.Entry<String, V>> result = new ArrayList<Cache.Entry<String, V>>();
        for (String key : keys) {
            Cache.Entry entry = this.getEntry(key);
            if (entry == null) continue;
            result.add(entry);
        }
        return result;
    }

    public void removeRange(int startHash, int endHashExclusive) {
        Collection<String> keys = this.tracker.getRange(startHash, endHashExclusive);
        for (String key : keys) {
            this.remove(key);
        }
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    protected void onClear() {
        this.tracker.clear();
    }

    @Override
    protected void onEntryUpdated(String key, V value) {
        this.tracker.add(this.partitionKeyMapper.keyToPartitionKey(key), key);
    }

    @Override
    protected void onEntryRemoved(String key, V value) {
        this.tracker.remove(this.partitionKeyMapper.keyToPartitionKey(key), key);
    }

    public static interface PartitionKeyMapper
    extends Serializable {
        public String keyToPartitionKey(String var1);
    }
}

