/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;

public class DomainNameUtil {
    private static Set<String> domains = new HashSet<String>();
    private static final String DOT = ".";
    private static final String DOT_REGX = "[.]";

    public static String ascertainHigherLevelDomain(String hostname) {
        int lengthIdx;
        hostname = hostname.toLowerCase();
        String[] parts = hostname.split(DOT_REGX);
        int startIdx = 0;
        for (int i = lengthIdx = parts.length - 1; i >= 0; --i) {
            if (domains.contains(parts[i])) continue;
            startIdx = i;
            break;
        }
        if (startIdx == lengthIdx) {
            return hostname;
        }
        StringBuilder sb = new StringBuilder(hostname.length());
        for (int i = startIdx; i < parts.length; ++i) {
            if (i != 0 && i != startIdx) {
                sb.append(DOT);
            }
            sb.append(parts[i]);
        }
        return sb.toString();
    }

    private static byte[] getDataBytes() {
        String s = "# Data compiled from http://www.iana.org/ on 3/21/06\nac=Ascension Island\nad=Andorra\nae=United Arab Emirates\naf=Afghanistan\nag=Antigua and Barbuda\nai=Anguilla\nal=Albania\nam=Armenia\nan=Netherlands Antilles\nao=Angola\naq=Antarctica\nar=Argentina\nas=American Samoa\nat=Austria\nau=Australia\naw=Aruba\naz=Azerbaijan\nax=Aland Islands\nba=Bosnia and Herzegovina\nbb=Barbados\nbd=Bangladesh\nbe=Belgium\nbf=Burkina Faso\nbg=Bulgaria\nbh=Bahrain\nbi=Burundi\nbj=Benin\nbm=Bermuda\nbn=Brunei Darussalam\nbo=Bolivia\nbr=Brazil\nbs=Bahamas\nbt=Bhutan\nbv=Bouvet Island\nbw=Botswana\nby=Belarus\nbz=Belize\nca=Canada\ncc=Cocos (Keeling) Islands\ncd=Congo, The Democratic Republic of the\ncf=Central African Republic\ncg=Congo, Republic of\nch=Switzerland\nci=Cote d'Ivoire\nck=Cook Islands\ncl=Chile\ncm=Cameroon\ncn=China\nco=Colombia\ncr=Costa Rica\ncs=Serbia and Montenegro\ncu=Cuba\ncv=Cape Verde\ncx=Christmas Island\ncy=Cyprus\ncz=Czech Republic\nde=Germany\ndj=Djibouti\ndk=Denmark\ndm=Dominica\ndo=Dominican Republic\ndz=Algeria\nec=Ecuador\nee=Estonia\neg=Egypt\neh=Western Sahara\ner=Eritrea\nes=Spain\net=Ethiopia\neu=European Union\nfi=Finland\nfj=Fiji\nfk=Falkland Islands (Malvinas)\nfm=Micronesia, Federal State of\nfo=Faroe Islands\nfr=France\nga=Gabon\ngb=United Kingdom\ngd=Grenada\nge=Georgia\ngf=French Guiana\ngg=Guernsey\ngh=Ghana\ngi=Gibraltar\ngl=Greenland\ngm=Gambia\ngn=Guinea\ngp=Guadeloupe\ngq=Equatorial Guinea\ngr=Greece\ngs=South Georgia and the South Sandwich Islands\ngt=Guatemala\ngu=Guam\ngw=Guinea-Bissau\ngy=Guyana\nhk=Hong Kong\nhm=Heard and McDonald Islands\nhn=Honduras\nhr=Croatia/Hrvatska\nht=Haiti\nhu=Hungary\nid=Indonesia\nie=Ireland\nil=Israel\nim=Isle of Man\nin=India\nio=British Indian Ocean Territory\niq=Iraq\nir=Iran, Islamic Republic of\nis=Iceland\nit=Italy\nje=Jersey\njm=Jamaica\njo=Jordan\njp=Japan\nke=Kenya\nkg=Kyrgyzstan\nkh=Cambodia\nki=Kiribati\nkm=Comoros\nkn=Saint Kitts and Nevis\nkp=Korea, Democratic People's Republic\nkr=Korea, Republic of\nkw=Kuwait\nky=Cayman Islands\nkz=Kazakhstan\nla=Lao People's Democratic Republic\nlb=Lebanon\nlc=Saint Lucia\nli=Liechtenstein\nlk=Sri Lanka\nlr=Liberia\nls=Lesotho\nlt=Lithuania\nlu=Luxembourg\nlv=Latvia\nly=Libyan Arab Jamahiriya\nma=Morocco\nmc=Monaco\nmd=Moldova, Republic of\nmg=Madagascar\nmh=Marshall Islands\nmk=Macedonia, The Former Yugoslav Republic of\nml=Mali\nmm=Myanmar\nmn=Mongolia\nmo=Macau\nmp=Northern Mariana Islands\nmq=Martinique\nmr=Mauritania\nms=Montserrat\nmt=Malta\nmu=Mauritius\nmv=Maldives\nmw=Malawi\nmx=Mexico\nmy=Malaysia\nmz=Mozambique\nna=Namibia\nnc=New Caledonia\nne=Niger\nnf=Norfolk Island\nng=Nigeria\nni=Nicaragua\nnl=Netherlands\nno=Norway\nnp=Nepal\nnr=Nauru\nnu=Niue\nnz=New Zealand\nom=Oman\npa=Panama\npe=Peru\npf=French Polynesia\npg=Papua New Guinea\nph=Philippines\npk=Pakistan\npl=Poland\npm=Saint Pierre and Miquelon\npn=Pitcairn Island\npr=Puerto Rico\nps=Palestinian Territories\npt=Portugal\npw=Palau\npy=Paraguay\nqa=Qatar\nre=Reunion Island\nro=Romania\nru=Russian Federation\nrw=Rwanda\nsa=Saudi Arabia\nsb=Solomon Islands\nsc=Seychelles\nsd=Sudan\nse=Sweden\nsg=Singapore\nsh=Saint Helena\nsi=Slovenia\nsj=Svalbard and Jan Mayen Islands\nsk=Slovak Republic\nsl=Sierra Leone\nsm=San Marino\nsn=Senegal\nso=Somalia\nsr=Suriname\nst=Sao Tome and Principe\nsv=El Salvador\nsy=Syrian Arab Republic\nsz=Swaziland\ntc=Turks and Caicos Islands\ntd=Chad\ntf=French Southern Territories\ntg=Togo\nth=Thailand\ntj=Tajikistan\ntk=Tokelau\ntl=Timor-Leste\ntm=Turkmenistan\ntn=Tunisia\nto=Tonga\ntp=East Timor\ntr=Turkey\ntt=Trinidad and Tobago\ntv=Tuvalu\ntw=Taiwan\ntz=Tanzania\nua=Ukraine\nug=Uganda\nuk=United Kingdom\num=United States Minor Outlying Islands\nus=United States\nuy=Uruguay\nuz=Uzbekistan\nva=Holy See (Vatican City State)\nvc=Saint Vincent and the Grenadines\nve=Venezuela\nvg=Virgin Islands, British\nvi=Virgin Islands, US\nvn=Vietnam\nvu=Vanuatu\nwf=Wallis and Futuna Islands\nws=Western Samoa\nye=Yemen\nyt=Mayotte\nyu=Yugoslavia\nza=South Africa\nzm=Zambia\nzw=Zimbabwe\naero=domain is reserved for members of the air-transport industry and is sponsored by Societe Internationale de Telecommunications Aeronautiques (SITA).\nbiz=domain is restricted to businesses and is operated by NeuLevel, Inc.\ncat=domain is reserved for the Catalan linguistic and cultural community and is sponsored by Fundacio puntCat\ncom=domain is operated by VeriSign Global Registry Services.\ncoop=domain is reserved for cooperative associations and is sponsored by Dot Cooperation LLC.\ninfo=domain is operated by Afilias Limited.\njobs=domain is reserved for human resource managers and is sponsored by Employ Media LLC.\nmobi=domain is reserved for consumers and providers of mobile products and services and is sponsored by mTLD Top Level=domain, Ltd.\nmuseum=domain is reserved for museums and is sponsored by the Museum=domain Management Association.\nname=domain is reserved for individuals and is operated by Global Name Registry.\nnet=domain is operated by VeriSign Global Registry Services.\norg=domain is operated by Public Interest Registry. It is intended to serve the noncommercial community, but all are eligible to register within .org.\npro=domain is restricted to credentialed professionals and related entities and is operated by RegistryPro.\ntravel=domain is reserved for entities whose primary area of activity is in the travel industry and is sponsored by Tralliance Corporation.\ngov=is reserved exclusively for the United States Government. It is operated by the US General Services Administration.\nedu=is reserved for postsecondary institutions accredited by an agency on the U.S. Department of Education's list of Nationally Recognized Accrediting Agencies and is registered only through Educause.\nmil=is reserved exclusively for the United States Military. It is operated by the US DoD Network Information Center.\nint=is used only for registering organizations established by international treaties between governments. It is operated by the IANA .int Domain Registry.";
        ConfigStore config = ConfigStoreFarm.getConfig(DomainNameUtil.class);
        s = config.getStringValue("top-level-domain-props", s);
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Properties props = new Properties();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(DomainNameUtil.getDataBytes());
        try {
            props.load(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("This shouldn't happen", e);
        }
        for (Object key : props.keySet()) {
            String part = (String)key;
            domains.add(part.trim().toLowerCase());
        }
    }
}

