/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.xmlbeans.impl.common.XMLChar;

public class HTMLEncoder {
    public static String encode(String s) {
        if (s == null) {
            return s;
        }
        StringBuilder builder = new StringBuilder(s.length() * 2);
        int startEnc = 0;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (XMLChar.isHighSurrogate((int)ch)) {
                char ch2;
                if (i + 1 >= s.length() || !XMLChar.isLowSurrogate((int)(ch2 = s.charAt(i + 1)))) continue;
                if (startEnc < i) {
                    builder.append(StringEscapeUtils.escapeHtml((String)s.substring(startEnc, i)));
                }
                int hexCharEntity = (ch - 55296) * 1024 + (ch2 - 56320) + 65536;
                builder.append("&#");
                builder.append(String.valueOf(hexCharEntity));
                builder.append(';');
                startEnc = i + 2;
                ++i;
                continue;
            }
            if (ch == '\'') {
                if (startEnc < i) {
                    builder.append(StringEscapeUtils.escapeHtml((String)s.substring(startEnc, i)));
                }
                builder.append("&#x27;");
                startEnc = i + 1;
                continue;
            }
            if (ch != '/') continue;
            if (startEnc < i) {
                builder.append(StringEscapeUtils.escapeHtml((String)s.substring(startEnc, i)));
            }
            builder.append("&#x2F;");
            startEnc = i + 1;
        }
        if (startEnc < s.length()) {
            builder.append(StringEscapeUtils.escapeHtml((String)s.substring(startEnc)));
        }
        return builder.toString();
    }
}

