/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import java.net.UnknownHostException;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public final class HostAddressUtils {
    private static Pattern VALID_IPV4_PATTERN;
    private static Pattern VALID_IPV6_PATTERN;
    private static Pattern VALID_PORT_PATTERN;
    private static Pattern VALID_DOMAIN_NAME_PATTERN;
    private static String COLON;
    private static String CLOSE_BRACKET_AND_COLON;
    private static final String IPV4_PATTERN = "(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])";
    private static final String IPV6_PATTERN = "^(((?=(?>.*?::)(?!.*::)))(::)?([0-9A-F]{1,4}::?){0,5}|([0-9A-F]{1,4}:){6})(\\2([0-9A-F]{1,4}(::?|$)){0,2}|((25[0-5]|(2[0-4]|1\\d|[1-9])?\\d)(\\.|$)){4}|[0-9A-F]{1,4}:[0-9A-F]{1,4})(?<![^:]:|\\.)\\z";
    private static final String PORT_REGEX = "^(6553[0-5]|655[0-2]\\d|65[0-4]\\d{2}|6[0-4]\\d{3}|[1-5]\\d{4}|[1-9]\\d{0,3})$";
    private static final String DOMAIN_NAME_REGEX = "(?=.*[a-z])(?!.*--)^([a-z0-9]|\\*\\.[a-z0-9][a-z0-9\\-]*[a-z0-9]|[a-z0-9][a-z0-9\\-]*[a-z0-9])(\\.([a-z0-9]|[a-z0-9][a-z0-9\\-]*[a-z0-9]))*$";

    private static boolean isIP4Address(String ip) {
        return VALID_IPV4_PATTERN.matcher(ip).matches();
    }

    private static boolean isIPV6Address(String ip) {
        return VALID_IPV6_PATTERN.matcher(ip).matches();
    }

    private static boolean validatePortNumber(String port) {
        return VALID_PORT_PATTERN.matcher(port).matches();
    }

    public static boolean isIPV4Literal(String ipAddress) {
        if (StringUtils.isNotBlank((String)ipAddress)) {
            IpAndPortPair ipAndPortPair = IpAndPortPair.parse(ipAddress);
            return ipAndPortPair.isValidIpV4Address() && ipAndPortPair.isPortStringAbsent();
        }
        return false;
    }

    public static boolean isIPV6Literal(String ipAddress) {
        if (StringUtils.isNotBlank((String)ipAddress)) {
            IpAndPortPair ipAndPortPair = IpAndPortPair.parse(ipAddress);
            return ipAndPortPair.isValidIpV6Address() && ipAndPortPair.isPortStringAbsent();
        }
        return false;
    }

    public static boolean isValidDomainName(String domainName) {
        if (StringUtils.isNotBlank((String)domainName)) {
            return VALID_DOMAIN_NAME_PATTERN.matcher(domainName).find();
        }
        return false;
    }

    public static boolean isValidIpAddressAndPort(String addressString) {
        Objects.requireNonNull(addressString, "ip");
        IpAndPortPair ipAndPortPair = IpAndPortPair.parse(addressString);
        return ipAndPortPair.isValid();
    }

    public static String getIpAddress(String ipAndPortAddress) throws UnknownHostException {
        Objects.requireNonNull(ipAndPortAddress, "ip");
        IpAndPortPair ipAndPortPair = IpAndPortPair.parse(ipAndPortAddress);
        if (!ipAndPortPair.isValid()) {
            throw new UnknownHostException(ipAndPortAddress + " in not a valid IP address");
        }
        return ipAndPortPair.ipString;
    }

    static {
        COLON = ":";
        CLOSE_BRACKET_AND_COLON = "]:";
        VALID_IPV4_PATTERN = Pattern.compile(IPV4_PATTERN, 2);
        VALID_IPV6_PATTERN = Pattern.compile(IPV6_PATTERN, 2);
        VALID_PORT_PATTERN = Pattern.compile(PORT_REGEX, 2);
        VALID_DOMAIN_NAME_PATTERN = Pattern.compile(DOMAIN_NAME_REGEX, 2);
    }

    private static class IpAndPortPair {
        String ipString;
        String portString;

        private IpAndPortPair(String ipString, String portString) {
            this.ipString = ipString;
            this.portString = portString;
        }

        private static boolean isPossiblyIPv6(String addressString) {
            int secondColonIndex;
            int firstColonIndex = addressString.indexOf(58);
            return firstColonIndex != (secondColonIndex = addressString.lastIndexOf(58)) && firstColonIndex >= 0;
        }

        private static String[] splitAddressStringByPortDelimiter(String addressString) {
            String[] delimitedString = IpAndPortPair.isPossiblyIPv6(addressString) ? addressString.split(CLOSE_BRACKET_AND_COLON) : addressString.split(COLON);
            return delimitedString;
        }

        private static IpAndPortPair parse(String addressString) {
            String[] delimitedString;
            String ipString = null;
            String portString = null;
            if (IpAndPortPair.isPossiblyIPv6(addressString) && addressString.endsWith(CLOSE_BRACKET_AND_COLON) || !IpAndPortPair.isPossiblyIPv6(addressString) && addressString.endsWith(COLON)) {
                portString = "";
            }
            if ((delimitedString = IpAndPortPair.splitAddressStringByPortDelimiter(addressString)).length == 1) {
                ipString = delimitedString[0].trim();
                if (IpAndPortPair.isPossiblyIPv6(ipString)) {
                    ipString = ipString.replaceFirst("^\\[", "").replaceFirst("]$", "");
                }
            } else if (delimitedString.length == 2) {
                ipString = delimitedString[0].trim().replaceFirst("^\\[", "");
                portString = delimitedString[1].trim();
            }
            return new IpAndPortPair(ipString, portString);
        }

        private boolean isValidIpV4Address() {
            return this.ipString != null && HostAddressUtils.isIP4Address(this.ipString);
        }

        private boolean isValidIpV6Address() {
            return this.ipString != null && HostAddressUtils.isIPV6Address(this.ipString);
        }

        private boolean isValidPort() {
            return !this.isPortStringAbsent() && HostAddressUtils.validatePortNumber(this.portString);
        }

        private boolean isPortStringAbsent() {
            return this.portString == null;
        }

        private boolean isValid() {
            return !(!this.isValidIpV4Address() && !this.isValidIpV6Address() || !this.isPortStringAbsent() && !this.isValidPort());
        }
    }
}

