/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.configservice.SysInfoHelper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.KerberosRealm;
import org.sourceid.saml20.domain.KerberosRealmsSettings;

public class KerberosConfigUtil {
    private static final Logger log = LogManager.getLogger(KerberosConfigUtil.class);
    private static final String NEW_LINE = System.lineSeparator();
    private static final ConfigStore configStore = ConfigStoreFarm.getConfig(KerberosConfigUtil.class);

    public static boolean isAutoGenerateKrb5ConfFile() {
        return configStore.getBooleanValue("AutoGenerateKrb5Conf", true);
    }

    public static File getKrb5ConfFile() {
        return KerberosConfigUtil.getKrb5ConfFile("");
    }

    public static File getKrb5ConfFile(String extension) {
        SysDirInfo sysDirInfo = SysInfoHelper.getSysDirInfo();
        return new File(sysDirInfo.getDataDirectory(), "krb5.conf" + (String)(StringUtils.isEmpty((String)extension) ? "" : "." + extension));
    }

    public static void restoreKrb5ConfFile(String extension) {
        try {
            if (KerberosConfigUtil.getKrb5ConfFile(extension).exists()) {
                if (KerberosConfigUtil.getKrb5ConfFile().exists()) {
                    KerberosConfigUtil.getKrb5ConfFile().delete();
                }
                FileUtils.moveFile((File)KerberosConfigUtil.getKrb5ConfFile(extension), (File)KerberosConfigUtil.getKrb5ConfFile());
            }
        }
        catch (IOException e) {
            String message = "Error restoring krb5.conf file";
            log.error((Object)String.format("%s: %s", message, e.getMessage()));
            log.debug((Object)message, (Throwable)e);
        }
    }

    public static void backupKrb5ConfFile(String extension) {
        if (KerberosConfigUtil.getKrb5ConfFile(extension).exists()) {
            KerberosConfigUtil.getKrb5ConfFile(extension).delete();
        }
        try {
            FileUtils.moveFile((File)KerberosConfigUtil.getKrb5ConfFile(), (File)KerberosConfigUtil.getKrb5ConfFile(extension));
        }
        catch (IOException e) {
            String message = "Error backing up krb5.conf file";
            log.error((Object)String.format("%s: %s", message, e.getMessage()));
            log.debug((Object)message, (Throwable)e);
        }
    }

    public static void setKrb5ConfSystemProperty() {
        System.setProperty("java.security.krb5.conf", KerberosConfigUtil.getKrb5ConfFile().getAbsolutePath());
    }

    public static void updateKrb5Conf(Collection<KerberosRealm> kerberosRealms, KerberosRealmsSettings kerberosRealmsSettings) {
        LinkedList<KerberosRealm> kerberosRealmsList = new LinkedList<KerberosRealm>();
        for (KerberosRealm kerberosRealm : kerberosRealms) {
            if (!kerberosRealm.isDefaultRealm()) continue;
            kerberosRealmsList.add(kerberosRealm);
        }
        for (KerberosRealm kerberosRealm : kerberosRealms) {
            if (kerberosRealmsList.contains(kerberosRealm)) continue;
            kerberosRealmsList.add(kerberosRealm);
        }
        try {
            String encryptionTypes;
            FileWriter updatedKrb5 = new FileWriter(KerberosConfigUtil.getKrb5ConfFile("new"));
            updatedKrb5.write("[libdefaults]" + NEW_LINE);
            String firstDomainNameFQDN = "xxx.yyy.com";
            if (!kerberosRealmsList.isEmpty()) {
                firstDomainNameFQDN = ((KerberosRealm)kerberosRealmsList.get(0)).getKerberosRealmName();
            }
            updatedKrb5.write("\tdefault_realm = " + firstDomainNameFQDN.toUpperCase() + NEW_LINE);
            updatedKrb5.write(NEW_LINE);
            updatedKrb5.write("\tkdc_timeout = " + kerberosRealmsSettings.getKdcTimeout() + NEW_LINE);
            updatedKrb5.write("\tmax_retries = " + kerberosRealmsSettings.getKdcRetries() + NEW_LINE);
            boolean forceTcp = Boolean.parseBoolean(kerberosRealmsSettings.getForceTcp());
            if (forceTcp) {
                updatedKrb5.write("\tudp_preference_limit = 1" + NEW_LINE);
                updatedKrb5.write(NEW_LINE);
            }
            if (StringUtils.isNotEmpty((String)(encryptionTypes = PropertyInfo.isBCFIPSMode() ? configStore.getStringValue("FipsEncryptionTypes", "aes256-cts aes128-cts aes256-sha2 aes128-sha2") : configStore.getStringValue("EncryptionTypes", "")))) {
                updatedKrb5.write("\tdefault_tkt_enctypes = " + encryptionTypes + NEW_LINE);
                updatedKrb5.write("\tdefault_tgs_enctypes = " + encryptionTypes + NEW_LINE);
                updatedKrb5.write("\tpermitted_enctypes = " + encryptionTypes + NEW_LINE);
            }
            updatedKrb5.write("[realms]" + NEW_LINE);
            for (KerberosRealm kerberosRealm : kerberosRealms) {
                updatedKrb5.write("\t" + kerberosRealm.getKerberosRealmName().toUpperCase() + " = {" + NEW_LINE);
                for (String keyDistributionCenter : kerberosRealm.getKeyDistributionCenters()) {
                    if (!kerberosRealm.isSuppressDomainNameConcatenation()) {
                        updatedKrb5.write("\t\tkdc = " + keyDistributionCenter + "." + kerberosRealm.getKerberosRealmName() + NEW_LINE);
                        continue;
                    }
                    updatedKrb5.write("\t\tkdc = " + keyDistributionCenter + NEW_LINE);
                }
                updatedKrb5.write("\t}" + NEW_LINE);
            }
            updatedKrb5.write(NEW_LINE);
            updatedKrb5.write("[domain_realm]" + NEW_LINE);
            for (KerberosRealm kerberosRealm : kerberosRealms) {
                String domainNameFQDN = kerberosRealm.getKerberosRealmName();
                updatedKrb5.write("\t." + domainNameFQDN.toLowerCase() + " = " + domainNameFQDN.toUpperCase() + NEW_LINE);
            }
            updatedKrb5.write(NEW_LINE);
            updatedKrb5.write("[appdefaults]" + NEW_LINE);
            updatedKrb5.write(NEW_LINE);
            updatedKrb5.close();
            KerberosConfigUtil.getKrb5ConfFile().delete();
            KerberosConfigUtil.restoreKrb5ConfFile("new");
        }
        catch (IOException e) {
            String message = "Error updating krb5.conf file";
            log.error((Object)String.format("%s: %s", message, e.getMessage()));
            log.debug((Object)message, (Throwable)e);
        }
    }

    public static void createKrb5Conf() throws IOException {
        FileWriter krb5Conf = new FileWriter(KerberosConfigUtil.getKrb5ConfFile());
        krb5Conf.write("[libdefaults]" + NEW_LINE);
        krb5Conf.write(NEW_LINE);
        krb5Conf.write("[realms]" + NEW_LINE);
        krb5Conf.write(NEW_LINE);
        krb5Conf.write(NEW_LINE);
        krb5Conf.write("[domain_realm]" + NEW_LINE);
        krb5Conf.write(NEW_LINE);
        krb5Conf.write(NEW_LINE);
        krb5Conf.write("[appdefaults]" + NEW_LINE);
        krb5Conf.close();
    }
}

