/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import com.pingidentity.common.security.KerberosException;
import com.pingidentity.common.util.ldap.LDAPUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.security.auth.kerberos.KerberosKey;
import jcifs.spnego.asn1.ASN1OctetString;
import jcifs.spnego.asn1.ASN1Sequence;
import jcifs.spnego.asn1.ASN1TaggedObject;
import jcifs.spnego.asn1.DERBitString;
import jcifs.spnego.asn1.DERInputStream;
import jcifs.spnego.asn1.DERObjectIdentifier;
import jcifs.spnego.asn1.DERUnknownTag;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaaslounge.decoding.DecodingException;
import org.jaaslounge.decoding.kerberos.KerberosAuthData;
import org.jaaslounge.decoding.kerberos.KerberosPacAuthData;
import org.jaaslounge.decoding.kerberos.KerberosToken;
import org.jaaslounge.decoding.pac.PacLogonInfo;
import org.jaaslounge.decoding.pac.PacSid;

public class KerberosTokenUtil {
    private static final Log log = LogFactory.getLog(KerberosTokenUtil.class);
    private static final String KERBEROS_V5_LEGACY_OID = "1.2.840.48018.1.2.2";
    private static final String KERBEROS_V5_OID = "1.2.840.113554.1.2.2";

    public static byte[] extractKerberosToken(byte[] spnegoToken) throws KerberosException {
        SpnegoParser spnegoParser = new SpnegoParser();
        try {
            spnegoParser.parse(spnegoToken);
        }
        catch (IOException e) {
            throw new KerberosException(e);
        }
        boolean supportedMechanism = false;
        for (String mechanismOid : spnegoParser.getMechanisms()) {
            if (!KERBEROS_V5_LEGACY_OID.equals(mechanismOid) && !KERBEROS_V5_OID.equals(mechanismOid)) continue;
            supportedMechanism = true;
            break;
        }
        if (!supportedMechanism) {
            String message = "SPNEGO token does not contain a kerberos token";
            log.error((Object)message);
            throw new KerberosException(message);
        }
        return spnegoParser.getMechanismToken();
    }

    static KerberosSids extractSids(byte[] token, Set<KerberosKey> keys) {
        KerberosToken kerberosToken;
        try {
            kerberosToken = new KerberosToken(token, keys.toArray(new KerberosKey[0]));
        }
        catch (DecodingException e) {
            log.warn((Object)("Unable to decode kerberos token." + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unable to decode kerberos token.", (Throwable)e);
            }
            return new KerberosSids(null, Collections.emptySet());
        }
        String objectSid = null;
        TreeSet<String> sids = new TreeSet<String>();
        List authorizations = kerberosToken.getTicket().getEncData().getUserAuthorizations();
        for (KerberosAuthData authorization : authorizations) {
            String sid;
            PacLogonInfo logonInfo;
            if (!(authorization instanceof KerberosPacAuthData) || (logonInfo = ((KerberosPacAuthData)authorization).getPac().getLogonInfo()) == null) continue;
            if (logonInfo.getUserSid() != null) {
                objectSid = LDAPUtil.convertBinarySidToString(logonInfo.getUserSid().getBytes());
            }
            if (logonInfo.getGroupSid() != null) {
                String sid2 = LDAPUtil.convertBinarySidToString(logonInfo.getGroupSid().getBytes());
                sids.add(sid2);
            }
            if (logonInfo.getGroupSids() != null) {
                for (PacSid pacSid : logonInfo.getGroupSids()) {
                    sid = LDAPUtil.convertBinarySidToString(pacSid.getBytes());
                    sids.add(sid);
                }
            }
            if (logonInfo.getExtraSids() != null) {
                for (PacSid pacSid : logonInfo.getExtraSids()) {
                    sid = LDAPUtil.convertBinarySidToString(pacSid.getBytes());
                    sids.add(sid);
                }
            }
            if (logonInfo.getResourceGroupSids() == null) continue;
            for (PacSid pacSid : logonInfo.getResourceGroupSids()) {
                sid = LDAPUtil.convertBinarySidToString(pacSid.getBytes());
                sids.add(sid);
            }
        }
        return new KerberosSids(objectSid, sids);
    }

    static class KerberosSids {
        private final String objectSid;
        private final Set<String> sids;

        KerberosSids(String objectSid, Set<String> sids) {
            this.objectSid = objectSid;
            this.sids = sids;
        }

        String getObjectSid() {
            return this.objectSid;
        }

        Set<String> getSids() {
            return this.sids;
        }
    }

    private static class SpnegoParser {
        private static final String SPNEGO_OID = "1.3.6.1.5.5.2";
        private byte[] mechanismToken;
        private byte[] mechanismListMIC;
        private String[] mechanisms;
        private int contextFlags;

        private SpnegoParser() {
        }

        public void parse(byte[] token) throws IOException {
            ByteArrayInputStream tokenStream = new ByteArrayInputStream(token);
            DERInputStream der = new DERInputStream((InputStream)tokenStream);
            DERUnknownTag constructed = (DERUnknownTag)der.readObject();
            if (constructed.getTag() != 96) {
                throw new IOException("Malformed NegTokenInit.");
            }
            tokenStream = new ByteArrayInputStream(constructed.getData());
            der = new DERInputStream((InputStream)tokenStream);
            DERObjectIdentifier spnego = (DERObjectIdentifier)der.readObject();
            if (!SPNEGO_OID.equals(spnego.getId())) {
                throw new IOException("Not valid SPNEGO token.");
            }
            ASN1TaggedObject tagged = (ASN1TaggedObject)der.readObject();
            ASN1Sequence sequence = ASN1Sequence.getInstance((ASN1TaggedObject)tagged, (boolean)true);
            Enumeration fields = sequence.getObjects();
            block6: while (fields.hasMoreElements()) {
                tagged = (ASN1TaggedObject)fields.nextElement();
                switch (tagged.getTagNo()) {
                    case 0: {
                        sequence = ASN1Sequence.getInstance((ASN1TaggedObject)tagged, (boolean)true);
                        String[] mechanisms = new String[sequence.size()];
                        for (int i = mechanisms.length - 1; i >= 0; --i) {
                            DERObjectIdentifier mechanism = (DERObjectIdentifier)sequence.getObjectAt(i);
                            mechanisms[i] = mechanism.getId();
                        }
                        this.setMechanisms(mechanisms);
                        continue block6;
                    }
                    case 1: {
                        DERBitString contextFlags = DERBitString.getInstance((ASN1TaggedObject)tagged, (boolean)true);
                        this.setContextFlags(contextFlags.getBytes()[0] & 0xFF);
                        continue block6;
                    }
                    case 2: {
                        ASN1OctetString mechanismToken = ASN1OctetString.getInstance((ASN1TaggedObject)tagged, (boolean)true);
                        this.setMechanismToken(mechanismToken.getOctets());
                        continue block6;
                    }
                    case 3: {
                        ASN1OctetString mechanismListMIC = ASN1OctetString.getInstance((ASN1TaggedObject)tagged, (boolean)true);
                        this.setMechanismListMIC(mechanismListMIC.getOctets());
                        continue block6;
                    }
                }
                throw new IOException("Malformed token field.");
            }
        }

        public byte[] getMechanismListMIC() {
            return this.mechanismListMIC;
        }

        public void setMechanismListMIC(byte[] mechanismListMIC) {
            this.mechanismListMIC = mechanismListMIC;
        }

        public byte[] getMechanismToken() {
            return this.mechanismToken;
        }

        public void setMechanismToken(byte[] mechanismToken) {
            this.mechanismToken = mechanismToken;
        }

        public String[] getMechanisms() {
            return this.mechanisms;
        }

        public void setMechanisms(String[] mechanisms) {
            this.mechanisms = mechanisms;
        }

        public int getContextFlags() {
            return this.contextFlags;
        }

        public void setContextFlags(int contextFlags) {
            this.contextFlags = contextFlags;
        }
    }
}

