/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import com.pingidentity.common.util.HostnameValidation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.SourceType;
import org.sourceid.saml20.domain.UserProvisioning;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.sp.ProvisioningException;

public class LDAPUtil {
    private static final Log log = LogFactory.getLog(LDAPUtil.class);
    private static ConfigStore configStore = ConfigStoreFarm.getConfig(LDAPUtil.class);
    private static final String NO_FILTER_ERROR = "No username was provided through the filter parameter in the Admin Console.  Therefore, LDAPUtil could NOT provision the user.";
    private static boolean skipSchemaRetrieval = configStore.getBooleanValue("SkipSchemaRetrieval", false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void doLDAPModifyUser(UserProvisioning userProvisioning, Attributes attrsToModifyUser, AttributeMap attrsFromIdp) throws NamingException {
        block5: {
            try (Context dirContext = null;){
                LdapDataSource ldapDataSrc = (LdapDataSource)userProvisioning.getAttributeSource().getDataSource();
                ConnectionInfo connInfo = new ConnectionInfo(ldapDataSrc.getConnectionInfo());
                dirContext = new InitialDirContext(LDAPUtil.prepareProperties(connInfo));
                AttributeSource attrSource = userProvisioning.getAttributeSource();
                String username = attrSource.getParameter("filter");
                if (!StringUtils.isBlank((String)username)) {
                    Name newName = LDAPUtil.getLdapName(attrSource, attrsFromIdp);
                    dirContext.modifyAttributes(newName, 2, attrsToModifyUser);
                    log.debug((Object)("User: " + newName.toString() + " successfully modified in the LDAP datastore"));
                    break block5;
                }
                throw new ProvisioningException(NO_FILTER_ERROR);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void doLDAPAddUser(UserProvisioning userProvisioning, Attributes attrsToProvisionUser, AttributeMap attrsFromIdp) throws NamingException {
        block5: {
            try (Context dirContext = null;){
                LdapDataSource ldapDataSrc = (LdapDataSource)userProvisioning.getAttributeSource().getDataSource();
                ConnectionInfo connInfo = new ConnectionInfo(ldapDataSrc.getConnectionInfo());
                dirContext = new InitialDirContext(LDAPUtil.prepareProperties(connInfo));
                AttributeSource attrSource = userProvisioning.getAttributeSource();
                String username = attrSource.getParameter("filter");
                if (!StringUtils.isBlank((String)username)) {
                    Name newName = LDAPUtil.getLdapName(attrSource, attrsFromIdp);
                    dirContext.createSubcontext(newName, attrsToProvisionUser);
                    log.debug((Object)("User: " + newName.toString() + " successfully added to the LDAP datastore"));
                    break block5;
                }
                throw new ProvisioningException(NO_FILTER_ERROR);
            }
        }
    }

    public static Attributes loadAttrs(AttributeMap srcAttrs) {
        BasicAttributes attrsToProvisionUser = new BasicAttributes(false);
        for (Map.Entry e : srcAttrs.entrySet()) {
            BasicAttribute basicAttr = new BasicAttribute((String)e.getKey());
            for (String v : ((AttributeValue)e.getValue()).getValues()) {
                basicAttr.add(v);
            }
            attrsToProvisionUser.put(basicAttr);
        }
        return attrsToProvisionUser;
    }

    private static Name getLdapName(AttributeSource attrSrc, AttributeMap attrsFromIdp) throws NamingException {
        AttributeMap tempMap;
        String username = attrSrc.getParameter("filter");
        String baseDN = attrSrc.getParameter("search_base");
        String userDN = !StringUtils.isBlank((String)baseDN) ? username + "," + baseDN : username;
        ArrayList<AttrMappingValue> userDNList = new ArrayList<AttrMappingValue>();
        userDNList.add(new AttrMappingValue(SourceType.TEXT, userDN));
        HashMap<String, List<AttrMappingValue>> userDNMap = new HashMap<String, List<AttrMappingValue>>();
        userDNMap.put("filter", userDNList);
        UserProvisioning tempUserProvisioning = new UserProvisioning();
        tempUserProvisioning.setAttributeMap2(userDNMap);
        try {
            tempMap = tempUserProvisioning.executeMapping(attrsFromIdp, tempUserProvisioning.getAttributeMapping().keySet());
        }
        catch (AuthorizationException attrEx) {
            throw new ProvisioningException(attrEx.getErrorDetail(), attrEx);
        }
        catch (AttrLookupException attrEx) {
            throw new ProvisioningException("There was a problem translating text values in the User DN: " + userDN);
        }
        return new LdapName(((AttributeValue)tempMap.get((Object)"filter")).getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NamingEnumeration doLDAPSearch(ConnectionInfo connInfo, String searchBase, String filter, int searchScope, String[] attrs, int countLimit) throws NamingException {
        NamingEnumeration<SearchResult> namingEnumeration = null;
        try (Context dirContext = null;){
            Properties props = LDAPUtil.prepareProperties(connInfo);
            props.put("com.sun.jndi.ldap.connect.pool", "true");
            dirContext = new InitialDirContext(props);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(searchScope);
            searchControls.setCountLimit(countLimit);
            if (attrs != null) {
                searchControls.setReturningAttributes(attrs);
            }
            namingEnumeration = dirContext.search(searchBase, filter, searchControls);
        }
        return namingEnumeration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Attributes doLDAPSchemaSearch(ConnectionInfo connInfo, String objectClass) throws NamingException {
        Attributes schemaAttrs = null;
        try (Context dirContext = null;){
            Properties props = LDAPUtil.prepareProperties(connInfo);
            dirContext = new InitialDirContext(props);
            if (!skipSchemaRetrieval) {
                DirContext schemaContext = dirContext.getSchema("");
                DirContext schema = (DirContext)schemaContext.lookup("ClassDefinition/" + objectClass);
                schemaAttrs = schema.getAttributes("");
            }
        }
        return schemaAttrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getLDAPAttributeList(ConnectionInfo connInfo) throws NamingException {
        ArrayList<String> attrs = new ArrayList<String>();
        try (Context dirContext = null;){
            Properties props = LDAPUtil.prepareProperties(connInfo);
            dirContext = new InitialDirContext(props);
            if (!skipSchemaRetrieval) {
                DirContext schemaContext = dirContext.getSchema("");
                DirContext attrDef = (DirContext)schemaContext.lookup("AttributeDefinition");
                NamingEnumeration<NameClassPair> ne = attrDef.list("");
                while (ne.hasMore()) {
                    attrs.add(ne.next().getName());
                }
            }
        }
        return attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getObjectClasses(ConnectionInfo connInfo, String entryName) throws NamingException {
        ArrayList<String> objClassNames = new ArrayList<String>();
        try (Context dirContext = null;){
            Properties props = LDAPUtil.prepareProperties(connInfo);
            dirContext = new InitialDirContext(props);
            DirContext relatedClasses = dirContext.getSchemaClassDefinition(entryName);
            NamingEnumeration<SearchResult> nameEnum = relatedClasses.search("", null);
            while (nameEnum.hasMore()) {
                objClassNames.add(((NameClassPair)nameEnum.next()).getName());
            }
        }
        return objClassNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getAllObjectClasses(ConnectionInfo connInfo) throws NamingException {
        ArrayList<String> attrs = new ArrayList<String>();
        try (Context dirContext = null;){
            Properties props = LDAPUtil.prepareProperties(connInfo);
            dirContext = new InitialDirContext(props);
            if (!skipSchemaRetrieval) {
                DirContext schemaContext = dirContext.getSchema("");
                DirContext attrDef = (DirContext)schemaContext.lookup("ClassDefinition");
                NamingEnumeration<NameClassPair> nameEnum = attrDef.list("");
                while (nameEnum.hasMore()) {
                    attrs.add(nameEnum.next().getName());
                }
            }
        }
        return attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doLdapAuthentication(ConnectionInfo connInfo, String name, String password) throws NamingException {
        try (Context dirContext = null;){
            Properties props = LDAPUtil.prepareProperties(connInfo);
            props.put("java.naming.security.principal", name);
            if (password == null) {
                props.remove("java.naming.security.credentials");
            } else {
                props.put("java.naming.security.credentials", password);
            }
            props.put("java.naming.security.authentication", "simple");
            dirContext = new InitialDirContext(props);
        }
    }

    private static Properties prepareProperties(ConnectionInfo connInfo) throws NamingException {
        HostnameValidation.validateLdapsHostname(connInfo.getServerUrl());
        Properties props = new Properties();
        props.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        props.put("java.naming.provider.url", connInfo.getServerUrl());
        props.put("java.naming.security.authentication", connInfo.getAuthenticationMethod());
        if (connInfo.getPrincipal() != null) {
            props.put("java.naming.security.principal", connInfo.getPrincipal());
        }
        if (connInfo.getCredentials() != null) {
            props.put("java.naming.security.credentials", connInfo.getCredentials());
        }
        String connectionTimeout = configStore.getStringValue("ConnectionTimeoutInMs", "3000");
        props.put("com.sun.jndi.ldap.connect.timeout", connectionTimeout);
        return props;
    }

    @Deprecated
    public static String[] splitServerUrls(String serverUrls) {
        return com.pingidentity.common.util.ldap.LDAPUtil.splitServerUrls(serverUrls);
    }

    public static class ConnectionInfo {
        private String serverUrl;
        private String authenticationMethod;
        private String principal;
        private String credentials;

        public ConnectionInfo(String serverUrl, String authenticationMethod, String principal, String credentials) {
            this.serverUrl = serverUrl;
            this.authenticationMethod = authenticationMethod;
            this.principal = principal;
            this.credentials = credentials;
        }

        public ConnectionInfo(com.pingidentity.common.util.ldap.ConnectionInfo other) {
            this(other.getServerUrl(), other.getAuthenticationMethod(), other.getPrincipal(), other.getCredentials());
        }

        public String getServerUrl() {
            return this.serverUrl;
        }

        public String getAuthenticationMethod() {
            return this.authenticationMethod;
        }

        public String getPrincipal() {
            return this.principal;
        }

        public String getCredentials() {
            return this.credentials;
        }
    }
}

