/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import com.pingidentity.common.util.ognl.ExpressionCalculator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ognl.ASTMethod;
import ognl.ASTThisVarRef;
import ognl.Node;
import ognl.OgnlException;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.SourceContextType;

public class OgnlHelper {
    private List<String> list;
    private String prefix;

    public OgnlHelper() {
        this.list = new ArrayList<String>();
        this.prefix = "";
    }

    public OgnlHelper(String prefix) {
        this.list = new ArrayList<String>();
        this.prefix = prefix;
    }

    public OgnlHelper(List<String> list, String prefix) {
        this.list = list;
        this.prefix = prefix;
    }

    public void searchForDataColumns(Object tree) {
        this.searchForAllVariableNames(tree, true);
    }

    public void searchForAllVariableNames(Object tree) {
        this.searchForAllVariableNames(tree, false);
    }

    private void searchForAllVariableNames(Object tree, boolean hasPrefix) {
        Node node = (Node)tree;
        String currentNode = node.toString();
        if (currentNode.startsWith("\"")) {
            Node grandParentNode;
            ASTMethod parentMethod;
            String testString = currentNode.replace("\"", "");
            Node parentNode = node.jjtGetParent();
            if (parentNode instanceof ASTMethod && (!hasPrefix || testString.startsWith(this.prefix)) && ((parentMethod = (ASTMethod)parentNode).getMethodName().equals("get") || parentMethod.getMethodName().equals("containsKey")) && (grandParentNode = node.jjtGetParent().jjtGetParent()).jjtGetNumChildren() == 2 && grandParentNode.jjtGetChild(0) instanceof ASTThisVarRef) {
                this.list.add(hasPrefix ? testString.substring(this.prefix.length()) : testString);
            }
        }
        boolean allowRootContext = this.isRootContextEnabledInProjections();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (!allowRootContext && node.getClass().getName().equals("ognl.ASTProject")) continue;
            this.searchForAllVariableNames(node.jjtGetChild(i), hasPrefix);
        }
    }

    private boolean isRootContextEnabledInProjections() {
        ConfigStore ognlHelperConfigStore = ConfigStoreFarm.getConfig("com.pingidentity.common.util.OgnlHelper");
        return ognlHelperConfigStore.getBooleanValue("allowParentContextInProjections", false);
    }

    public void addListToSet(Set<String> set) {
        for (String string : this.list) {
            set.add(string);
        }
    }

    public String containsInvalidSubstitutions(Map<String, String> substitutionValues) {
        for (String key : this.getList()) {
            if (substitutionValues.containsKey(key)) continue;
            return key;
        }
        return null;
    }

    public String containsInvalidSubstitutions(Set<String> substitutionValues) {
        for (String key : this.getList()) {
            if (substitutionValues.contains(key)) continue;
            return key;
        }
        return null;
    }

    public List<String> getUntestableSubstitutions() {
        ArrayList<String> untestableSubstitutions = new ArrayList<String>();
        for (SourceContextType untestableContextType : SourceContextType.getUntestableContextTypes()) {
            if (!this.list.contains(untestableContextType.getId())) continue;
            untestableSubstitutions.add(untestableContextType.getId());
        }
        return untestableSubstitutions;
    }

    public Object processOgnlExpression(Object parsedExpression, Map<String, Object> testDataMap, Object root) throws OgnlException {
        return ExpressionCalculator.calculate(parsedExpression, testDataMap, root);
    }

    public List<String> getList() {
        return this.list;
    }

    public void setList(List<String> list) {
        this.list = list;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

