/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.sourceid.common.HashAlgorithm;
import org.sourceid.common.HashUtil;

public class SerialHashable
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    private String serializedHash;

    public SerialHashable() {
    }

    public SerialHashable(Serializable ... serializables) throws IOException {
        this.initializeHash(serializables);
    }

    public SerialHashable(SerialHashable copyFrom) {
        this.serializedHash = copyFrom.serializedHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeHash(Serializable ... serializables) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        try {
            for (Serializable serializable : serializables) {
                objectOutputStream.writeObject(serializable);
            }
            objectOutputStream.flush();
            byte[] bytes = byteArrayOutputStream.toByteArray();
            this.serializedHash = HashUtil.hashToHexString((byte[])bytes, (HashAlgorithm)HashAlgorithm.SHA1);
        }
        finally {
            objectOutputStream.close();
            byteArrayOutputStream.close();
        }
    }

    public String getSerializedHash() {
        return this.serializedHash;
    }

    public int hashCode() {
        return this.getSerializedHash().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof SerialHashable) {
            SerialHashable otherBean = (SerialHashable)obj;
            return otherBean.getSerializedHash().equals(this.getSerializedHash());
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.getSerializedHash();
    }

    public static SerialHashable newInstance(Serializable ... serializables) {
        try {
            return new SerialHashable(serializables);
        }
        catch (IOException e) {
            String s = "Something must be wrong with the args b/c this shouldn't happen " + Arrays.toString(serializables);
            throw new IllegalArgumentException(s, e);
        }
    }
}

