/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import com.pingidentity.common.util.InvalidSystemParameterException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.apache.commons.lang.StringUtils;

public class SystemParameterValidator {
    public static void validateLocalIPAddress(String ipAddress) throws InvalidSystemParameterException {
        if (ipAddress == null || StringUtils.isBlank((String)ipAddress) || "0.0.0.0".equals(ipAddress.trim()) || "::".equals(ipAddress.trim())) {
            return;
        }
        try {
            InetAddress[] addresses = InetAddress.getAllByName(ipAddress);
            if (addresses != null && addresses.length > 0) {
                ipAddress = addresses[0].getHostAddress();
            }
        }
        catch (UnknownHostException e) {
            throw new InvalidSystemParameterException(e.getMessage());
        }
        boolean found = false;
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            block4: while (!found && en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress address = enumIpAddr.nextElement();
                    String ipStr = address.getHostAddress();
                    if (!ipStr.equals(ipAddress.trim()) && !ipStr.startsWith(ipAddress)) continue;
                    found = true;
                    continue block4;
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        if (!found) {
            throw new InvalidSystemParameterException("IP address " + ipAddress + " is not valid for this machine.");
        }
    }

    public static void validatePort(String portStr) throws InvalidSystemParameterException {
        if (portStr == null || "".equals(portStr.trim()) || "-1".equals(portStr.trim())) {
            return;
        }
        int port = -1;
        try {
            port = Integer.parseInt(portStr);
        }
        catch (Exception e) {
            throw new InvalidSystemParameterException("Invalid port " + portStr);
        }
        if (port < 0 || port > 65535) {
            throw new InvalidSystemParameterException("Port out of range: " + portStr);
        }
    }
}

