/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import com.unboundid.util.Validator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.TimeZone;

public final class TimeUtil {
    private TimeUtil() {
    }

    public static String convertSecToMillisec(String sec) throws NumberFormatException {
        int secInt = Integer.parseInt(sec);
        int millisec = secInt * 1000;
        return Integer.toString(millisec);
    }

    public static String convertMillisecToSec(String millisec) throws NumberFormatException {
        int millisecInt = Integer.parseInt(millisec);
        int sec = millisecInt / 1000;
        return Integer.toString(sec);
    }

    public static Date decodeGeneralizedTime(String t) throws ParseException {
        Object trimmedTimestamp;
        String subSecFormatStr;
        int tzPos;
        TimeZone tz;
        Validator.ensureNotNull((Object)t);
        if (t.endsWith("Z")) {
            tz = TimeZone.getTimeZone("UTC");
            tzPos = t.length() - 1;
        } else {
            tzPos = t.lastIndexOf(45);
            if (tzPos < 0 && (tzPos = t.lastIndexOf(43)) < 0) {
                throw new ParseException("Unable to parse TimeZone", 0);
            }
            tz = TimeZone.getTimeZone("GMT" + t.substring(tzPos));
            if (tz.getRawOffset() == 0 && !t.endsWith("+0000") && !t.endsWith("-0000")) {
                throw new ParseException("Unable to parse TimeZone", tzPos);
            }
        }
        int periodPos = t.lastIndexOf(46, tzPos);
        if (periodPos > 0) {
            int formatStr = tzPos - periodPos - 1;
            switch (formatStr) {
                case 0: {
                    subSecFormatStr = "";
                    trimmedTimestamp = t.substring(0, periodPos);
                    break;
                }
                case 1: {
                    subSecFormatStr = ".SSS";
                    trimmedTimestamp = t.substring(0, periodPos + 2) + "00";
                    break;
                }
                case 2: {
                    subSecFormatStr = ".SSS";
                    trimmedTimestamp = t.substring(0, periodPos + 3) + "0";
                    break;
                }
                default: {
                    subSecFormatStr = ".SSS";
                    trimmedTimestamp = t.substring(0, periodPos + 4);
                    break;
                }
            }
        } else {
            subSecFormatStr = "";
            periodPos = tzPos;
            trimmedTimestamp = t.substring(0, tzPos);
        }
        SimpleDateFormat dateFormat = TimeUtil.getSimpleDateFormat(periodPos, subSecFormatStr, tz);
        return dateFormat.parse((String)trimmedTimestamp);
    }

    private static SimpleDateFormat getSimpleDateFormat(int periodPos, String subSecFormatStr, TimeZone tz) throws ParseException {
        String formatStr1;
        switch (periodPos) {
            case 10: {
                formatStr1 = "yyyyMMddHH" + subSecFormatStr;
                break;
            }
            default: {
                throw new ParseException("Invalid Timestamp Length", periodPos);
            }
            case 12: {
                formatStr1 = "yyMMddHHmmss" + subSecFormatStr;
                break;
            }
            case 14: {
                formatStr1 = "yyyyMMddHHmmss" + subSecFormatStr;
            }
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(formatStr1);
        dateFormat.setTimeZone(tz);
        dateFormat.setLenient(false);
        return dateFormat;
    }

    public static long getCurrentEpochSecond() {
        return Instant.now().getEpochSecond();
    }

    public static LocalDateTime epochSecondToLocalDateTime(long epochSecond) {
        Instant instant = Instant.ofEpochSecond(epochSecond);
        return LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
    }

    public static LocalDateTime getCurrentUtcLocalDateTime() {
        return LocalDateTime.now(ZoneId.of("UTC"));
    }
}

