/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import com.pingidentity.localidentity.TrackedParamsAuditLogger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TrackedHttpParamManager;

public class TrackedParamsUtil {
    public static final String TRACKED_HTTP_PARAMS = "pf.TrackedHttpParams";
    private static final Log log = LogFactory.getLog(TrackedParamsUtil.class);
    private final TrackedHttpParamManager trackedParamManager = MgmtFactory.getTrackedHttpParamManager();

    public Map<String, Collection<String>> retrieveTrackedParams(HttpServletRequest req) {
        if (!this.trackedParamManager.getTrackedParamSettings().isTrackingEnabled()) {
            return Collections.emptyMap();
        }
        Map<String, Collection<String>> trackedParams = this.getTrackedParamsFromRequest(req);
        if (!trackedParams.isEmpty()) {
            TrackedParamsAuditLogger.setTrackedParams(trackedParams);
        }
        return trackedParams;
    }

    public void amendTrackedParamsToState(Map<String, Object> reqParamsMap, Map<String, Object> stateParams) {
        if (!MapUtils.isEmpty(reqParamsMap) && this.trackedParamManager.getTrackedParamSettings().isTrackingEnabled()) {
            List<String> whiteListedParamNames = this.getWhitelistedTrackedParamNames();
            Map<String, Object> paramsToTrack = reqParamsMap.entrySet().stream().filter(entry -> whiteListedParamNames.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Map<String, Collection<String>> convertedMap = this.convertParamMapObject(paramsToTrack);
            if (convertedMap.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No parameters from the request parameters map matched the whitelisted tracked parameters.");
                }
            } else {
                stateParams.putIfAbsent(TRACKED_HTTP_PARAMS, new HashMap());
                Map trackedHttpParamsMap = (Map)stateParams.get(TRACKED_HTTP_PARAMS);
                convertedMap.forEach((key, values) -> trackedHttpParamsMap.merge(key, values, (existingVal, newVal) -> newVal));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The following parameters from the request parameters map will be tracked for this request: " + StringUtils.join(convertedMap.keySet(), (String)",")));
                }
            }
        }
    }

    public void addTrackedParamsToState(HttpServletRequest req, Map<String, Object> stateParams) {
        Map<String, Collection<String>> trackedParams = this.retrieveTrackedParams(req);
        if (!trackedParams.isEmpty()) {
            stateParams.put(TRACKED_HTTP_PARAMS, trackedParams);
        }
    }

    private Map<String, Collection<String>> getTrackedParamsFromRequest(HttpServletRequest req) {
        List<String> whiteListedParamNames = this.getWhitelistedTrackedParamNames();
        Map<String, String[]> paramsToTrack = req.getParameterMap().entrySet().stream().filter(entry -> whiteListedParamNames.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, Collection<String>> convertedMap = this.convertParamMapStringArray(paramsToTrack);
        if (log.isDebugEnabled()) {
            if (convertedMap.isEmpty()) {
                log.debug((Object)"No parameters in this request matched the whitelisted tracked parameters.");
            } else {
                log.debug((Object)("The following parameters will be tracked for this request: " + StringUtils.join(convertedMap.keySet(), (String)",")));
            }
        }
        return convertedMap;
    }

    List<String> getWhitelistedTrackedParamNames() {
        return this.trackedParamManager.getTrackedParamSettings().getTrackedParamNames();
    }

    private Map<String, Collection<String>> convertParamMapStringArray(Map<String, String[]> parameterMap) {
        if (parameterMap == null || parameterMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Collection<String>> params = new HashMap<String, Collection<String>>();
        parameterMap.forEach((paramName, paramValues) -> params.put((String)paramName, (Collection<String>)Arrays.asList(paramValues)));
        return params;
    }

    private Map<String, Collection<String>> convertParamMapObject(Map<String, Object> parameterMap) {
        if (parameterMap == null || parameterMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Collection<String>> params = new HashMap<String, Collection<String>>();
        parameterMap.forEach((paramName, paramValues) -> {
            if (paramValues instanceof String) {
                params.put((String)paramName, (Collection<String>)Collections.singletonList((String)paramValues));
            } else if (paramValues instanceof List) {
                List paramValuesList = (List)paramValues;
                if (!paramValuesList.isEmpty() && paramValuesList.get(0) instanceof String) {
                    params.put((String)paramName, (List)paramValues);
                }
            } else if (paramValues != null) {
                log.warn((Object)("Skipping tracked parameter '" + paramName + "' due to unsupported type: " + paramValues.getClass()));
            }
        });
        return params;
    }
}

