/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.ldap;

import com.pingidentity.config.xml.ldapds.LdapSource;
import java.util.List;
import java.util.Objects;
import org.sourceid.saml20.domain.datasource.info.LdapInfo;

public class ConnectionInfo {
    private String id;
    private String name;
    private String serverUrl;
    private boolean useSSL;
    private String authenticationMethod;
    private String principal;
    private String credentials;
    private String clientTlsCertificate;
    private List<String> binaryAttributes;
    private boolean useDnsSrvRecords;
    private Boolean useLdapReferral;
    private LdapInfo.LdapType ldapType = LdapInfo.LdapType.Generic;
    private static LdapSource ldapDataSourceXmlBean = LdapSource.Factory.newInstance();
    private Boolean testOnBorrow;
    private Boolean testOnReturn;
    private Boolean createIfNecessary;
    private boolean retryFailedOperations;
    private Integer min;
    private Integer max;
    private Integer maxWait;
    private Integer timeBetweenEvictionRunsMillis;
    private Integer readTimeoutMillis;
    private Integer connTimeoutMillis;
    private Boolean verifyHost;
    private Integer dnsTtlMillis;
    private String pingOneConnection;
    private String pingOneEnvironment;
    private String pingOneGateway;
    private String pingOneCredential;
    private boolean useStartTLS;

    public ConnectionInfo(String serverUrl, boolean useSSL, String authenticationMethod, String principal, String credentials, String clientTlsCertificate, String id, String name, boolean useDnsSrvRecords, boolean useAdReferral, LdapInfo.LdapType ldapType, boolean useStartTLS) {
        this.serverUrl = serverUrl;
        this.useSSL = useSSL;
        this.authenticationMethod = authenticationMethod;
        this.principal = principal;
        this.credentials = credentials;
        this.clientTlsCertificate = clientTlsCertificate;
        this.id = id;
        this.name = name;
        this.useDnsSrvRecords = useDnsSrvRecords;
        this.useLdapReferral = useAdReferral;
        this.ldapType = ldapType;
        this.useStartTLS = useStartTLS;
        this.setDefaultPoolOptions();
    }

    public ConnectionInfo(String serverUrl, boolean useSSL, String authenticationMethod, String principal, String credentials, String clientTlsCertificate, String id, String name, boolean useDnsSrvRecords, boolean useAdReferral) {
        this(serverUrl, useSSL, authenticationMethod, principal, credentials, clientTlsCertificate, id, name, useDnsSrvRecords, useAdReferral, LdapInfo.LdapType.Generic, false);
    }

    public ConnectionInfo(String serverUrl, boolean useSSL, String authenticationMethod, String principal, String credentials, String clientTlsCertificate, List<String> binaryAttributes, String id, String name, boolean useDnsSrvRecords, boolean useAdReferral) {
        this(serverUrl, useSSL, authenticationMethod, principal, credentials, clientTlsCertificate, id, name, useDnsSrvRecords, useAdReferral, LdapInfo.LdapType.Generic, false);
        this.binaryAttributes = binaryAttributes;
    }

    public ConnectionInfo(String pingOneConnection, String pingOneCredential, String pingOneEnvironment, String pingOneGateway, String id, String name) {
        this.pingOneConnection = pingOneConnection;
        this.pingOneCredential = pingOneCredential;
        this.pingOneEnvironment = pingOneEnvironment;
        this.pingOneGateway = pingOneGateway;
        this.id = id;
        this.name = name;
    }

    public void setPoolOptions(boolean testOnBorrow, boolean testOnReturn, boolean createIfNecessary, int min, int max, int maxWait, int timeBetweenEvictionRunsMillis, int readTimeoutMillis, int connTimeoutMillis, boolean verifyHost, int dnsTtlMillis, boolean doRetries) {
        this.testOnBorrow = testOnBorrow;
        this.testOnReturn = testOnReturn;
        this.createIfNecessary = createIfNecessary;
        this.min = min;
        this.max = max;
        this.maxWait = maxWait;
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        this.readTimeoutMillis = readTimeoutMillis;
        this.connTimeoutMillis = connTimeoutMillis;
        this.verifyHost = verifyHost;
        this.dnsTtlMillis = dnsTtlMillis;
        this.retryFailedOperations = doRetries;
    }

    private void setDefaultPoolOptions() {
        this.setPoolOptions(ldapDataSourceXmlBean.getTestOnBorrow(), ldapDataSourceXmlBean.getTestOnReturn(), ldapDataSourceXmlBean.getCreateIfNecessary(), ldapDataSourceXmlBean.getMinIdle(), ldapDataSourceXmlBean.getMaxActive(), ldapDataSourceXmlBean.getMaxWait(), ldapDataSourceXmlBean.getTimeBetweenEvictionRunsMillis(), ldapDataSourceXmlBean.getReadTimeoutMillis(), ldapDataSourceXmlBean.getConnTimeoutMillis(), ldapDataSourceXmlBean.getVerifyHost(), ldapDataSourceXmlBean.getDnsTtlMillis(), ldapDataSourceXmlBean.getRetryFailedOperations());
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public String getClientTlsCertificate() {
        return this.clientTlsCertificate;
    }

    public List<String> getBinaryAttributes() {
        return this.binaryAttributes;
    }

    public void setBinaryAttributes(List<String> binaryAttrs) {
        this.binaryAttributes = binaryAttrs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionInfo that = (ConnectionInfo)o;
        if (this.useSSL != that.useSSL) {
            return false;
        }
        if (this.useDnsSrvRecords != that.useDnsSrvRecords) {
            return false;
        }
        if (this.retryFailedOperations != that.retryFailedOperations) {
            return false;
        }
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.serverUrl, that.serverUrl)) {
            return false;
        }
        if (!Objects.equals(this.authenticationMethod, that.authenticationMethod)) {
            return false;
        }
        if (!Objects.equals(this.principal, that.principal)) {
            return false;
        }
        if (!Objects.equals(this.credentials, that.credentials)) {
            return false;
        }
        if (!Objects.equals(this.clientTlsCertificate, that.clientTlsCertificate)) {
            return false;
        }
        if (!Objects.equals(this.binaryAttributes, that.binaryAttributes)) {
            return false;
        }
        if (!Objects.equals(this.useLdapReferral, that.useLdapReferral)) {
            return false;
        }
        if (this.ldapType != that.ldapType) {
            return false;
        }
        if (!Objects.equals(this.testOnBorrow, that.testOnBorrow)) {
            return false;
        }
        if (!Objects.equals(this.testOnReturn, that.testOnReturn)) {
            return false;
        }
        if (!Objects.equals(this.createIfNecessary, that.createIfNecessary)) {
            return false;
        }
        if (!Objects.equals(this.min, that.min)) {
            return false;
        }
        if (!Objects.equals(this.max, that.max)) {
            return false;
        }
        if (!Objects.equals(this.maxWait, that.maxWait)) {
            return false;
        }
        if (!Objects.equals(this.timeBetweenEvictionRunsMillis, that.timeBetweenEvictionRunsMillis)) {
            return false;
        }
        if (!Objects.equals(this.readTimeoutMillis, that.readTimeoutMillis)) {
            return false;
        }
        if (!Objects.equals(this.connTimeoutMillis, that.connTimeoutMillis)) {
            return false;
        }
        if (!Objects.equals(this.verifyHost, that.verifyHost)) {
            return false;
        }
        if (!Objects.equals(this.dnsTtlMillis, that.dnsTtlMillis)) {
            return false;
        }
        if (!Objects.equals(this.pingOneConnection, that.pingOneConnection)) {
            return false;
        }
        if (!Objects.equals(this.pingOneEnvironment, that.pingOneEnvironment)) {
            return false;
        }
        if (!Objects.equals(this.pingOneGateway, that.pingOneGateway)) {
            return false;
        }
        if (this.useStartTLS != that.useStartTLS) {
            return false;
        }
        return Objects.equals(this.pingOneCredential, that.pingOneCredential);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.serverUrl != null ? this.serverUrl.hashCode() : 0);
        result = 31 * result + (this.useSSL ? 1 : 0);
        result = 31 * result + (this.authenticationMethod != null ? this.authenticationMethod.hashCode() : 0);
        result = 31 * result + (this.principal != null ? this.principal.hashCode() : 0);
        result = 31 * result + (this.credentials != null ? this.credentials.hashCode() : 0);
        result = 31 * result + (this.clientTlsCertificate != null ? this.clientTlsCertificate.hashCode() : 0);
        result = 31 * result + (this.binaryAttributes != null ? this.binaryAttributes.hashCode() : 0);
        result = 31 * result + (this.useDnsSrvRecords ? 1 : 0);
        result = 31 * result + (this.useLdapReferral != null ? this.useLdapReferral.hashCode() : 0);
        result = 31 * result + (this.ldapType != null ? this.ldapType.hashCode() : 0);
        result = 31 * result + (this.testOnBorrow != null ? this.testOnBorrow.hashCode() : 0);
        result = 31 * result + (this.testOnReturn != null ? this.testOnReturn.hashCode() : 0);
        result = 31 * result + (this.createIfNecessary != null ? this.createIfNecessary.hashCode() : 0);
        result = 31 * result + (this.retryFailedOperations ? 1 : 0);
        result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
        result = 31 * result + (this.max != null ? this.max.hashCode() : 0);
        result = 31 * result + (this.maxWait != null ? this.maxWait.hashCode() : 0);
        result = 31 * result + (this.timeBetweenEvictionRunsMillis != null ? this.timeBetweenEvictionRunsMillis.hashCode() : 0);
        result = 31 * result + (this.readTimeoutMillis != null ? this.readTimeoutMillis.hashCode() : 0);
        result = 31 * result + (this.connTimeoutMillis != null ? this.connTimeoutMillis.hashCode() : 0);
        result = 31 * result + (this.verifyHost != null ? this.verifyHost.hashCode() : 0);
        result = 31 * result + (this.dnsTtlMillis != null ? this.dnsTtlMillis.hashCode() : 0);
        result = 31 * result + (this.pingOneConnection != null ? this.pingOneConnection.hashCode() : 0);
        result = 31 * result + (this.pingOneEnvironment != null ? this.pingOneEnvironment.hashCode() : 0);
        result = 31 * result + (this.pingOneGateway != null ? this.pingOneGateway.hashCode() : 0);
        result = 31 * result + (this.pingOneCredential != null ? this.pingOneCredential.hashCode() : 0);
        result = 31 * result + (this.useStartTLS ? 1 : 0);
        return result;
    }

    public String toString() {
        return "ConnectionInfo{id='" + this.id + "', name='" + this.name + "', serverUrl='" + this.serverUrl + "', authenticationMethod='" + this.authenticationMethod + "', principal='" + this.principal + "', clientTlsCertificate='" + this.clientTlsCertificate + "', binaryAttributes=" + this.binaryAttributes + ", testOnBorrow='" + this.testOnBorrow + "', testOnReturn='" + this.testOnReturn + "', createIfNecessary='" + this.createIfNecessary + "', verifyHost='" + this.verifyHost + "', followLdapReferrals='" + this.useLdapReferral + "', ldapType='" + this.ldapType + "', min='" + this.min + "', max='" + this.max + "', maxWait='" + this.maxWait + "', timeBetweenEvictionRunsMillis='" + this.timeBetweenEvictionRunsMillis + "', readTimeoutMillis='" + this.readTimeoutMillis + "', connTimeoutMillis='" + this.connTimeoutMillis + "', dnsTtlMillis='" + this.dnsTtlMillis + "', pingOneConnection='" + this.pingOneConnection + "', pingOneEnvironment='" + this.pingOneEnvironment + "', pingOneGateway='" + this.pingOneGateway + "', useStartTLS='" + this.useStartTLS + "'}";
    }

    public boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    public boolean isTestOnReturn() {
        return this.testOnReturn;
    }

    public boolean isCreateIfNecessary() {
        return this.createIfNecessary;
    }

    public boolean isRetryFailedOperations() {
        return this.retryFailedOperations;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public int getMaxWait() {
        return this.maxWait;
    }

    public int getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public int getConnTimeoutMillis() {
        return this.connTimeoutMillis;
    }

    public boolean isVerifyHost() {
        return this.verifyHost;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Integer getDnsTtlMillis() {
        return this.dnsTtlMillis;
    }

    public boolean isUseDnsSrvRecords() {
        return this.useDnsSrvRecords;
    }

    public boolean getUseLdapReferral() {
        return this.useLdapReferral;
    }

    public void setUseLdapReferral(boolean useLdapReferral) {
        this.useLdapReferral = useLdapReferral;
    }

    public LdapInfo.LdapType getLdapType() {
        return this.ldapType;
    }

    public void setLdapType(LdapInfo.LdapType ldapType) {
        this.ldapType = ldapType;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public String getPingOneConnection() {
        return this.pingOneConnection;
    }

    public void setPingOneConnection(String pingOneConnection) {
        this.pingOneConnection = pingOneConnection;
    }

    public String getPingOneCredential() {
        return this.pingOneCredential;
    }

    public String getPingOneEnvironment() {
        return this.pingOneEnvironment;
    }

    public void setPingOneEnvironment(String pingOneEnvironment) {
        this.pingOneEnvironment = pingOneEnvironment;
    }

    public String getPingOneGateway() {
        return this.pingOneGateway;
    }

    public void setPingOneGateway(String pingOneGateway) {
        this.pingOneGateway = pingOneGateway;
    }

    public boolean isUseStartTLS() {
        return this.useStartTLS;
    }
}

