/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.ldap;

import com.pingidentity.common.util.LogGuard;
import com.pingidentity.common.util.ldap.LDAPUtil;
import com.pingidentity.common.util.ldap.LDAPUtilOptions;
import com.pingidentity.common.util.timers.EventTimer;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.UpdatableLDAPRequest;
import com.unboundid.ldap.sdk.controls.PostReadResponseControl;
import java.util.ArrayList;
import java.util.List;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.util.log.AttributeMap;

public final class LDAPCrudHelper {
    private static final Log log = LogFactory.getLog(LDAPCrudHelper.class);
    private static final String EVENT_TYPE_DELETE = "delete";
    private static final String EVENT_TYPE_MODIFY = "modify";
    private static final String EVENT_TYPE_GET_ENTRY = "get-entry";
    private static final String EVENT_TYPE_ADD = "add";
    private final LDAPUtil ldapUtil;
    private List<Control> controls = new ArrayList<Control>();

    public LDAPCrudHelper(LDAPUtil ldapUtil) {
        this.ldapUtil = ldapUtil;
    }

    public void addControl(Control control) {
        this.controls.add(control);
    }

    public final ReadOnlyEntry createEntry(Name entryDN, Attributes attrsToAdd) throws NamingException {
        LDAPResult ldapResult = this.addObjectInternal(entryDN, attrsToAdd);
        String successMessage = "entry: %s successfully added to the LDAP data store";
        try {
            PostReadResponseControl responseControl = PostReadResponseControl.get((LDAPResult)ldapResult);
            if (responseControl != null && responseControl.getEntry() != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format(successMessage, LogGuard.encode(responseControl.getEntry().getDN())));
                }
                return responseControl.getEntry();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format(successMessage, LogGuard.encode(entryDN.toString())));
            }
            return null;
        }
        catch (LDAPException e) {
            throw LDAPUtil.convertLdapException(e, this.ldapUtil.getLdapId());
        }
    }

    public final void deleteEntry(Name entryDn) throws NamingException {
        String successMessage = "entry: %s deleted successfully";
        try (EventTimer ignored = this.ldapUtil.getEventTimer(EVENT_TYPE_DELETE);){
            DeleteRequest request = new DeleteRequest(entryDn.toString());
            this.controls.forEach(xva$0 -> request.addControls(new Control[]{xva$0}));
            this.ldapUtil.addIntermediateClientRequestControl((UpdatableLDAPRequest)request);
            this.ldapUtil.addAccessLogFieldRequestControl((UpdatableLDAPRequest)request);
            this.ldapUtil.getSearchPool().delete(request);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format(successMessage, LogGuard.encode(entryDn.toString())));
            }
        }
        catch (LDAPException e) {
            throw LDAPUtil.convertLdapException(e, this.ldapUtil.getLdapId());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final ReadOnlyEntry modifyEntry(Name ldapName, Attributes attrsToModify, int modificationCode) throws NamingException {
        String successMessage = "entry: %s successfully modified in the LDAP data store";
        try (EventTimer ignored = this.ldapUtil.getEventTimer(EVENT_TYPE_MODIFY);){
            List<Modification> mods = LDAPCrudHelper.attributesToModifications(modificationCode, attrsToModify);
            ModifyRequest request = new ModifyRequest(ldapName.toString(), mods);
            this.controls.forEach(xva$0 -> request.addControls(new Control[]{xva$0}));
            this.ldapUtil.addIntermediateClientRequestControl((UpdatableLDAPRequest)request);
            this.ldapUtil.addAccessLogFieldRequestControl((UpdatableLDAPRequest)request);
            LDAPResult ldapResult = this.ldapUtil.getSearchPool().modify(request);
            PostReadResponseControl responseControl = PostReadResponseControl.get((LDAPResult)ldapResult);
            if (responseControl != null && responseControl.getEntry() != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format(successMessage, LogGuard.encode(responseControl.getEntry().getDN())));
                }
                ReadOnlyEntry readOnlyEntry = responseControl.getEntry();
                return readOnlyEntry;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format(successMessage, LogGuard.encode(ldapName.toString())));
            }
            ReadOnlyEntry readOnlyEntry = null;
            return readOnlyEntry;
        }
        catch (LDAPException e) {
            throw LDAPUtil.convertLdapException(e, this.ldapUtil.getLdapId());
        }
    }

    public final SearchResultEntry getEntry(DN dn, String ... attributes) throws NamingException {
        EventTimer ignored = this.ldapUtil.getEventTimer(EVENT_TYPE_GET_ENTRY);
        try {
            SearchResultEntry searchResultEntry = this.ldapUtil.getEntry(dn.toString(), attributes);
            if (ignored != null) {
                ignored.close();
            }
            return searchResultEntry;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (LDAPException e) {
                throw LDAPUtil.convertLdapException(e, this.ldapUtil.getLdapId());
            }
        }
    }

    public final List<SearchResultEntry> search(SearchCriteria searchCriteria) throws NamingException {
        try {
            return this.ldapUtil.searchWithFilter(searchCriteria.getLdapUtilOptions(), searchCriteria.getSearchRequest());
        }
        catch (LDAPException e) {
            throw LDAPUtil.convertLdapException(e, this.ldapUtil.getLdapId());
        }
    }

    public final AttributeMap toAttributeMap(SearchResultEntry entry, boolean includeCustomSubjectDn) {
        if (entry == null) {
            return null;
        }
        return this.ldapUtil.getAttributeMap(includeCustomSubjectDn, entry);
    }

    private LDAPResult addObjectInternal(Name newName, Attributes attrsToAdd) throws NamingException {
        EventTimer ignored = this.ldapUtil.getEventTimer(EVENT_TYPE_ADD);
        try {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(attrsToAdd.size());
            NamingEnumeration<? extends javax.naming.directory.Attribute> attribEnum = attrsToAdd.getAll();
            while (attribEnum.hasMore()) {
                javax.naming.directory.Attribute attribute = attribEnum.next();
                if (attribute.size() <= 0) continue;
                ASN1OctetString[] attributeValues = LDAPUtil.getAttributeValues(attribute);
                Attribute attrToInsert = new Attribute(attribute.getID(), attributeValues);
                attributes.add(attrToInsert);
            }
            AddRequest request = new AddRequest(newName.toString(), attributes);
            this.controls.forEach(xva$0 -> request.addControls(new Control[]{xva$0}));
            this.ldapUtil.addIntermediateClientRequestControl((UpdatableLDAPRequest)request);
            this.ldapUtil.addAccessLogFieldRequestControl((UpdatableLDAPRequest)request);
            LDAPResult lDAPResult = this.ldapUtil.getSearchPool().add(request);
            if (ignored != null) {
                ignored.close();
            }
            return lDAPResult;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (LDAPException e) {
                throw LDAPUtil.convertLdapException(e, this.ldapUtil.getLdapId());
            }
        }
    }

    private static List<Modification> attributesToModifications(int op, Attributes attribs) throws NamingException {
        ArrayList<Modification> modifications = new ArrayList<Modification>(attribs.size());
        NamingEnumeration<? extends javax.naming.directory.Attribute> attribEnum = attribs.getAll();
        while (attribEnum.hasMore()) {
            javax.naming.directory.Attribute attribute = attribEnum.next();
            Modification modification = LDAPUtil.attributeToModification(op, attribute);
            modifications.add(modification);
        }
        return modifications;
    }

    public static class SearchCriteria {
        private final String baseDN;
        private final SearchScope scope;
        private final Filter filter;
        private int count;
        private String[] attributes;

        public SearchCriteria(String baseDN, SearchScope scope, Filter filter, String ... attributes) {
            this.baseDN = baseDN;
            this.scope = scope;
            this.filter = filter;
            this.attributes = attributes;
        }

        public void setCount(int count) {
            this.count = count;
        }

        SearchRequest getSearchRequest() {
            SearchRequest searchRequest = new SearchRequest(this.baseDN, this.scope, this.filter, this.attributes);
            searchRequest.setSizeLimit(this.count);
            return searchRequest;
        }

        LDAPUtilOptions getLdapUtilOptions() {
            LDAPUtilOptions options = new LDAPUtilOptions(this.baseDN, this.filter.toString(), this.scope.intValue());
            options.setCount(this.count);
            return options;
        }
    }
}

