/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.ldap;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.common.util.ldap.LDAPPasswordPolicy;
import com.pingidentity.common.util.ldap.LDAPUtil;
import com.pingidentity.common.util.ldap.LDAPUtilOptions;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.util.args.ArgumentException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.util.ObjectMapperFactory;
import org.sourceid.util.log.AttributeMap;

public class LDAPPasswordPolicyUtil {
    private final LDAPUtil ldapUtil;
    private final Log log;
    private final ObjectMapper objectMapper = ObjectMapperFactory.buildObjectMapper().configure(DeserializationFeature.USE_LONG_FOR_INTS, true);

    public LDAPPasswordPolicyUtil(LDAPUtil ldapUtil) {
        this.ldapUtil = ldapUtil;
        this.log = LogFactory.getLog(this.getClass());
    }

    public List<AttributeMap> convertPasswordDnSearchResultsToAttributeMaps(List<SearchResultEntry> userAttributes, boolean includeCustomSubjectDn, String pwdExpiryTimeAttributeValue, String secondsUntilPasswordExpiration) {
        ArrayList<AttributeMap> attributeMaps = new ArrayList<AttributeMap>();
        for (SearchResultEntry result : userAttributes) {
            if (result == null) continue;
            AttributeMap mappingResult = this.ldapUtil.getAttributeMap(includeCustomSubjectDn, result);
            mappingResult.put("seconds-until-password-expiration", secondsUntilPasswordExpiration);
            mappingResult.put("passwordExpiryTime", pwdExpiryTimeAttributeValue);
            attributeMaps.add(mappingResult);
        }
        return attributeMaps;
    }

    public Map<String, String> getPasswordPolicyAttributeValues(LDAPUtilOptions ldapOptions, LDAPPasswordPolicy passwordPolicyType, List<SearchResultEntry> userAttributes) throws NamingException {
        Long passwordExpiryTime = null;
        boolean isADServer = passwordPolicyType.equals((Object)LDAPPasswordPolicy.AD_PSO_TYPE);
        boolean isPDServer = passwordPolicyType.equals((Object)LDAPPasswordPolicy.PING_DIRECTORY_ID_TYPE);
        boolean isPingDS = passwordPolicyType.equals((Object)LDAPPasswordPolicy.PING_DS_ID_TYPE);
        ArrayList<String> policyAttributes = new ArrayList<String>();
        policyAttributes.add(passwordPolicyType.getMaxAgeAttributeName());
        Map<String, String> attributes = new HashMap<String, String>();
        for (SearchResultEntry userAttribute : userAttributes) {
            Attribute passwordPolicyAttribute = userAttribute.getAttribute(passwordPolicyType.getUserPasswordPolicyDnAttributeName());
            Attribute passwordChangedAttribute = userAttribute.getAttribute(passwordPolicyType.getPasswordChangeTimeAttributeName());
            Attribute passwordStateJsonAttribute = userAttribute.getAttribute("ds-pwp-state-json");
            if (isADServer) {
                String adUserPasswordExpiryValue = userAttribute.getAttributeValue("msDS-UserPasswordExpiryTimeComputed");
                if (adUserPasswordExpiryValue == null) continue;
                passwordExpiryTime = LDAPUtil.convertAdTimestampToDate(adUserPasswordExpiryValue).getTime();
                attributes = new HashMap();
                attributes.put("passwordExpiryTime", passwordExpiryTime.toString());
                continue;
            }
            if (!isPDServer && !isPingDS) {
                String policyDN = passwordPolicyAttribute != null ? passwordPolicyAttribute.getValue() : null;
                attributes = this.getPasswordPolicyAttributesWithPolicyDN(ldapOptions, passwordPolicyType, policyAttributes, passwordChangedAttribute, policyDN);
                continue;
            }
            if (passwordStateJsonAttribute == null || !passwordStateJsonAttribute.hasValue()) continue;
            String passwordPolicyStateJSON = passwordStateJsonAttribute.getValue();
            try {
                Map passwordPolicyStateMap = (Map)this.objectMapper.readValue(passwordPolicyStateJSON, (TypeReference)new TypeReference<Map<String, Object>>(){});
                if (!passwordPolicyStateMap.containsKey("seconds-until-password-expiration")) continue;
                attributes.put("seconds-until-password-expiration", Long.toString((Long)passwordPolicyStateMap.get("seconds-until-password-expiration")));
            }
            catch (IOException e) {
                this.log.error((Object)e.getMessage());
                this.log.debug((Object)e);
                NamingException ne = new NamingException("Error determining password policy state attributes.");
                ne.setRootCause(e);
                throw ne;
            }
        }
        return attributes;
    }

    private Map<String, String> getPasswordPolicyAttributesWithPolicyDN(LDAPUtilOptions ldapOptions, LDAPPasswordPolicy passwordPolicyType, List<String> policyAttributes, Attribute passwordChangedAttribute, String policyDN) throws NamingException {
        Long passwordExpiryTime = null;
        if (policyDN != null && passwordChangedAttribute != null) {
            try {
                SearchRequest request = new SearchRequest(policyDN, SearchScope.BASE, "objectclass=" + passwordPolicyType.getObjectClassName(), new String[0]);
                request.setAttributes(policyAttributes);
                List<SearchResultEntry> results = this.ldapUtil.searchWithFilter(ldapOptions, request);
                for (SearchResultEntry entry : results) {
                    String maxAgeRawValue = entry.getAttributeValue(passwordPolicyType.getMaxAgeAttributeName());
                    if (maxAgeRawValue != null) {
                        passwordExpiryTime = passwordPolicyType.passwordExpiryTime(maxAgeRawValue, passwordChangedAttribute);
                    }
                    if (passwordExpiryTime == null) continue;
                    break;
                }
            }
            catch (LDAPException e) {
                throw LDAPUtil.convertLdapException(e, this.ldapUtil.getLdapId());
            }
            catch (ArgumentException e) {
                this.log.error((Object)("Unable to process the password change date: " + e.getMessage()));
            }
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (passwordExpiryTime != null) {
            attributes.put("passwordExpiryTime", passwordExpiryTime.toString());
        }
        return attributes;
    }
}

