/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.ldap;

import com.pingidentity.common.util.ServerUrlUtils;
import com.pingidentity.common.util.ServiceInformation;
import com.pingidentity.common.util.Substituter;
import com.pingidentity.common.util.ldap.ConnectionInfo;
import com.pingidentity.common.util.ldap.LDAPErrorException;
import com.pingidentity.common.util.ldap.LDAPInterfaceUtil;
import com.pingidentity.common.util.ldap.LDAPPasswordPolicy;
import com.pingidentity.common.util.ldap.LDAPPasswordPolicyProperties;
import com.pingidentity.common.util.ldap.LDAPPasswordPolicyUtil;
import com.pingidentity.common.util.ldap.LDAPUtilOptions;
import com.pingidentity.common.util.ldap.PingLdapSSLSocketFactory;
import com.pingidentity.common.util.ldap.PolicyHintsControl;
import com.pingidentity.common.util.ldap.SimpleBindPostConnectProcessor;
import com.pingidentity.common.util.ldap.SimplePaginationState;
import com.pingidentity.common.util.ldap.extendedrequests.OUDPasswordPolicyStateExtendedOperation;
import com.pingidentity.common.util.ldap.passwordvalidator.AttributeValuePasswordValidator;
import com.pingidentity.common.util.ldap.passwordvalidator.CharacterSetPasswordValidator;
import com.pingidentity.common.util.ldap.passwordvalidator.DictionaryPasswordValidator;
import com.pingidentity.common.util.ldap.passwordvalidator.HaystackPasswordValidator;
import com.pingidentity.common.util.ldap.passwordvalidator.LDAPPasswordPolicyViolationException;
import com.pingidentity.common.util.ldap.passwordvalidator.LDAPPasswordQualityRequirement;
import com.pingidentity.common.util.ldap.passwordvalidator.LengthPasswordValidator;
import com.pingidentity.common.util.ldap.passwordvalidator.NotCurrentPasswordValidator;
import com.pingidentity.common.util.ldap.passwordvalidator.RegularExpressionPasswordValidator;
import com.pingidentity.common.util.ldap.passwordvalidator.RepeatedCharactersPasswordValidator;
import com.pingidentity.common.util.ldap.passwordvalidator.SimilarityPasswordValidator;
import com.pingidentity.common.util.ldap.passwordvalidator.UniqueCharactersPasswordValidator;
import com.pingidentity.common.util.ssl.PingCustomSSLSocketFactoryUtil;
import com.pingidentity.common.util.timers.DSEventTimer;
import com.pingidentity.common.util.timers.EventTimer;
import com.pingidentity.lightning.rawldap.internal.ldapsdk.InvalidCredentialException;
import com.pingidentity.lightning.rawldap.internal.ldapsdk.PingOneTunneledLDAPInterface;
import com.pingidentity.lightning.rawldap.internal.model.DirectLdapSearchesThenOpRequest;
import com.pingidentity.lightning.rawldap.internal.model.DirectLdapSearchesThenOpResponse;
import com.pingidentity.monitoring.ConnectionPoolMetrics;
import com.pingidentity.pingcommons.util.DNUtil;
import com.pingidentity.pingonev2.PingOneGateway;
import com.pingidentity.sdk.locale.Message;
import com.pingidentity.sdk.password.PasswordPolicyRequirementValidationException;
import com.pingidentity.sdk.secretmanager.SecretManagerException;
import com.pingidentity.sdk.secretmanager.SecretReferenceUtil;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.AggregatePostConnectProcessor;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.DNSSRVRecordServerSet;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.EXTERNALBindRequest;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.FailoverServerSet;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.FullLDAPInterface;
import com.unboundid.ldap.sdk.GetEntryLDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPRequest;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.PostConnectProcessor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.RootDSE;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.SingleServerSet;
import com.unboundid.ldap.sdk.StartTLSPostConnectProcessor;
import com.unboundid.ldap.sdk.UpdatableLDAPRequest;
import com.unboundid.ldap.sdk.controls.PasswordExpiredControl;
import com.unboundid.ldap.sdk.controls.ProxiedAuthorizationV1RequestControl;
import com.unboundid.ldap.sdk.controls.ProxiedAuthorizationV2RequestControl;
import com.unboundid.ldap.sdk.controls.ServerSideSortRequestControl;
import com.unboundid.ldap.sdk.controls.SimplePagedResultsControl;
import com.unboundid.ldap.sdk.controls.SortKey;
import com.unboundid.ldap.sdk.controls.VirtualListViewRequestControl;
import com.unboundid.ldap.sdk.controls.VirtualListViewResponseControl;
import com.unboundid.ldap.sdk.extensions.PasswordModifyExtendedRequest;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.ObjectClassDefinition;
import com.unboundid.ldap.sdk.schema.ObjectClassType;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.unboundidds.controls.AccessLogFieldRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.IntermediateClientRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.IntermediateClientRequestValue;
import com.unboundid.ldap.sdk.unboundidds.controls.PasswordPolicyErrorType;
import com.unboundid.ldap.sdk.unboundidds.controls.PasswordPolicyRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.PasswordPolicyResponseControl;
import com.unboundid.ldap.sdk.unboundidds.controls.PasswordPolicyWarningType;
import com.unboundid.ldap.sdk.unboundidds.controls.PasswordQualityRequirementValidationResult;
import com.unboundid.ldap.sdk.unboundidds.controls.PasswordUpdateBehaviorRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.PasswordValidationDetailsRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.PasswordValidationDetailsResponseControl;
import com.unboundid.ldap.sdk.unboundidds.extensions.PasswordPolicyStateExtendedRequest;
import com.unboundid.ldap.sdk.unboundidds.extensions.PasswordPolicyStateExtendedResult;
import com.unboundid.ldap.sdk.unboundidds.extensions.PasswordPolicyStateOperation;
import com.unboundid.ldap.sdk.unboundidds.extensions.PasswordQualityRequirement;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.ssl.HostNameSSLSocketVerifier;
import com.unboundid.util.ssl.SSLSocketVerifier;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.LdapName;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.HttpClient;
import org.sourceid.common.Util;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.ConfigurationException;
import org.sourceid.openid.connect.util.HttpConnectionPoolingManager;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.PingOneConnection;
import org.sourceid.saml20.domain.SourceType;
import org.sourceid.saml20.domain.UserProvisioning;
import org.sourceid.saml20.domain.datasource.info.LdapInfo;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PingOneConnectionsManager;
import org.sourceid.saml20.domain.mgmt.impl.SecretReferenceHelper;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.util.log.internal.HttpRequestLoggingUtil;
import org.sourceid.util.log.internal.TrackingIdSupport;
import org.sourceid.util.log.internal.TransactionIdSupport;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.sp.ProvisioningException;

public class LDAPUtil {
    public static final String DN_ATTRIBUTE_NAME = "DN";
    public static final String USERNAME_ATTRIBUTE_NAME = "username";
    public static final int FLAG_TO_DISABLE_USER = 2;
    public static final String AD_USER_ACCOUNT_CONTROL_ATTR_NAME = "userAccountControl";
    public static final String AD_USER_ACCOUNT_DISABLED_ATTR_NAME = "msDS-UserAccountDisabled";
    private static final Log log = LogFactory.getLog(LDAPUtil.class);
    private static final PingOneConnectionsManager connectionsMgr = MgmtFactory.getPingOneConnectionsManager();
    private static final ConfigStore configStore = ConfigStoreFarm.getConfig(LDAPUtil.class);
    private static final String NO_FILTER_ERROR = "No username was provided through the filter parameter in the Admin Console.  Therefore, LDAPUtil could NOT provision the user.";
    private static final Pattern AD_PWD_EXPIRED_PATTERN = Pattern.compile(".*AcceptSecurityContext error, data ([0-9a-fA-F]+),.*");
    private static final boolean skipSchemaRetrieval = configStore.getBooleanValue("SkipSchemaRetrieval", false);
    private static final boolean cacheSchema = configStore.getBooleanValue("CacheSchema", false);
    private static final long cacheSchemaTimeoutMillis = configStore.getLongValue("CacheSchemaTimeoutMillis", 3600L);
    private static final int maxResultSetSize = configStore.getIntValue("ResultSetSize", 1000);
    private static final boolean includeClientIpInICRC = configStore.getBooleanValue("IncludeClientIpInICRC", true);
    private static final long healthCheckResponseTimeoutMillis = configStore.getLongValue("HealthCheckResponseTimeoutMillis", 2000L);
    private static final int connectionPoolCleanupInitialDelaySeconds = 0;
    private static final int connectionPoolCleanupIntervalSeconds = configStore.getIntValue("ConnectionPoolCleanupIntervalSeconds", 60);
    private static final int connectionPoolCleanupAfterSeconds = configStore.getIntValue("ConnectionPoolCleanupAfterSeconds", 30);
    private static final int HEX = 16;
    private static final ConcurrentMap<ConnectionInfo, ConnectionPoolWrapper> _wrapperCache = new ConcurrentHashMap<ConnectionInfo, ConnectionPoolWrapper>();
    private static final ConcurrentMap<ConnectionInfo, Instant> connectionCloseMap = new ConcurrentHashMap<ConnectionInfo, Instant>();
    private static final ConcurrentMap<String, Object> instanceLocks = new ConcurrentHashMap<String, Object>();
    private final ConnectionPoolWrapper connectionPoolWrapper;
    private final ServiceInformation serviceInformation;
    private final boolean isGatewayEnabled;
    private static final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(null, r, "LDAP Connection Pool Cleanup Thread");
        t.setDaemon(true);
        return t;
    });
    private static final Runnable connectionPoolCleaner = () -> {
        log.trace((Object)"[Scheduled Connection Pool Cleanup] started");
        Set<ConnectionPoolWrapper> connectionPoolsForCleanup = LDAPUtil.getConnectionPoolsForCleanup();
        if (connectionPoolsForCleanup.isEmpty()) {
            log.trace((Object)"[Scheduled Connection Pool Cleanup] ended with 0 items cleaned");
            return;
        }
        log.debug((Object)String.format("Removing [%d] old connection pool(s)", connectionPoolsForCleanup.size()));
        connectionPoolsForCleanup.forEach(wrapper -> {
            try (DSEventTimer ignored = DSEventTimer.getLdapInstance(wrapper.connectionInfo, "close-connection-pool", null);){
                try {
                    wrapper.cleanup();
                }
                catch (RuntimeException e) {
                    log.error((Object)e.getMessage());
                    log.debug((Object)e);
                    log.trace((Object)"[Scheduled Connection Pool Cleanup] ended with an error, rescheduling.");
                }
            }
        });
        log.trace((Object)String.format("[Scheduled Connection Pool Cleanup] ended with %d items cleaned", connectionPoolsForCleanup.size()));
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<ConnectionPoolWrapper> getConnectionPoolsForCleanup() {
        if (connectionCloseMap.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<ConnectionPoolWrapper> results = new HashSet<ConnectionPoolWrapper>();
        Set selectedForCleanup = connectionCloseMap.entrySet().stream().filter(entry -> Instant.now().isAfter((Instant)entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (selectedForCleanup.isEmpty()) {
            return Collections.emptySet();
        }
        for (ConnectionInfo entry2 : selectedForCleanup) {
            Object v = instanceLocks.get(entry2.getId());
            synchronized (v) {
                if (!connectionCloseMap.containsKey(entry2)) {
                    continue;
                }
                if (Instant.now().isBefore((Instant)connectionCloseMap.get(entry2))) {
                    continue;
                }
                connectionCloseMap.remove(entry2);
                results.add((ConnectionPoolWrapper)_wrapperCache.remove(entry2));
            }
        }
        return results;
    }

    private LDAPUtil(ConnectionPoolWrapper connectionPoolWrapper, ServiceInformation serviceInformation, boolean isGatewayEnabled) {
        this.connectionPoolWrapper = connectionPoolWrapper;
        this.serviceInformation = serviceInformation;
        this.isGatewayEnabled = isGatewayEnabled;
    }

    @Deprecated
    public static LDAPUtil getInstance(DataSource dataSource) throws NamingException {
        return LDAPUtil.newInstance(dataSource, null);
    }

    public static LDAPUtil newInstance(DataSource dataSource, ServiceInformation serviceInformation) throws NamingException {
        LdapDataSource ldapDataSource = (LdapDataSource)dataSource;
        return LDAPUtil.newInstance(ldapDataSource.getConnectionInfo(), serviceInformation);
    }

    @Deprecated
    public static LDAPUtil getInstance(ConnectionInfo connInfo) throws NamingException {
        return LDAPUtil.newInstance(connInfo, null);
    }

    public static LDAPUtil newInstance(ConnectionInfo connInfo, ServiceInformation serviceInformation) throws NamingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving LDAPUtil for: " + connInfo.getId() + " of type: " + connInfo.getLdapType()));
        }
        instanceLocks.putIfAbsent(connInfo.getId(), new Object());
        Object v = instanceLocks.get(connInfo.getId());
        synchronized (v) {
            LDAPUtil lDAPUtil;
            block12: {
                boolean isGateway = StringUtils.isNotBlank((String)connInfo.getPingOneConnection());
                if (_wrapperCache.containsKey(connInfo)) {
                    ConnectionPoolWrapper wrapper = (ConnectionPoolWrapper)_wrapperCache.get(connInfo);
                    connectionCloseMap.remove(connInfo);
                    LDAPUtil.scheduleOtherPoolsForCleanup(connInfo);
                    return new LDAPUtil(wrapper, serviceInformation, isGateway);
                }
                LDAPUtil.scheduleOtherPoolsForCleanup(connInfo);
                DSEventTimer ignored = DSEventTimer.getLdapInstance(connInfo, "create-connection-pool", serviceInformation);
                try {
                    ConnectionPoolWrapper wrapper = LDAPUtil.makeConnectionPoolWrapper(connInfo);
                    _wrapperCache.put(connInfo, wrapper);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Created and cached a new LdapConnectionPoolWrapper for %s (size is now %d)", connInfo, _wrapperCache.size()));
                    }
                    lDAPUtil = new LDAPUtil(wrapper, serviceInformation, isGateway);
                    if (ignored == null) break block12;
                    ((EventTimer)ignored).close();
                }
                catch (Throwable throwable) {
                    if (ignored != null) {
                        try {
                            ((EventTimer)ignored).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            return lDAPUtil;
        }
    }

    private static void scheduleOtherPoolsForCleanup(ConnectionInfo connInfo) {
        _wrapperCache.keySet().stream().filter(info -> !info.equals(connInfo)).filter(info -> StringUtils.isNotBlank((String)info.getId())).filter(info -> info.getId().equals(connInfo.getId())).filter(info -> !connectionCloseMap.containsKey(info)).forEach(info -> {
            log.debug((Object)String.format("%s connection scheduled for cleanup", info));
            Instant closeAt = Instant.now().plus((long)connectionPoolCleanupAfterSeconds, ChronoUnit.SECONDS);
            connectionCloseMap.put((ConnectionInfo)info, closeAt);
        });
    }

    private static ConnectionPoolWrapper makeConnectionPoolWrapper(ConnectionInfo connInfo) throws NamingException {
        if (StringUtils.isNotBlank((String)connInfo.getPingOneConnection())) {
            try {
                String credential = connInfo.getPingOneCredential();
                UUID envID = UUID.fromString(connInfo.getPingOneEnvironment());
                UUID gatewayID = UUID.fromString(connInfo.getPingOneGateway());
                PingOneTunneledLDAPInterface ldapInterface = new PingOneTunneledLDAPInterface((HttpClient)HttpConnectionPoolingManager.getInstance().getDefaultClient(), credential, envID, gatewayID);
                return new ConnectionPoolWrapper(ldapInterface, connInfo);
            }
            catch (InvalidCredentialException e) {
                DSEventTimer.incrementLdapErrors(connInfo.getId());
                log.error((Object)"PingOne connection credential is invalid", (Throwable)e);
                throw new LDAPErrorException.ConnectionFailedException("PingOne connection credential is invalid", e);
            }
        }
        return new ConnectionPoolWrapper(LDAPUtil.createLdapConnectionPool(connInfo), LDAPUtil.createLdapConnectionPool(connInfo), connInfo);
    }

    private static LDAPConnectionPool createLdapConnectionPool(ConnectionInfo connInfo) throws NamingException {
        LDAPConnectionPool connPool;
        String authMethod = connInfo.getAuthenticationMethod();
        SimpleBindRequest bindRequest = null;
        PostConnectProcessor postConnectProcessor = null;
        if ("simple".equals(authMethod)) {
            if (!SecretReferenceUtil.isSecretReference((String)connInfo.getCredentials())) {
                try {
                    bindRequest = LDAPUtil.generateSimpleBindRequest(connInfo);
                }
                catch (SecretManagerException secretManagerException) {}
            } else {
                postConnectProcessor = LDAPUtil.getSecreteManagerPostConnectProcessor(connInfo);
            }
        } else if ("clientTlsCert".equals(authMethod)) {
            if (!LdapInfo.LdapType.ActiveDirectory.equals((Object)connInfo.getLdapType())) {
                bindRequest = new EXTERNALBindRequest();
            }
        } else if (!"none".equals(authMethod)) {
            throw new NamingException("Unknown authentication method: " + authMethod);
        }
        try {
            Object serverSet;
            LDAPConnectionOptions connectionOptions = LDAPUtil.createConnectionOptions(connInfo);
            SSLSocketFactory socketFactory = null;
            if (connInfo.isUseStartTLS()) {
                if (postConnectProcessor == null) {
                    postConnectProcessor = new StartTLSPostConnectProcessor(LDAPUtil.getSocketFactory(connInfo));
                }
            } else {
                socketFactory = LDAPUtil.getSocketFactory(connInfo);
            }
            if (connInfo.isUseDnsSrvRecords()) {
                serverSet = LDAPUtil.getServerSet(connInfo, connectionOptions, socketFactory, (BindRequest)bindRequest, postConnectProcessor);
            } else {
                String[] serverUrls = LDAPUtil.splitServerUrls(connInfo.getServerUrl());
                String[] addresses = new String[serverUrls.length];
                int[] ports = new int[serverUrls.length];
                for (int i = 0; i < serverUrls.length; ++i) {
                    LDAPURL url = new LDAPURL(serverUrls[i]);
                    addresses[i] = url.getHost();
                    ports[i] = url.getPort();
                }
                serverSet = serverUrls.length > 1 ? new FailoverServerSet(addresses, ports, (SocketFactory)socketFactory, connectionOptions, (BindRequest)bindRequest, postConnectProcessor) : new SingleServerSet(addresses[0], ports[0], (SocketFactory)socketFactory, connectionOptions, (BindRequest)bindRequest, postConnectProcessor);
            }
            boolean testOnBorrow = connInfo.isTestOnBorrow();
            boolean testOnReturn = connInfo.isTestOnReturn();
            boolean testBackground = connInfo.getTimeBetweenEvictionRunsMillis() > 0;
            boolean createIfNecessary = connInfo.isCreateIfNecessary();
            int minConn = connInfo.getMin() == 0 ? 1 : connInfo.getMin();
            int maxConn = connInfo.getMax() > minConn ? connInfo.getMax() : minConn;
            int maxWait = connInfo.getMaxWait() > 0 ? connInfo.getMaxWait() : 0;
            int timeBetweenEviction = connInfo.getTimeBetweenEvictionRunsMillis();
            GetEntryLDAPConnectionPoolHealthCheck healthCheck = new GetEntryLDAPConnectionPoolHealthCheck(null, healthCheckResponseTimeoutMillis, true, testOnBorrow, testOnReturn, testBackground, true);
            connPool = new LDAPConnectionPool(serverSet, (BindRequest)bindRequest, minConn, maxConn, 1, null, true, (LDAPConnectionPoolHealthCheck)healthCheck);
            if (testBackground) {
                connPool.setHealthCheckIntervalMillis((long)timeBetweenEviction);
            }
            connPool.setMaxWaitTimeMillis((long)maxWait);
            connPool.setCreateIfNecessary(createIfNecessary);
            connPool.setConnectionPoolName(connInfo.getName());
            if (connInfo.isRetryFailedOperations()) {
                connPool.setRetryFailedOperationsDueToInvalidConnections(new HashSet<OperationType>(Arrays.asList(OperationType.BIND, OperationType.SEARCH, OperationType.COMPARE)));
            }
        }
        catch (LDAPException e) {
            throw LDAPUtil.convertLdapException(e, connInfo.getId());
        }
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("LDAP Pool Options ");
            sb.append("[").append(connInfo.getServerUrl()).append("]: ");
            sb.append("testOnBorrow=").append(connInfo.isTestOnBorrow()).append("; ");
            sb.append("testOnReturn=").append(connInfo.isTestOnReturn()).append("; ");
            sb.append("createIfNecessary=").append(connInfo.isCreateIfNecessary()).append("; ");
            sb.append("max=").append(connInfo.getMax()).append("; ");
            sb.append("min=").append(connInfo.getMin()).append("; ");
            sb.append("maxWait=").append(connInfo.getMaxWait()).append("; ");
            sb.append("timeBetweenEvictionRunsMillis=").append(connInfo.getTimeBetweenEvictionRunsMillis()).append("; ");
            sb.append("readTimeout=").append(connInfo.getReadTimeoutMillis()).append("; ");
            sb.append("connTimeout=").append(connInfo.getConnTimeoutMillis()).append("; ");
            log.debug((Object)sb.toString());
        }
        return connPool;
    }

    private static PostConnectProcessor getSecreteManagerPostConnectProcessor(ConnectionInfo connInfo) {
        SimpleBindPostConnectProcessor secreteManagerPostConnectProcessor = new SimpleBindPostConnectProcessor(connInfo.getPrincipal(), connInfo.getCredentials());
        SimpleBindPostConnectProcessor postConnectProcessor = connInfo.isUseStartTLS() ? new AggregatePostConnectProcessor(new PostConnectProcessor[]{new StartTLSPostConnectProcessor(LDAPUtil.getSocketFactory(connInfo)), secreteManagerPostConnectProcessor}) : secreteManagerPostConnectProcessor;
        return postConnectProcessor;
    }

    private static SSLSocketFactory getSocketFactory(ConnectionInfo connInfo) {
        SSLSocketFactory socketFactory = null;
        if (connInfo.isUseSSL() || connInfo.isUseStartTLS()) {
            socketFactory = "clientTlsCert".equals(connInfo.getAuthenticationMethod()) ? LDAPUtil.getClientTlsSocketFactory(connInfo.getClientTlsCertificate()) : PingLdapSSLSocketFactory.getDefault();
        }
        return socketFactory;
    }

    FullLDAPInterface getBindPool() {
        if (this.isGatewayEnabled && !this.connectionPoolWrapper.isConnectionActive()) {
            throw new ConfigurationException(String.format("PingOne Connection '%s' is not active.", this.connectionPoolWrapper.connectionInfo.getPingOneConnection()));
        }
        return this.connectionPoolWrapper.bindPool;
    }

    FullLDAPInterface getSearchPool() {
        if (this.isGatewayEnabled && !this.connectionPoolWrapper.isConnectionActive()) {
            throw new ConfigurationException(String.format("PingOne Connection '%s' is not active.", this.connectionPoolWrapper.connectionInfo.getPingOneConnection()));
        }
        return this.connectionPoolWrapper.searchPool;
    }

    String getBindConnectionPoolName() {
        return this.connectionPoolWrapper.bindPoolName;
    }

    String getLdapId() {
        return Optional.ofNullable(this.connectionPoolWrapper.connectionInfo).map(ConnectionInfo::getId).orElse("N/A");
    }

    String getSearchConnectionPoolName() {
        return this.connectionPoolWrapper.searchPoolName;
    }

    private FullLDAPInterface getBindPoolConnection() throws LDAPException {
        if (this.isGatewayEnabled) {
            if (!this.connectionPoolWrapper.isConnectionActive()) {
                throw new ConfigurationException(String.format("PingOne Connection '%s' is not active.", this.connectionPoolWrapper.connectionInfo.getPingOneConnection()));
            }
            return this.connectionPoolWrapper.bindPool;
        }
        return ((LDAPConnectionPool)this.connectionPoolWrapper.bindPool).getConnection();
    }

    private FullLDAPInterface getSearchPoolConnection() throws LDAPException {
        if (this.isGatewayEnabled) {
            if (!this.connectionPoolWrapper.isConnectionActive()) {
                throw new ConfigurationException(String.format("PingOne Connection '%s' is not active.", this.connectionPoolWrapper.connectionInfo.getPingOneConnection()));
            }
            return this.connectionPoolWrapper.searchPool;
        }
        return ((LDAPConnectionPool)this.connectionPoolWrapper.searchPool).getConnection();
    }

    Set<String> getSupportedControlsOIDs() {
        return Collections.unmodifiableSet(this.connectionPoolWrapper.supportedControlsOIDs);
    }

    Set<String> getExtendedOperationsOIDs() {
        return Collections.unmodifiableSet(this.connectionPoolWrapper.extendedOperationsOIDs);
    }

    List<String> getBinaryAttributes() {
        return this.connectionPoolWrapper.binaryAttributes;
    }

    ServiceInformation getServiceInformation() {
        return this.serviceInformation;
    }

    public void modifyItem(Name userLdapName, Attributes attrsToModify, int modificationCode) throws NamingException {
        try (EventTimer ignored = this.getEventTimer("modify");){
            List<Modification> mods = LDAPUtil.attributesToModifications(modificationCode, attrsToModify);
            ModifyRequest request = new ModifyRequest(userLdapName.toString(), mods);
            this.addIntermediateClientRequestControl((UpdatableLDAPRequest)request);
            this.addAccessLogFieldRequestControl((UpdatableLDAPRequest)request);
            this.getSearchPool().modify(request);
        }
        catch (LDAPException e) {
            throw LDAPUtil.convertLdapException(e, this.getLdapId());
        }
        log.debug((Object)("User: " + userLdapName.toString() + " successfully modified in the LDAP datastore"));
    }

    public void modifyUser(AttributeSource attrSource, Attributes attrsToModifyUser, AttributeMap attrsFromIdp) throws NamingException {
        String username = attrSource.getParameter("filter");
        if (StringUtils.isBlank((String)username)) {
            throw new ProvisioningException(NO_FILTER_ERROR);
        }
        Name ldapName = LDAPUtil.getLdapName(attrSource, attrsFromIdp);
        this.modifyItem(ldapName, attrsToModifyUser, 2);
    }

    private static List<Modification> attributesToModifications(int op, Attributes attribs) throws NamingException {
        ArrayList<Modification> modifications = new ArrayList<Modification>(attribs.size());
        NamingEnumeration<? extends Attribute> attribEnum = attribs.getAll();
        while (attribEnum.hasMore()) {
            Attribute attribute = attribEnum.next();
            Modification modification = LDAPUtil.attributeToModification(op, attribute);
            modifications.add(modification);
        }
        return modifications;
    }

    static Modification attributeToModification(int op, Attribute attribute) throws NamingException {
        ModificationType modType = LDAPUtil.getModificationType(op);
        if (modType == ModificationType.DELETE) {
            return new Modification(modType, attribute.getID());
        }
        ASN1OctetString[] attributeValues = LDAPUtil.getAttributeValues(attribute);
        return new Modification(modType, attribute.getID(), attributeValues);
    }

    public void addUser(Name entryDN, Attributes entryAttributes) throws NamingException {
        this.addObjectInternal(entryDN, entryAttributes);
        log.debug((Object)("User: " + entryDN.toString() + " successfully added to the LDAP datastore"));
    }

    public void addAccessGrant(Name entryDN, Attributes entryAttributes) throws NamingException {
        this.addObjectInternal(entryDN, entryAttributes);
        log.debug((Object)("Access Grant: " + entryDN.toString() + " successfully added to the LDAP datastore"));
    }

    public Name addUser(AttributeSource attrSource, Attributes attrsToProvisionUser, AttributeMap attrsFromIdp) throws NamingException, Substituter.UnknownKeyException {
        String filterParam = attrSource.getParameter("filter");
        String filter = Substituter.substituteValues(filterParam, (Map)attrsFromIdp);
        if (StringUtils.isBlank((String)filter)) {
            throw new ProvisioningException(NO_FILTER_ERROR);
        }
        Name newName = LDAPUtil.getLdapName(attrSource, attrsFromIdp);
        this.addObjectInternal(newName, attrsToProvisionUser);
        log.debug((Object)("User: " + newName.toString() + " successfully added to the LDAP datastore"));
        return newName;
    }

    private void addObjectInternal(Name newName, Attributes attrsToAdd) throws NamingException {
        try (EventTimer ignored = this.getEventTimer("add");){
            ArrayList<com.unboundid.ldap.sdk.Attribute> attributes = new ArrayList<com.unboundid.ldap.sdk.Attribute>(attrsToAdd.size());
            NamingEnumeration<? extends Attribute> attribEnum = attrsToAdd.getAll();
            while (attribEnum.hasMore()) {
                Attribute attribute = attribEnum.next();
                if (attribute.size() <= 0) continue;
                ASN1OctetString[] attributeValues = LDAPUtil.getAttributeValues(attribute);
                com.unboundid.ldap.sdk.Attribute attrToInsert = new com.unboundid.ldap.sdk.Attribute(attribute.getID(), attributeValues);
                attributes.add(attrToInsert);
            }
            AddRequest request = new AddRequest(newName.toString(), attributes);
            this.addIntermediateClientRequestControl((UpdatableLDAPRequest)request);
            this.addAccessLogFieldRequestControl((UpdatableLDAPRequest)request);
            this.getSearchPool().add(request);
        }
        catch (LDAPException e) {
            throw LDAPUtil.convertLdapException(e, this.getLdapId());
        }
    }

    public void createGroup(Name name, Attributes attributes) throws NamingException {
        this.addObjectInternal(name, attributes);
        log.debug((Object)("Group: " + name.toString() + " successfully added to the LDAP datastore"));
    }

    static ASN1OctetString[] getAttributeValues(Attribute attribute) throws NamingException {
        ASN1OctetString[] values = new ASN1OctetString[attribute.size()];
        for (int i = 0; i < values.length; ++i) {
            Object attributeValue = attribute.get(i);
            values[i] = attributeValue instanceof String ? new ASN1OctetString((String)attributeValue) : new ASN1OctetString((byte[])attributeValue);
        }
        return values;
    }

    public void changePassword(Name entryDN, String oldPassword, String newPassword, LdapDataSource dataSource, boolean enablePingDirectoryDetailedPwdReq) throws NamingException, LDAPPasswordPolicyViolationException {
        FullLDAPInterface conn;
        if (LDAPUtil.isPasswordChangeable(dataSource)) {
            log.debug((Object)("Changing password for user: " + entryDN));
            conn = null;
            boolean isPasswordExpired = false;
            try (EventTimer ignored = this.getEventTimer("change-password");){
                String subjectDn;
                block14: {
                    conn = this.getBindPoolConnection();
                    subjectDn = entryDN.toString();
                    try {
                        LinkedList<Control> controlsList = new LinkedList<Control>();
                        controlsList.add((Control)new PasswordPolicyRequestControl());
                        this.addIntermediateClientRequestControl(controlsList);
                        this.addAccessLogFieldRequestControl(controlsList);
                        SimpleBindRequest bindRequest = new SimpleBindRequest(subjectDn, oldPassword, controlsList.toArray(new Control[controlsList.size()]));
                        conn.bind((BindRequest)bindRequest);
                    }
                    catch (LDAPException e) {
                        isPasswordExpired = this.isPasswordExpired(dataSource, e);
                        if (isPasswordExpired) break block14;
                        throw e;
                    }
                }
                if (this.getExtendedOperationsOIDs().contains("1.3.6.1.4.1.4203.1.11.1") && !dataSource.isSunOneType() && StringUtils.isNotBlank((String)oldPassword)) {
                    this.resetPasswordExtended(subjectDn, oldPassword, newPassword, isPasswordExpired, enablePingDirectoryDetailedPwdReq);
                }
                this.changePasswordField(entryDN, oldPassword, newPassword, dataSource, conn, isPasswordExpired, enablePingDirectoryDetailedPwdReq);
            }
            catch (LDAPException e) {
                LDAPInterfaceUtil.releaseInterfaceAfterException((LDAPInterface)this.getBindPool(), conn, e);
                throw LDAPUtil.convertLdapException(e, this.getLdapId());
            }
            catch (RuntimeException e) {
                LDAPInterfaceUtil.releaseInterface((LDAPInterface)this.getBindPool(), conn);
                throw e;
            }
        } else {
            throw new IllegalStateException("Password changes are not allowed on this LDAP data source.  Prevent this exception by calling isPasswordChangeable() before calling changePassword().");
        }
        LDAPInterfaceUtil.releaseInterface((LDAPInterface)this.getBindPool(), (LDAPInterface)conn);
    }

    private void changePasswordField(Name entryDN, String oldPassword, String newPassword, LdapDataSource dataSource, FullLDAPInterface conn, boolean isPasswordExpired, boolean enablePingDirectoryDetailedPwdReq) throws NamingException, LDAPException, LDAPPasswordPolicyViolationException {
        Modification newitem;
        Modification olditem;
        Attribute oldattr = LDAPUtil.loadPasswordAttribute(oldPassword, dataSource);
        Attribute newattr = LDAPUtil.loadPasswordAttribute(newPassword, dataSource);
        ArrayList<Modification> mods = new ArrayList<Modification>();
        if (dataSource.isActiveDirectoryType()) {
            olditem = new Modification(ModificationType.DELETE, oldattr.getID(), (byte[])oldattr.get());
            newitem = new Modification(ModificationType.ADD, newattr.getID(), (byte[])newattr.get());
        } else {
            olditem = new Modification(ModificationType.DELETE, oldattr.getID(), oldPassword.getBytes(StandardCharsets.UTF_8));
            newitem = new Modification(ModificationType.ADD, newattr.getID(), newPassword.getBytes(StandardCharsets.UTF_8));
        }
        mods.add(olditem);
        mods.add(newitem);
        LinkedList<Control> controls = new LinkedList<Control>();
        boolean getPwdReqMessagingForPingDirectory = enablePingDirectoryDetailedPwdReq ? this.addPasswordValidationDetailsRequestControl(controls) : false;
        this.addIntermediateClientRequestControl(controls);
        this.addAccessLogFieldRequestControl(controls);
        ModifyRequest request = new ModifyRequest(entryDN.toString(), mods, controls.toArray(new Control[controls.size()]));
        try {
            if (isPasswordExpired) {
                this.getSearchPool().modify(request);
            } else {
                conn.modify(request);
            }
        }
        catch (LDAPException e) {
            this.processPasswordValidationResults(getPwdReqMessagingForPingDirectory, e.toLDAPResult());
            if (this.isInsufficientRightsForPasswordValidationDetailsRequest(e.getResultCode(), e.getDiagnosticMessage())) {
                log.error((Object)("Reset password without proxy auth using modify request and password validation details request control [LDAP: error code " + e.getResultCode().intValue() + " - " + e.getDiagnosticMessage() + "]"));
                log.debug((Object)"Redoing reset password without password validation details request control.");
                this.changePasswordField(entryDN, oldPassword, newPassword, dataSource, conn, isPasswordExpired, false);
            }
            throw e;
        }
    }

    private boolean isPasswordExpired(LdapDataSource dataSource, LDAPException e) throws LDAPException {
        boolean passwordExpired = false;
        if (dataSource.isActiveDirectoryType()) {
            if (LDAPUtil.isADPasswordExpiredResetException(e.getMessage())) {
                passwordExpired = true;
            }
        } else {
            PasswordPolicyErrorType errorType;
            BindResult result = new BindResult(e.toLDAPResult());
            PasswordPolicyResponseControl pwpResponse = PasswordPolicyResponseControl.get((LDAPResult)result);
            if (pwpResponse != null && (PasswordPolicyErrorType.PASSWORD_EXPIRED == (errorType = pwpResponse.getErrorType()) || PasswordPolicyErrorType.CHANGE_AFTER_RESET == errorType)) {
                passwordExpired = true;
            }
        }
        return passwordExpired;
    }

    static boolean isADPasswordExpiredResetException(String errMsg) {
        Matcher matcher = AD_PWD_EXPIRED_PATTERN.matcher(errMsg);
        if (matcher.matches()) {
            int code = Integer.parseInt(matcher.group(1), 16);
            return code == 1330 || code == 1907;
        }
        return false;
    }

    public static Attribute loadPasswordAttribute(String password, LdapDataSource dataSource) throws NamingException {
        BasicAttribute attribute;
        if (dataSource.isActiveDirectoryType()) {
            try {
                attribute = new BasicAttribute(dataSource.getPasswordAttribute(), LDAPUtil.encodePassword(password));
            }
            catch (UnsupportedEncodingException e) {
                NamingException ne = new NamingException("Error encoding password");
                ne.initCause(e);
                throw ne;
            }
        } else {
            attribute = new BasicAttribute(dataSource.getPasswordAttribute(), password);
        }
        return attribute;
    }

    public static boolean isPasswordChangeable(LdapDataSource dataSource) {
        if (dataSource.isActiveDirectoryType() && !dataSource.getUseSSL() && !dataSource.getUseStartTLS()) {
            log.warn((Object)("The change password feature is disabled for this password credential validator instance because the data source '" + dataSource.getDescription() + "' uses Active Directory and is not configured with SSL or StartTLS. SSL or StartTLS must be enabled to change passwords in Active Directory."));
        }
        return dataSource.isActiveDirectoryType() && (dataSource.getUseSSL() || dataSource.getUseStartTLS()) || !dataSource.isActiveDirectoryType();
    }

    public static byte[] encodePassword(String password) throws UnsupportedEncodingException {
        String newQuotedPassword = "\"" + password + "\"";
        return newQuotedPassword.getBytes(StandardCharsets.UTF_16LE);
    }

    public static Attributes loadAttrs(AttributeMap srcAttrs) {
        BasicAttributes attrsToProvisionUser = new BasicAttributes(false);
        for (Map.Entry e : srcAttrs.entrySet()) {
            BasicAttribute basicAttr = LDAPUtil.toBasicAttribute((String)e.getKey(), (AttributeValue)e.getValue());
            attrsToProvisionUser.put(basicAttr);
        }
        return attrsToProvisionUser;
    }

    public static BasicAttribute toBasicAttribute(String key, AttributeValue value) {
        BasicAttribute basicAttr = new BasicAttribute(key);
        for (String v : value.getValues()) {
            basicAttr.add(v);
        }
        return basicAttr;
    }

    public static Name getLdapName(AttributeSource attrSrc, AttributeMap attrsFromIdp) throws NamingException {
        attrsFromIdp = LDAPUtil.nameEncodeValues(attrsFromIdp);
        String userDN = LDAPUtil.getFullDn(attrSrc);
        return LDAPUtil.resolveLdapName(userDN, attrsFromIdp);
    }

    private static LdapName resolveLdapName(String userDN, AttributeMap attrsFromIdp) throws NamingException {
        List<AttrMappingValue> userDNList = Arrays.asList(new AttrMappingValue(SourceType.TEXT, userDN));
        HashMap<String, List<AttrMappingValue>> userDNMap = new HashMap<String, List<AttrMappingValue>>();
        userDNMap.put("filter", userDNList);
        UserProvisioning tempUserProvisioning = new UserProvisioning();
        tempUserProvisioning.setAttributeMap2(userDNMap);
        try {
            AttributeMap tempMap = tempUserProvisioning.executeMapping(attrsFromIdp, tempUserProvisioning.getAttributeMapping().keySet());
            AttributeValue filter = (AttributeValue)tempMap.get((Object)"filter");
            if (filter == null) {
                throw new ProvisioningException("There was a problem retrieving the filter attribute value");
            }
            return new LdapName(filter.getValue());
        }
        catch (AuthorizationException attrEx) {
            throw new ProvisioningException(attrEx.getErrorDetail(), attrEx);
        }
        catch (AttrLookupException attrEx) {
            throw new ProvisioningException("There was a problem translating text values in the User DN: " + userDN);
        }
    }

    private static String getFullDn(AttributeSource attrSrc) {
        String username = attrSrc.getParameter("filter");
        String baseDN = attrSrc.getParameter("search_base");
        username = LDAPUtil.encodeRdn(username);
        return !StringUtils.isBlank((String)(baseDN = LDAPUtil.encodeBaseDN(baseDN))) ? username + "," + baseDN : username;
    }

    private static String encodeBaseDN(String baseDN) {
        LinkedList<String> processedBaseDn = new LinkedList<String>();
        List<String> tokens = Arrays.asList(baseDN.split(","));
        if (tokens.size() > 1) {
            for (String token : tokens) {
                processedBaseDn.add(LDAPUtil.encodeRdn(token));
            }
        } else {
            processedBaseDn.add(LDAPUtil.encodeRdn(baseDN));
        }
        return Util.listToDelimString(processedBaseDn, ",");
    }

    private static String encodeRdn(String rdn) {
        if (!rdn.contains("$") && rdn.contains("=")) {
            List<String> tokens = Arrays.asList(rdn.split("="));
            return tokens.get(0) + "=" + DNUtil.escapeDN((String)tokens.get(1));
        }
        return rdn;
    }

    public List<String> getDistinguishedName(LDAPUtilOptions ldapOptions) throws NamingException {
        List<SearchResultEntry> results = this.search(ldapOptions);
        ArrayList<String> names = new ArrayList<String>();
        for (SearchResultEntry result : results) {
            names.add(result.getDN());
        }
        return names;
    }

    public List<AttributeMap> getAttributesOfMatchingObjects(LDAPUtilOptions ldapOptions) throws NamingException {
        List<SearchResultEntry> results = this.search(ldapOptions);
        return this.convertSearchResultsToAttributeMaps(results, true);
    }

    public SearchRequest buildAttributesOfMatchingObjectsSearchRequest(LDAPUtilOptions ldapOptions) throws NamingException {
        SearchRequest request;
        try {
            request = new SearchRequest(ldapOptions.getSearchBase(), LDAPUtil.getSearchScope(ldapOptions.getSearchScope()), ldapOptions.getSearchFilter(), new String[0]);
            if (ldapOptions.getAttributes() != null) {
                request.setAttributes(ldapOptions.getAttributes());
            }
            request.setSizeLimit(ldapOptions.getCount());
            this.addIntermediateClientRequestControl((UpdatableLDAPRequest)request);
            this.addAccessLogFieldRequestControl((UpdatableLDAPRequest)request);
        }
        catch (LDAPException e) {
            throw LDAPUtil.convertLdapException(e, this.getLdapId());
        }
        return request;
    }

    public AttributeMap processSearchesThenOpResponse(DirectLdapSearchesThenOpResponse directLdapSearchesThenOpResponse, LdapDataSource dataSource, LDAPUtilOptions ldapOptions, boolean isTrimUsername, String username) throws NamingException {
        if (directLdapSearchesThenOpResponse == null || directLdapSearchesThenOpResponse.getSearchResults() == null) {
            throw LDAPUtil.convertLdapException(new LDAPException(ResultCode.CONNECT_ERROR, "Error processing LDAP request"), this.getLdapId());
        }
        if (directLdapSearchesThenOpResponse.getSearchResults().length != 1) {
            throw new ProcessRuntimeException("Unexpected number of search results: " + directLdapSearchesThenOpResponse.getSearchResults().length);
        }
        SearchResult searchResult = directLdapSearchesThenOpResponse.getSearchResults()[0];
        if (searchResult.getResultCode() != ResultCode.SUCCESS) {
            throw LDAPUtil.convertLdapException(new LDAPException((LDAPResult)searchResult), this.getLdapId());
        }
        List searchResultEntries = searchResult.getSearchEntries();
        List<AttributeMap> attributeMaps = this.getUserAttributeMapsFromResults(dataSource.getLdapType().toString(), ldapOptions, isTrimUsername, username, searchResultEntries);
        if (attributeMaps.isEmpty()) {
            return null;
        }
        if (attributeMaps.size() > 1) {
            throw LDAPUtil.convertLdapException(new LDAPException(ResultCode.SIZE_LIMIT_EXCEEDED, "Search returned more than one entry"), this.getLdapId());
        }
        AttributeMap attributes = attributeMaps.get(0);
        LDAPResult postSearchResult = directLdapSearchesThenOpResponse.getPostSearchResult();
        if (postSearchResult == null) {
            throw new ProcessRuntimeException("DirectLdapSearchesThenOpResponse missing post-search result");
        }
        try {
            if (postSearchResult.getResultCode() != ResultCode.SUCCESS) {
                throw new LDAPException(postSearchResult);
            }
            PasswordPolicyResponseControl pwpResponse = PasswordPolicyResponseControl.get((LDAPResult)postSearchResult);
            if (pwpResponse != null && PasswordPolicyErrorType.CHANGE_AFTER_RESET == pwpResponse.getErrorType()) {
                throw new LDAPException(ResultCode.UNWILLING_TO_PERFORM, "Password was reset and must be changed.");
            }
        }
        catch (LDAPException ldapException) {
            boolean expectPwdExpiredControl = ldapOptions.isExpectPasswordExpiryControl();
            this.handleException(ldapException, attributes.getSingleValue(DN_ATTRIBUTE_NAME), dataSource, expectPwdExpiredControl);
        }
        return attributes;
    }

    private List<AttributeMap> getUserAttributeMapsFromResults(String dataSourceType, LDAPUtilOptions ldapOptions, boolean isTrimUsername, String username, List<SearchResultEntry> searchResultEntries) throws NamingException {
        LDAPPasswordPolicyUtil ldapPasswordUtil = new LDAPPasswordPolicyUtil(this);
        Map<Object, Object> passwordPolicyAttributes = Collections.emptyMap();
        LDAPPasswordPolicy passwordPolicyType = LDAPPasswordPolicy.canonicalName(dataSourceType);
        if (passwordPolicyType != null) {
            passwordPolicyAttributes = ldapPasswordUtil.getPasswordPolicyAttributeValues(ldapOptions, passwordPolicyType, searchResultEntries);
        }
        String passwordExpiryTimeAttributeValue = (String)passwordPolicyAttributes.get("passwordExpiryTime");
        String secondsUntilPasswordExpiration = (String)passwordPolicyAttributes.get("seconds-until-password-expiration");
        List<AttributeMap> attributeMaps = this.getUserAttributeMapsFromResults(searchResultEntries, ldapPasswordUtil, passwordExpiryTimeAttributeValue, secondsUntilPasswordExpiration);
        for (AttributeMap attributes : attributeMaps) {
            attributes.put(DN_ATTRIBUTE_NAME, searchResultEntries.get(0).getDN());
            String usernameAttribute = isTrimUsername ? LDAPUtil.stripSpaces(username) : username;
            attributes.put(USERNAME_ATTRIBUTE_NAME, usernameAttribute);
        }
        return attributeMaps;
    }

    public List<AttributeMap> getUserAttributesForMatchingObjects(LDAPUtilOptions ldapOptions, String ldapType, boolean isTrimUsername, String username) throws NamingException {
        List<SearchResultEntry> userAttributeEntries = this.search(ldapOptions);
        return this.getUserAttributeMapsFromResults(ldapType, ldapOptions, isTrimUsername, username, userAttributeEntries);
    }

    private List<AttributeMap> getUserAttributeMapsFromResults(List<SearchResultEntry> searchResultEntries, LDAPPasswordPolicyUtil ldapPasswordUtil, String passwordExpiryTimeAttributeValue, String secondsUntilPasswordExpiration) {
        if (passwordExpiryTimeAttributeValue == null && secondsUntilPasswordExpiration == null) {
            return this.convertSearchResultsToAttributeMaps(searchResultEntries, true);
        }
        return ldapPasswordUtil.convertPasswordDnSearchResultsToAttributeMaps(searchResultEntries, true, passwordExpiryTimeAttributeValue, secondsUntilPasswordExpiration);
    }

    private void handleException(LDAPException ldapException, String name, LdapDataSource dataSource, boolean expectPwdExpiredControl) throws NamingException {
        if (dataSource.isPingDirectoryOrPingDSType()) {
            BindResult result = new BindResult(ldapException.toLDAPResult());
            try {
                PasswordExpiredControl expiredControl;
                if (expectPwdExpiredControl && (expiredControl = PasswordExpiredControl.get((LDAPResult)result)) != null) {
                    throw new LDAPException(ResultCode.INVALID_CREDENTIALS, PasswordPolicyErrorType.PASSWORD_EXPIRED.getName());
                }
                PasswordPolicyResponseControl pwpResponse = PasswordPolicyResponseControl.get((LDAPResult)result);
                if (pwpResponse != null) {
                    PasswordPolicyErrorType errorType = pwpResponse.getErrorType();
                    if (errorType != null) {
                        String errorMessage;
                        if (PasswordPolicyErrorType.ACCOUNT_LOCKED.equals((Object)errorType)) {
                            errorMessage = this.getPingDirectoryAccountLockedReason(name);
                        } else {
                            if (PasswordPolicyErrorType.PASSWORD_EXPIRED.equals((Object)errorType) && expectPwdExpiredControl) {
                                throw LDAPUtil.convertLdapException(ldapException, this.getLdapId());
                            }
                            if (PasswordPolicyErrorType.CHANGE_AFTER_RESET.equals((Object)errorType)) {
                                throw LDAPUtil.convertLdapException(ldapException, this.getLdapId());
                            }
                            errorMessage = errorType.getName();
                        }
                        throw new LDAPException(ResultCode.INVALID_CREDENTIALS, errorMessage);
                    }
                    PasswordPolicyWarningType warningType = pwpResponse.getWarningType();
                    if (warningType != null) {
                        throw new LDAPException(ResultCode.INVALID_CREDENTIALS, warningType.getName());
                    }
                }
            }
            catch (LDAPException ex) {
                throw LDAPUtil.convertLdapException(ex, this.getLdapId());
            }
        }
        throw LDAPUtil.convertLdapException(ldapException, this.getLdapId());
    }

    public AttributeMap getAttributesOfMatchingObject(LDAPUtilOptions ldapOptions) throws NamingException {
        ldapOptions.setCount(1);
        List<SearchResultEntry> results = this.search(ldapOptions);
        List<AttributeMap> attributeMaps = this.convertSearchResultsToAttributeMaps(results, true);
        if (attributeMaps.size() == 1) {
            return attributeMaps.get(0);
        }
        return null;
    }

    public AttributeMap getAttributesOfMatchingObject(String dn) throws NamingException {
        SearchResultEntry searchResultEntry = this.searchEntry(dn);
        List<AttributeMap> attributeMaps = this.convertSearchResultsToAttributeMaps(Arrays.asList(searchResultEntry), true);
        if (attributeMaps.size() == 1) {
            return attributeMaps.get(0);
        }
        return null;
    }

    private List<AttributeMap> convertSearchResultsToAttributeMaps(List<SearchResultEntry> results, boolean includeCustomSubjectDn) {
        ArrayList<AttributeMap> attributeMaps = new ArrayList<AttributeMap>();
        for (SearchResultEntry result : results) {
            if (result == null) continue;
            AttributeMap mappingResult = this.getAttributeMap(includeCustomSubjectDn, result);
            attributeMaps.add(mappingResult);
        }
        return attributeMaps;
    }

    public List<AttributeMap> getAttributesOfMatchingObjects(LDAPUtilOptions ldapUtilOptions, List<String> binaryAttrs) throws NamingException {
        List<SearchResultEntry> results = this.search(ldapUtilOptions);
        List<AttributeMap> attributeMaps = this.convertSearchResultsToAttributeMaps(results, true, binaryAttrs);
        return attributeMaps;
    }

    private List<AttributeMap> convertSearchResultsToAttributeMaps(List<SearchResultEntry> results, boolean includeCustomSubjectDn, List<String> binaryAttrs) {
        ArrayList<AttributeMap> attributeMaps = new ArrayList<AttributeMap>();
        for (SearchResultEntry result : results) {
            if (result == null) continue;
            AttributeMap mappingResult = this.getAttributeMap(includeCustomSubjectDn, result, binaryAttrs);
            attributeMaps.add(mappingResult);
        }
        return attributeMaps;
    }

    public AttributeMap getAttributeMap(boolean includeCustomSubjectDn, SearchResultEntry result, List<String> binaryAttrs) {
        ArrayList<String> allBinaryAttributes = new ArrayList<String>();
        allBinaryAttributes.addAll(binaryAttrs);
        allBinaryAttributes.addAll(this.getBinaryAttributes());
        AttributeMap mappingResult = this.getByteAttributeValues(result, allBinaryAttributes);
        if (includeCustomSubjectDn) {
            AttributeValue dnAttr = new AttributeValue(result.getDN().trim());
            mappingResult.put("Subject DN", dnAttr);
        }
        return mappingResult;
    }

    protected AttributeMap getAttributeMap(boolean includeCustomSubjectDn, SearchResultEntry result) {
        return this.getAttributeMap(includeCustomSubjectDn, result, this.getBinaryAttributes());
    }

    private AttributeMap getByteAttributeValues(SearchResultEntry result, List<String> binaryAttrs) {
        AttributeMap mappingResult = new AttributeMap();
        for (com.unboundid.ldap.sdk.Attribute attribute : result.getAttributes()) {
            ArrayList<Object> attributeValuesList = new ArrayList<Object>();
            if (binaryAttrs.contains(attribute.getBaseName())) {
                byte[][] binaryAttribValues = attribute.getValueByteArrays();
                attributeValuesList.addAll(Arrays.asList(binaryAttribValues));
            } else {
                String[] attributeValues = attribute.getValues();
                attributeValuesList.addAll(Arrays.asList(attributeValues));
            }
            AttributeValue attributeValue = AttrValueSupport.make(attributeValuesList, (boolean)true);
            mappingResult.put(attribute.getName(), attributeValue);
        }
        return mappingResult;
    }

    private List<SearchResultEntry> search(LDAPUtilOptions ldapOptions) throws NamingException {
        SearchScope convertedSearchScope = LDAPUtil.getSearchScope(ldapOptions.getSearchScope());
        List<SearchResultEntry> resultEntry = Collections.emptyList();
        if (SearchScope.BASE == convertedSearchScope) {
            SearchResultEntry result = this.searchEntry(ldapOptions.getSearchBase(), ldapOptions.getAttributes());
            if (result != null) {
                resultEntry = Arrays.asList(result);
            }
        } else {
            resultEntry = this.searchWithFilter(ldapOptions);
        }
        return resultEntry;
    }

    private List<SearchResultEntry> searchWithFilter(LDAPUtilOptions ldapOptions) throws NamingException {
        List<SearchResultEntry> searchResult = Collections.emptyList();
        try {
            SearchRequest request = new SearchRequest(ldapOptions.getSearchBase(), LDAPUtil.getSearchScope(ldapOptions.getSearchScope()), ldapOptions.getSearchFilter(), new String[0]);
            if (ldapOptions.getAttributes() != null) {
                request.setAttributes(ldapOptions.getAttributes());
            }
            searchResult = this.searchWithFilter(ldapOptions, request);
        }
        catch (LDAPException e) {
            throw LDAPUtil.convertLdapException(e, this.getLdapId());
        }
        return searchResult;
    }

    void addIntermediateClientRequestControl(UpdatableLDAPRequest request) {
        IntermediateClientRequestControl intermediateClientRequestControl = this.createIntermediateClientRequestControl();
        if (intermediateClientRequestControl != null) {
            request.addControl((Control)intermediateClientRequestControl);
        }
    }

    private IntermediateClientRequestControl createIntermediateClientRequestControl() {
        if (this.getSupportedControlsOIDs().contains("1.3.6.1.4.1.30221.2.5.2")) {
            String trackingId = TrackingIdSupport.getTrackingId();
            String requestId = TrackingIdSupport.getRequestId();
            if (StringUtils.isNotBlank((String)trackingId) || StringUtils.isNotBlank((String)requestId)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating intermediate client request control using tracking ID: " + trackingId + " and request ID: " + requestId));
                }
                String downstreamClientAddress = null;
                if (includeClientIpInICRC) {
                    HttpServletRequest request = HttpRequestLoggingUtil.getRequest();
                    if (request != null) {
                        downstreamClientAddress = request.getRemoteAddr();
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)"Unable to get client address. Intermediate client request control's downstream client address won't be set.");
                    }
                }
                return new IntermediateClientRequestControl(false, new IntermediateClientRequestValue(null, downstreamClientAddress, null, null, "PingFederate", trackingId, requestId));
            }
        }
        return null;
    }

    private void addAccessLogFieldRequestControl(Collection<Control> controls) {
        AccessLogFieldRequestControl accessLogFieldRequestControl = this.createAccessLogFieldRequestControl();
        if (accessLogFieldRequestControl != null) {
            controls.add((Control)accessLogFieldRequestControl);
        }
    }

    void addAccessLogFieldRequestControl(UpdatableLDAPRequest request) {
        AccessLogFieldRequestControl accessLogFieldRequestControl = this.createAccessLogFieldRequestControl();
        if (accessLogFieldRequestControl != null) {
            request.addControl((Control)accessLogFieldRequestControl);
        }
    }

    private AccessLogFieldRequestControl createAccessLogFieldRequestControl() {
        String transactionId;
        if (this.getSupportedControlsOIDs().contains("1.3.6.1.4.1.30221.2.5.66") && StringUtils.isNotBlank((String)(transactionId = TransactionIdSupport.getTransactionId()))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating access log field request control using transaction ID: " + transactionId));
            }
            JSONField jsonField = new JSONField("transactionID", TransactionIdSupport.getTransactionId());
            try {
                return new AccessLogFieldRequestControl(new JSONField[]{jsonField});
            }
            catch (LDAPException e) {
                log.warn((Object)"Unable to create access log field request control.", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    List<SearchResultEntry> searchWithFilter(LDAPUtilOptions ldapOptions, SearchRequest request) throws LDAPException {
        request.setSizeLimit(ldapOptions.getCount());
        try (EventTimer ignored = this.getEventTimer("search");){
            if (ldapOptions.getCount() != 1 && this.getSupportedControlsOIDs().contains("1.2.840.113556.1.4.319")) {
                List<SearchResultEntry> list = this.searchWithFilterAndSimplePagination(request, ldapOptions);
                return list;
            }
            if (ldapOptions.getCount() != 1 && this.getSupportedControlsOIDs().contains("2.16.840.1.113730.3.4.9")) {
                List<SearchResultEntry> list = this.searchWithFilterAndVLVPagination(request, ldapOptions);
                return list;
            }
            if (ldapOptions.getCount() != 1 && this.getSupportedControlsOIDs().contains("1.2.840.113556.1.4.473") && ldapOptions.isEnableServerSort()) {
                List<SortKey> sortKeys = this.getSortKeys(ldapOptions);
                request.addControl((Control)new ServerSideSortRequestControl(sortKeys.toArray(new SortKey[sortKeys.size()])));
            }
            this.addIntermediateClientRequestControl((UpdatableLDAPRequest)request);
            this.addAccessLogFieldRequestControl((UpdatableLDAPRequest)request);
            SearchResult result = this.getSearchPool().search(request);
            if (result.getResultCode() == ResultCode.SUCCESS) {
                List list = result.getSearchEntries();
                return list;
            }
        }
        return Collections.emptyList();
    }

    private List<SearchResultEntry> searchWithFilterAndSimplePagination(SearchRequest request, LDAPUtilOptions ldapOptions) throws LDAPException {
        int offset = ldapOptions.getStartIndex();
        SimplePaginationState paginationState = ldapOptions.getPaginationState();
        if (offset <= 1 || paginationState != null) {
            offset = 1;
        }
        int totalEntriesReturned = 0;
        int totalResultsToGet = ldapOptions.getResultsPerPage();
        ArrayList<SearchResultEntry> entries = new ArrayList<SearchResultEntry>();
        List<SortKey> sortKeys = this.getSortKeys(ldapOptions);
        FullLDAPInterface conn = null;
        ASN1OctetString resumeCookie = null;
        if (paginationState != null) {
            if (paginationState.getConnection() != null) {
                conn = paginationState.getConnection();
            }
            resumeCookie = paginationState.getResumeCookie();
        }
        if (conn == null) {
            conn = this.getSearchPoolConnection();
        }
        try {
            SearchResult searchResult;
            boolean firstSearch = true;
            block5: while (true) {
                try {
                    SimplePagedResultsControl responseControl;
                    while (true) {
                        int resultsPerRequest;
                        if (totalResultsToGet > 0 && totalEntriesReturned + maxResultSetSize > offset + totalResultsToGet) {
                            resultsPerRequest = totalEntriesReturned > 0 ? offset + totalResultsToGet - totalEntriesReturned : offset + totalResultsToGet;
                            --resultsPerRequest;
                        } else {
                            resultsPerRequest = maxResultSetSize;
                        }
                        request.setControls(new Control[]{new SimplePagedResultsControl(resultsPerRequest, resumeCookie)});
                        if (this.getSupportedControlsOIDs().contains("1.2.840.113556.1.4.473") && ldapOptions.isEnableServerSort()) {
                            request.addControl((Control)new ServerSideSortRequestControl(sortKeys.toArray(new SortKey[sortKeys.size()])));
                        }
                        this.addIntermediateClientRequestControl((UpdatableLDAPRequest)request);
                        this.addAccessLogFieldRequestControl((UpdatableLDAPRequest)request);
                        searchResult = conn.search(request);
                        firstSearch = false;
                        responseControl = SimplePagedResultsControl.get((SearchResult)searchResult);
                        if (totalEntriesReturned + searchResult.getEntryCount() >= offset) {
                            if (entries.isEmpty()) {
                                int startIndex = offset - totalEntriesReturned - 1;
                                int endIndex = searchResult.getEntryCount();
                                List entriesToAdd = searchResult.getSearchEntries().subList(startIndex, endIndex);
                                entries.addAll(entriesToAdd);
                            } else {
                                entries.addAll(searchResult.getSearchEntries());
                            }
                        }
                        totalEntriesReturned += searchResult.getEntryCount();
                        if (totalResultsToGet > 0 && entries.size() >= totalResultsToGet) {
                            LDAPUtil.setSimplePaginationState(conn, ldapOptions, responseControl);
                            break block5;
                        }
                        if (responseControl == null || !responseControl.moreResultsToReturn()) break;
                        resumeCookie = responseControl.getCookie();
                    }
                    LDAPUtil.setSimplePaginationState(conn, ldapOptions, responseControl);
                }
                catch (LDAPException e) {
                    if (paginationState == null && firstSearch && this.checkRetryAfterException(this.getSearchPool(), conn, e)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Performing retry after LDAP exception: " + e));
                        }
                        conn = ((LDAPConnectionPool)this.getSearchPool()).replaceDefunctConnection((LDAPConnection)conn);
                        continue;
                    }
                    throw e;
                }
                break;
            }
            if (ldapOptions.isRetrieveLastElement() && offset > totalEntriesReturned && entries.isEmpty() && searchResult.getEntryCount() > 0) {
                entries.add((SearchResultEntry)searchResult.getSearchEntries().get(searchResult.getEntryCount() - 1));
            }
        }
        catch (LDAPException e) {
            LDAPInterfaceUtil.releaseInterfaceAfterException((LDAPInterface)this.getSearchPool(), (LDAPInterface)conn, e);
            throw e;
        }
        catch (RuntimeException e) {
            LDAPInterfaceUtil.releaseInterface((LDAPInterface)this.getSearchPool(), (LDAPInterface)conn);
            throw e;
        }
        if (paginationState == null || paginationState.getResumeCookie() == null) {
            LDAPInterfaceUtil.releaseInterface((LDAPInterface)this.getSearchPool(), (LDAPInterface)conn);
            if (paginationState != null && paginationState.getResumeCookie() == null) {
                ldapOptions.setPaginationState(null);
            }
        }
        return entries;
    }

    private boolean checkRetryAfterException(FullLDAPInterface pool, FullLDAPInterface conn, LDAPException e) {
        if (!(pool instanceof LDAPConnectionPool)) {
            return false;
        }
        LDAPConnectionPool ldapConnectionPool = (LDAPConnectionPool)pool;
        if (!(conn instanceof LDAPConnection)) {
            return false;
        }
        LDAPConnection ldapConnection = (LDAPConnection)conn;
        if (!this.connectionPoolWrapper.connectionInfo.isRetryFailedOperations()) {
            return false;
        }
        LDAPConnectionPoolHealthCheck healthCheck = ldapConnectionPool.getHealthCheck();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking connection status after exception: " + e));
            }
            healthCheck.ensureConnectionValidAfterException(ldapConnection, e);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Health check indicates connection is still valid");
            }
            return false;
        }
        catch (LDAPException e2) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Health check indicates connection is invalid, it will be discarded: " + e2));
            }
            return true;
        }
    }

    private static void setSimplePaginationState(FullLDAPInterface conn, LDAPUtilOptions ldapOptions, SimplePagedResultsControl responseControl) {
        SimplePaginationState paginationState = ldapOptions.getPaginationState();
        if (paginationState != null) {
            if (responseControl != null && responseControl.moreResultsToReturn()) {
                paginationState.setResumeCookie(responseControl.getCookie());
                paginationState.setConnection(conn);
            } else {
                paginationState.setResumeCookie(null);
            }
        }
    }

    private List<SearchResultEntry> searchWithFilterAndVLVPagination(SearchRequest request, LDAPUtilOptions ldapOptions) throws LDAPException {
        int vlvOffset = ldapOptions.getStartIndex() <= 1 ? 1 : ldapOptions.getStartIndex();
        int vlvContentCount = 0;
        ASN1OctetString vlvContextID = null;
        int resultsPerPage = ldapOptions.getResultsPerPage() > 0 ? ldapOptions.getResultsPerPage() : maxResultSetSize;
        boolean retrieveOnce = false;
        if (ldapOptions.getResultsPerPage() > 0) {
            resultsPerPage = ldapOptions.getResultsPerPage();
            retrieveOnce = true;
        } else {
            resultsPerPage = maxResultSetSize;
        }
        --resultsPerPage;
        ArrayList<SearchResultEntry> entries = new ArrayList<SearchResultEntry>();
        List<SortKey> sortKeys = this.getSortKeys(ldapOptions);
        FullLDAPInterface conn = this.getSearchPool();
        do {
            request.setControls(new Control[]{new ServerSideSortRequestControl(sortKeys.toArray(new SortKey[sortKeys.size()])), new VirtualListViewRequestControl(vlvOffset, 0, resultsPerPage, vlvContentCount, vlvContextID)});
            this.addIntermediateClientRequestControl((UpdatableLDAPRequest)request);
            this.addAccessLogFieldRequestControl((UpdatableLDAPRequest)request);
            SearchResult searchResult = conn.search(request);
            entries.addAll(searchResult.getSearchEntries());
            VirtualListViewResponseControl vlvResponseControl = VirtualListViewResponseControl.get((SearchResult)searchResult);
            vlvContentCount = vlvResponseControl.getContentCount();
            vlvContextID = vlvResponseControl.getContextID();
        } while ((vlvOffset += resultsPerPage + 1) <= vlvContentCount && !retrieveOnce);
        return entries;
    }

    private List<SortKey> getSortKeys(LDAPUtilOptions ldapOptions) {
        ArrayList<SortKey> sortKeys = new ArrayList<SortKey>();
        if (ldapOptions.getSortBy().isEmpty()) {
            sortKeys.add(new SortKey("cn", ldapOptions.isSortReverseOrder()));
        } else {
            sortKeys.add(new SortKey(ldapOptions.getSortBy().get(0), ldapOptions.isSortReverseOrder()));
        }
        return sortKeys;
    }

    private SearchResultEntry searchEntry(String dn, String[] attrs) throws NamingException {
        EventTimer ignored = this.getEventTimer("search-entry");
        try {
            SearchResultEntry searchResultEntry = this.getEntry(dn, attrs);
            if (ignored != null) {
                ignored.close();
            }
            return searchResultEntry;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (LDAPException e) {
                throw LDAPUtil.convertLdapException(e, this.getLdapId());
            }
        }
    }

    SearchResultEntry getEntry(String dn, String[] attrs) throws LDAPException {
        SearchResult result;
        Filter filter = Filter.createPresenceFilter((String)"objectClass");
        SearchRequest searchRequest = new SearchRequest(dn, SearchScope.BASE, DereferencePolicy.NEVER, 1, 0, false, filter, attrs);
        this.addIntermediateClientRequestControl((UpdatableLDAPRequest)searchRequest);
        this.addAccessLogFieldRequestControl((UpdatableLDAPRequest)searchRequest);
        try {
            result = this.getSearchPool().search(searchRequest);
        }
        catch (LDAPException le) {
            if (le.getResultCode().equals((Object)ResultCode.NO_SUCH_OBJECT)) {
                return null;
            }
            throw le;
        }
        if (!result.getResultCode().equals((Object)ResultCode.SUCCESS)) {
            throw new LDAPException((LDAPResult)result);
        }
        List entryList = result.getSearchEntries();
        if (entryList.isEmpty()) {
            return null;
        }
        return (SearchResultEntry)entryList.get(0);
    }

    private SearchResultEntry searchEntry(String dn) throws NamingException {
        EventTimer ignored = this.getEventTimer("search-entry");
        try {
            SearchResultEntry searchResultEntry = this.getEntry(dn, new String[]{"*", "+"});
            if (ignored != null) {
                ignored.close();
            }
            return searchResultEntry;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (LDAPException e) {
                throw LDAPUtil.convertLdapException(e, this.getLdapId());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> schemaSearch(String objectClass) throws NamingException {
        if (skipSchemaRetrieval) return Collections.emptyList();
        try (EventTimer ignored = this.getEventTimer("search-schema");){
            Schema schema = this.getSearchPool().getSchema();
            if (schema == null) return Collections.emptyList();
            ObjectClassDefinition o = schema.getObjectClass(objectClass);
            if (o == null) return Collections.emptyList();
            ArrayList<String> attributes = new ArrayList<String>();
            attributes.addAll(Arrays.asList(o.getRequiredAttributes()));
            attributes.addAll(Arrays.asList(o.getOptionalAttributes()));
            ArrayList<String> arrayList = attributes;
            return arrayList;
        }
        catch (LDAPException e) {
            throw LDAPUtil.convertLdapException(e, this.getLdapId());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getLdapAttributeList() throws NamingException {
        if (skipSchemaRetrieval) return Collections.emptyList();
        try (EventTimer ignored = this.getEventTimer("fetch-attributes");){
            Schema schema = this.getSearchPool().getSchema();
            if (schema == null) return Collections.emptyList();
            ArrayList<String> classDefns = new ArrayList<String>();
            for (AttributeTypeDefinition attribDef : schema.getAttributeTypes()) {
                classDefns.add(attribDef.getNameOrOID());
            }
            ArrayList<String> arrayList = classDefns;
            return arrayList;
        }
        catch (LDAPException e) {
            throw LDAPUtil.convertLdapException(e, this.getLdapId());
        }
    }

    public static boolean validateFilter(String filter) {
        if (StringUtils.isEmpty((String)filter)) {
            log.debug((Object)"Invalid LDAP filter: 'Filter cannot be empty'");
            return false;
        }
        try {
            Filter.create((String)filter);
            return true;
        }
        catch (LDAPException e) {
            log.debug((Object)("Invalid LDAP filter: '" + filter + "': " + e.getMessage()));
            return false;
        }
    }

    public static Date convertAdTimestampToDate(String adDate) {
        Date date = null;
        if (adDate != null) {
            long adValue = Long.parseLong(adDate);
            date = new Date((adValue - 116444736000000000L) / 10000L);
        }
        return date;
    }

    public static boolean checkFilter(String filter) throws ValidationException {
        return LDAPUtil.checkFilter(filter, "Search Filter", USERNAME_ATTRIBUTE_NAME);
    }

    public static boolean checkMailFilter(String filter) throws ValidationException {
        if (StringUtils.isNotBlank((String)filter)) {
            return LDAPUtil.checkFilter(filter, "Mail Search Filter", "mail");
        }
        return true;
    }

    private static boolean checkFilter(String filter, String filterName, String substitution) throws ValidationException {
        Set refs = Substituter.parseReferences((String)filter);
        if (!refs.contains(substitution)) {
            throw new ValidationException(String.format("%s must contain ${%s} variable for substitution", filterName, substitution));
        }
        if (refs.contains(substitution) && refs.size() > 1) {
            throw new ValidationException(String.format("%s may only contain ${%s} variable for substitution", filterName, substitution));
        }
        if (!LDAPUtil.validateFilter(filter)) {
            throw new ValidationException("The LDAP search filter is invalid. Please check the filter syntax.");
        }
        return true;
    }

    public static String translateGUIDFromBinaryToString(Object o) {
        byte[] GUID = (byte[])o;
        String hex = LDAPUtil.hexEncode(GUID);
        return LDAPUtil.hexToAdString(hex);
    }

    private static String hexEncode(byte[] guidBytes) {
        StringBuilder guidHex = new StringBuilder(guidBytes.length * 2);
        for (byte guidByte : guidBytes) {
            guidHex.append(LDAPUtil.toHexString(guidByte));
        }
        return guidHex.toString();
    }

    public static String hexToAdString(String hex) {
        if (hex.length() != 32) {
            throw new IllegalArgumentException("Invalid length length of hex format, expected 32, " + hex);
        }
        StringBuilder dash = new StringBuilder(36);
        dash.append(hex.substring(6, 8));
        dash.append(hex.substring(4, 6));
        dash.append(hex.substring(2, 4));
        dash.append(hex.substring(0, 2));
        dash.append('-');
        dash.append(hex.substring(10, 12));
        dash.append(hex.substring(8, 10));
        dash.append('-');
        dash.append(hex.substring(14, 16));
        dash.append(hex.substring(12, 14));
        dash.append('-');
        dash.append(hex.substring(16, 20));
        dash.append('-');
        dash.append(hex.substring(20));
        return dash.toString();
    }

    public AttributeMap getLdapAttrsWithGuidAndSearchBase(String guid, String searchBase, String ... attrsToQuery) throws NamingException {
        SearchResultEntry resultEntry = this.searchByGuid(guid, searchBase, attrsToQuery);
        List<AttributeMap> maps = this.convertSearchResultsToAttributeMaps(Collections.singletonList(resultEntry), false);
        return maps.get(0);
    }

    private static Filter parseFilter(String filterString) throws LDAPSearchException {
        try {
            return Filter.create((String)filterString);
        }
        catch (LDAPException le) {
            Debug.debugException((Throwable)le);
            throw new LDAPSearchException(le);
        }
    }

    private SearchResultEntry searchByGuid(String guid, String searchBase, String ... attrsToQuery) throws NamingException {
        EventTimer ignored = this.getEventTimer("search-entry");
        try {
            String searchFilter = "objectGUID=" + LDAPUtil.encodeObjectGUID(guid);
            SearchRequest searchRequest = new SearchRequest(searchBase, SearchScope.SUB, DereferencePolicy.NEVER, 1, 0, false, LDAPUtil.parseFilter(searchFilter), attrsToQuery);
            SearchResultEntry result = this.getSearchPool().searchForEntry(searchRequest);
            if (result == null) {
                throw new NameNotFoundException(ResultCode.NO_SUCH_OBJECT.toString());
            }
            SearchResultEntry searchResultEntry = result;
            if (ignored != null) {
                ignored.close();
            }
            return searchResultEntry;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (LDAPException e) {
                throw LDAPUtil.convertLdapException(e, this.getLdapId());
            }
        }
    }

    public void modifyAttrsWithGuid(String guid, ModificationItem[] modificationItems) throws NamingException {
        try {
            this.modifyAttrsWithGuid(guid, this.getSearchPool().getRootDSE().getAttributeValue("namingContexts"), modificationItems);
        }
        catch (LDAPException e) {
            throw LDAPUtil.convertLdapException(e, this.getLdapId());
        }
    }

    public void modifyAttrsWithGuid(String guid, String searchBase, ModificationItem[] modificationItems) throws NamingException {
        SearchResultEntry resultEntry = this.searchByGuid(guid, searchBase, new String[0]);
        if (resultEntry != null) {
            ArrayList<Modification> modifications = new ArrayList<Modification>(modificationItems.length);
            for (ModificationItem modificationItem : modificationItems) {
                Modification modification = LDAPUtil.attributeToModification(modificationItem.getModificationOp(), modificationItem.getAttribute());
                modifications.add(modification);
            }
            ModifyRequest request = new ModifyRequest(resultEntry.getDN(), modifications);
            try (EventTimer ignored = this.getEventTimer("modify");){
                this.addIntermediateClientRequestControl((UpdatableLDAPRequest)request);
                this.addAccessLogFieldRequestControl((UpdatableLDAPRequest)request);
                this.getSearchPool().modify(request);
            }
            catch (LDAPException e) {
                throw LDAPUtil.convertLdapException(e, this.getLdapId());
            }
        }
    }

    public void enableUser(Name entryDN) throws NamingException {
        this.enableDisableUser(entryDN, UserStatus.ENABLE);
        log.debug((Object)("Enabled user " + entryDN));
    }

    public void disableUser(Name entryDN) throws NamingException {
        this.enableDisableUser(entryDN, UserStatus.DISABLE);
        log.debug((Object)("Disabled user " + entryDN));
    }

    private void enableDisableUser(Name entryDN, UserStatus status) throws NamingException {
        try (EventTimer ignored = this.getEventTimer("set-user-status");){
            SearchResultEntry resultEntry = this.getEntry(entryDN.toString(), StaticUtils.NO_STRINGS);
            if (resultEntry != null) {
                Integer uAC = resultEntry.getAttributeValueAsInteger(AD_USER_ACCOUNT_CONTROL_ATTR_NAME);
                if (uAC != null) {
                    int newUserAccountControl;
                    int userAccountControl = uAC;
                    if (userAccountControl != (newUserAccountControl = status == UserStatus.ENABLE ? userAccountControl & 0xFFFFFFFD : userAccountControl | 2)) {
                        Modification mod = new Modification(ModificationType.REPLACE, AD_USER_ACCOUNT_CONTROL_ATTR_NAME, String.valueOf(newUserAccountControl));
                        ModifyRequest modifyRequest = new ModifyRequest(resultEntry.getDN(), mod);
                        this.addIntermediateClientRequestControl((UpdatableLDAPRequest)modifyRequest);
                        this.addAccessLogFieldRequestControl((UpdatableLDAPRequest)modifyRequest);
                        this.getSearchPool().modify(modifyRequest);
                    }
                } else if (this.hasUserAccountDisabled()) {
                    String disabled = status == UserStatus.ENABLE ? "FALSE" : "TRUE";
                    Modification mod = new Modification(ModificationType.REPLACE, AD_USER_ACCOUNT_DISABLED_ATTR_NAME, disabled.getBytes(StandardCharsets.UTF_8));
                    ModifyRequest modifyRequest = new ModifyRequest(resultEntry.getDN(), mod);
                    this.addIntermediateClientRequestControl((UpdatableLDAPRequest)modifyRequest);
                    this.addAccessLogFieldRequestControl((UpdatableLDAPRequest)modifyRequest);
                    this.getSearchPool().modify(modifyRequest);
                } else {
                    log.debug((Object)("Entry: " + entryDN.toString() + ": could not enable/disable user. 'userAccountControl' or 'msDS-UserAccountDisabled' attribute was not found"));
                }
            }
        }
        catch (LDAPException e) {
            throw LDAPUtil.convertLdapException(e, this.getLdapId());
        }
    }

    private boolean hasUserAccountDisabled() throws LDAPException {
        for (AttributeTypeDefinition attrType : this.getSearchPool().getSchema().getAttributeTypes()) {
            for (int i = 0; i < attrType.getNames().length; ++i) {
                if (!attrType.getNames()[i].equalsIgnoreCase(AD_USER_ACCOUNT_DISABLED_ATTR_NAME)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isUserDisabled(Name entryDN) throws NamingException {
        try (EventTimer ignored = this.getEventTimer("check-user-status");){
            SearchResultEntry resultEntry = this.getEntry(entryDN.toString(), StaticUtils.NO_STRINGS);
            if (resultEntry == null) return false;
            Integer uAC = resultEntry.getAttributeValueAsInteger(AD_USER_ACCOUNT_CONTROL_ATTR_NAME);
            if (uAC != null) {
                int userAccountControl = uAC;
                boolean bl = (userAccountControl & 2) == 2;
                return bl;
            }
            if (!this.hasUserAccountDisabled()) throw new ProvisioningException("Entry: " + entryDN.toString() + ": could not find account control, or attribute disabled attribute");
            Boolean disabled = resultEntry.getAttributeValueAsBoolean(AD_USER_ACCOUNT_DISABLED_ATTR_NAME);
            if (disabled != null) {
                boolean bl = disabled;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (LDAPException e) {
            throw LDAPUtil.convertLdapException(e, this.getLdapId());
        }
    }

    public void deleteUser(String guid) throws NamingException {
        try {
            this.deleteUser(guid, this.getSearchPool().getRootDSE().getAttributeValue("namingContexts"));
        }
        catch (LDAPException e) {
            throw LDAPUtil.convertLdapException(e, this.getLdapId());
        }
    }

    public void deleteUser(String guid, String searchBase) throws NamingException {
        SearchResultEntry resultEntry = this.searchByGuid(guid, searchBase, new String[0]);
        if (resultEntry != null) {
            this.deleteInternal(resultEntry.getDN());
        }
    }

    public void deleteUser(Name entryDN, boolean recursive) throws NamingException {
        this.deleteInternal(entryDN.toString());
        log.debug((Object)("Entry: " + entryDN.toString() + " successfully removed from the LDAP datastore"));
    }

    public void deleteAccessGrant(Name entryDN) throws NamingException {
        this.deleteInternal(entryDN.toString());
        log.debug((Object)("Entry: " + entryDN.toString() + " successfully removed from the LDAP datastore"));
    }

    private void deleteInternal(String dn) throws NamingException {
        try (EventTimer ignored = this.getEventTimer("delete");){
            DeleteRequest deleteRequest = new DeleteRequest(dn);
            this.addIntermediateClientRequestControl((UpdatableLDAPRequest)deleteRequest);
            this.addAccessLogFieldRequestControl((UpdatableLDAPRequest)deleteRequest);
            this.getSearchPool().delete(deleteRequest);
            log.debug((Object)("Deleted user " + dn));
        }
        catch (LDAPException e) {
            throw LDAPUtil.convertLdapException(e, this.getLdapId());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getObjectClassesByType(ObjectClassType type) throws NamingException {
        if (skipSchemaRetrieval) return Collections.emptyList();
        try (EventTimer ignored = this.getEventTimer("fetch-object-class");){
            Schema schema = this.getSearchPool().getSchema();
            if (schema == null) return Collections.emptyList();
            ArrayList<String> classDefns = new ArrayList<String>();
            for (ObjectClassDefinition classDef : schema.getObjectClasses()) {
                if (classDef.getObjectClassType() == null || !type.equals((Object)classDef.getObjectClassType())) continue;
                classDefns.add(classDef.getNameOrOID());
            }
            ArrayList<String> arrayList = classDefns;
            return arrayList;
        }
        catch (LDAPException e) {
            throw LDAPUtil.convertLdapException(e, this.getLdapId());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getObjectClasses(String entryName) throws NamingException {
        if (skipSchemaRetrieval) return Collections.emptyList();
        try (EventTimer ignored = this.getEventTimer("fetch-object-class");){
            Schema schema = this.getSearchPool().getSchema(entryName);
            if (schema == null) return Collections.emptyList();
            ArrayList<String> classDefns = new ArrayList<String>();
            for (ObjectClassDefinition classDef : schema.getObjectClasses()) {
                classDefns.add(classDef.getNameOrOID());
            }
            ArrayList<String> arrayList = classDefns;
            return arrayList;
        }
        catch (LDAPException e) {
            throw LDAPUtil.convertLdapException(e, this.getLdapId());
        }
    }

    public List<String> getAllObjectClasses() throws NamingException {
        return this.getObjectClasses("");
    }

    public void authenticate(String name, String password, LdapDataSource dataSource) throws NamingException {
        this.authenticate(name, password, dataSource, false);
    }

    private void authenticate(String name, String password, LdapDataSource dataSource, boolean expectPwdExpiredControl) throws NamingException {
        try (EventTimer ignored = this.getEventTimer("bind");){
            this.checkLeadingNullChar(name);
            this.checkLeadingNullChar(password);
            LinkedList<Control> controlsList = new LinkedList<Control>();
            controlsList.add((Control)new PasswordPolicyRequestControl());
            this.addIntermediateClientRequestControl(controlsList);
            this.addAccessLogFieldRequestControl(controlsList);
            SimpleBindRequest bindRequest = new SimpleBindRequest(name, password, controlsList.toArray(new Control[controlsList.size()]));
            BindResult result = this.getBindPool().bind((BindRequest)bindRequest);
            PasswordPolicyResponseControl pwpResponse = PasswordPolicyResponseControl.get((LDAPResult)result);
            if (pwpResponse != null && PasswordPolicyErrorType.CHANGE_AFTER_RESET == pwpResponse.getErrorType()) {
                throw new LDAPException(ResultCode.UNWILLING_TO_PERFORM, "Password was reset and must be changed.");
            }
        }
        catch (LDAPException ldapException) {
            this.handleException(ldapException, name, dataSource, expectPwdExpiredControl);
        }
    }

    public LDAPRequest buildAuthenticateRequest(String name, String password) throws NamingException {
        try {
            this.checkLeadingNullChar(name);
            this.checkLeadingNullChar(password);
            LinkedList<Control> controlsList = new LinkedList<Control>();
            controlsList.add((Control)new PasswordPolicyRequestControl());
            this.addIntermediateClientRequestControl(controlsList);
            this.addAccessLogFieldRequestControl(controlsList);
            return new SimpleBindRequest(name, password, controlsList.toArray(new Control[controlsList.size()]));
        }
        catch (LDAPException ex) {
            throw LDAPUtil.convertLdapException(ex, this.getLdapId());
        }
    }

    private void addIntermediateClientRequestControl(Collection<Control> controlsList) {
        IntermediateClientRequestControl intermediateClientRequestControl = this.createIntermediateClientRequestControl();
        if (intermediateClientRequestControl != null) {
            controlsList.add((Control)intermediateClientRequestControl);
        }
    }

    public static String[] splitServerUrls(String serverUrls) {
        return ServerUrlUtils.splitServerUrls((String)serverUrls);
    }

    public static String joinServerUrls(Collection<String> serverUrls) {
        return ServerUrlUtils.joinServerUrls(serverUrls);
    }

    private void checkLeadingNullChar(String parameter) throws LDAPException {
        if (parameter != null && parameter.length() > 0 && parameter.charAt(0) == '\u0000') {
            throw new LDAPException(ResultCode.INVALID_CREDENTIALS, "Username or password has leading null byte");
        }
    }

    public static NamingException convertLdapException(LDAPException e, String dataStoreId) {
        if (dataStoreId != null) {
            DSEventTimer.incrementLdapErrors(dataStoreId);
        }
        String msg = "[LDAP: error code " + e.getResultCode().intValue() + " - " + e.getMessage() + "]";
        NamingException convertedException = e.getResultCode() == ResultCode.ENTRY_ALREADY_EXISTS ? new NameAlreadyBoundException(msg) : (ResultCode.INVALID_CREDENTIALS.equals((Object)e.getResultCode()) ? new LDAPErrorException.InvalidCredentials(msg) : new NamingException(msg));
        convertedException.setRootCause(e.getCause());
        return convertedException;
    }

    public static AttributeMap nameEncodeValues(AttributeMap incoming) {
        AttributeMap result = new AttributeMap();
        for (Map.Entry entry : incoming.entrySet()) {
            AttributeValue origValue = (AttributeValue)entry.getValue();
            if (origValue == null || origValue.getValuesAsCollection().size() > 1 || origValue.getValue() == null) {
                result.put((String)entry.getKey(), origValue);
                continue;
            }
            result.put((String)entry.getKey(), new AttributeValue(DNUtil.escapeDN((String)origValue.getValue())));
        }
        return result;
    }

    private static SearchScope getSearchScope(int searchScope) {
        if (searchScope != 0 && searchScope != 1 && searchScope != 2) {
            throw new IllegalArgumentException("Invalid search scope");
        }
        switch (searchScope) {
            case 1: {
                return SearchScope.ONE;
            }
            case 2: {
                return SearchScope.SUB;
            }
        }
        return SearchScope.BASE;
    }

    private static ModificationType getModificationType(int modificationCode) {
        if (modificationCode != 1 && modificationCode != 3 && modificationCode != 2) {
            throw new IllegalArgumentException("Invalid modification code");
        }
        switch (modificationCode) {
            case 3: {
                return ModificationType.DELETE;
            }
            case 2: {
                return ModificationType.REPLACE;
            }
        }
        return ModificationType.ADD;
    }

    public static String stripSpaces(String value) {
        return StringUtils.strip((String)value);
    }

    public static String encodeFilter(String value) {
        return Filter.encodeValue((String)value);
    }

    private static String encodeObjectGUID(String objectGUID) {
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(objectGUID, "-");
        String[] s = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            s[i] = st.nextToken();
            ++i;
        }
        sb.append("\\" + s[0].substring(6, 8));
        sb.append("\\" + s[0].substring(4, 6));
        sb.append("\\" + s[0].substring(2, 4));
        sb.append("\\" + s[0].substring(0, 2));
        sb.append("\\" + s[1].substring(2, 4));
        sb.append("\\" + s[1].substring(0, 2));
        sb.append("\\" + s[2].substring(2, 4));
        sb.append("\\" + s[2].substring(0, 2));
        sb.append("\\" + s[3].substring(0, 2));
        sb.append("\\" + s[3].substring(2, 4));
        sb.append("\\" + s[4].substring(0, 2));
        sb.append("\\" + s[4].substring(2, 4));
        sb.append("\\" + s[4].substring(4, 6));
        sb.append("\\" + s[4].substring(6, 8));
        sb.append("\\" + s[4].substring(8, 10));
        sb.append("\\" + s[4].substring(10, 12));
        return sb.toString();
    }

    public static String normalizedDN(String unnormalizedDn) throws NamingException {
        try {
            String trimmedDn = unnormalizedDn.replaceAll("^\"|\"$", "");
            return DN.normalize((String)trimmedDn);
        }
        catch (LDAPException e) {
            throw LDAPUtil.convertLdapException(e, null);
        }
    }

    public static void testConnection(ConnectionInfo connInfo) throws NamingException, SecretManagerException {
        SSLSocketFactory socketFactory = LDAPUtil.getSocketFactory(connInfo);
        LDAPUtil.testConnection(connInfo, socketFactory);
    }

    public static void testConnection(ConnectionInfo connInfo, SSLSocketFactory socketFactory) throws NamingException, SecretManagerException {
        if (StringUtils.isNotBlank((String)connInfo.getPingOneConnection())) {
            LDAPUtil.doLdapGatewayTest(connInfo);
            return;
        }
        if (connInfo.isUseStartTLS()) {
            StartTLSPostConnectProcessor postConnectProcessor = new StartTLSPostConnectProcessor(socketFactory);
            LDAPUtil.testConnection(connInfo, null, (PostConnectProcessor)postConnectProcessor);
        } else {
            LDAPUtil.testConnection(connInfo, socketFactory, null);
        }
    }

    private static void testConnection(ConnectionInfo connInfo, SSLSocketFactory socketFactory, PostConnectProcessor postConnectProcessor) throws SecretManagerException, NamingException {
        block25: {
            String serverUrl = connInfo.getServerUrl();
            String[] serverUrls = LDAPUtil.splitServerUrls(serverUrl);
            try (DSEventTimer ignored = DSEventTimer.getLdapInstance(connInfo, "test-connection", null);){
                LDAPConnectionOptions options = LDAPUtil.createConnectionOptions(connInfo);
                String authMethod = connInfo.getAuthenticationMethod();
                if (connInfo.isUseDnsSrvRecords()) {
                    ServerSet serverSet = LDAPUtil.getServerSet(connInfo, options, socketFactory, null, postConnectProcessor);
                    try (LDAPConnection conn = serverSet.getConnection();){
                        BindRequest bindRequest = LDAPUtil.getBindRequestForTestConnection(connInfo, authMethod);
                        if (bindRequest != null) {
                            conn.bind(bindRequest);
                        }
                        break block25;
                    }
                    catch (LDAPException e) {
                        throw LDAPUtil.convertLdapException(e, connInfo.getId());
                    }
                }
                LDAPConnection conn = null;
                for (int i = 0; i < serverUrls.length; ++i) {
                    try {
                        LDAPURL url = new LDAPURL(serverUrls[i]);
                        BindRequest bindRequest = LDAPUtil.getBindRequestForTestConnection(connInfo, authMethod);
                        if (postConnectProcessor == null) {
                            conn = new LDAPConnection((SocketFactory)socketFactory, options, url.getHost(), url.getPort());
                        } else {
                            SingleServerSet serverSet = new SingleServerSet(url.getHost(), url.getPort(), (SocketFactory)socketFactory, options, bindRequest, postConnectProcessor);
                            conn = serverSet.getConnection();
                        }
                        if (bindRequest == null) continue;
                        conn.bind(bindRequest);
                        continue;
                    }
                    catch (LDAPException e) {
                        log.error((Object)("Failed to connect to LDAP datastore " + connInfo.getName() + " with URL: [" + serverUrls[i] + "]"));
                        throw LDAPUtil.convertLdapException(e, connInfo.getId());
                    }
                    finally {
                        if (conn != null) {
                            conn.close();
                        }
                    }
                }
            }
        }
    }

    private static BindRequest getBindRequestForTestConnection(ConnectionInfo connInfo, String authMethod) throws SecretManagerException {
        SimpleBindRequest bindRequest = null;
        if ("simple".equals(authMethod)) {
            bindRequest = LDAPUtil.generateSimpleBindRequest(connInfo);
        } else if ("clientTlsCert".equals(authMethod) && !LdapInfo.LdapType.ActiveDirectory.equals((Object)connInfo.getLdapType())) {
            bindRequest = new EXTERNALBindRequest();
        }
        return bindRequest;
    }

    public static void logGatewayAlerts(List<PingOneGateway.Alert> alerts, String gatewayId) {
        String alertLogMessage = "Gateway '%s':  %s - %s";
        for (PingOneGateway.Alert alert : alerts) {
            if ("Info".equalsIgnoreCase(alert.getSeverity())) {
                log.info((Object)String.format(alertLogMessage, gatewayId, alert.getCategory(), alert.getDetail()));
                continue;
            }
            if ("Warning".equalsIgnoreCase(alert.getSeverity())) {
                log.warn((Object)String.format(alertLogMessage, gatewayId, alert.getCategory(), alert.getDetail()));
                continue;
            }
            if (!"Error".equalsIgnoreCase(alert.getSeverity())) continue;
            log.error((Object)String.format(alertLogMessage, gatewayId, alert.getCategory(), alert.getDetail()));
        }
    }

    private static SimpleBindRequest generateSimpleBindRequest(ConnectionInfo connectionInfo) throws SecretManagerException {
        String bindDN = connectionInfo.getPrincipal();
        String password = connectionInfo.getCredentials();
        if (SecretReferenceUtil.isSecretReference((String)password)) {
            SecretReferenceHelper secretReferenceHelper = new SecretReferenceHelper(password);
            SecretReferenceHelper.Credentials credentials = secretReferenceHelper.getSecretInfo(bindDN);
            return new SimpleBindRequest(credentials.getUsername(), credentials.getSecret());
        }
        return new SimpleBindRequest(bindDN, password);
    }

    public static void doAdminAuditLogging(String hosts) {
        AdminAuditLogger.log(AdminAuditLogger.Component.DATA_STORE, AdminAuditLogger.Event.TEST_CONNECTION, "Test connection to LDAP server: " + hosts);
    }

    private static LDAPConnectionOptions createConnectionOptions(ConnectionInfo connInfo) {
        int connTimeout = connInfo.getConnTimeoutMillis() > 0 ? connInfo.getConnTimeoutMillis() : 0;
        int readTimeout = connInfo.getReadTimeoutMillis() > 0 ? connInfo.getReadTimeoutMillis() : 0;
        LDAPConnectionOptions connectionOptions = new LDAPConnectionOptions();
        connectionOptions.setConnectTimeoutMillis(connTimeout);
        connectionOptions.setResponseTimeoutMillis((long)readTimeout);
        connectionOptions.setUsePooledSchema(cacheSchema);
        connectionOptions.setFollowReferrals(connInfo.getUseLdapReferral());
        connectionOptions.setPooledSchemaTimeoutMillis(cacheSchemaTimeoutMillis);
        if (connInfo.isVerifyHost()) {
            HostNameSSLSocketVerifier sslSocketVerifier = new HostNameSSLSocketVerifier(true);
            connectionOptions.setSSLSocketVerifier((SSLSocketVerifier)sslSocketVerifier);
        }
        return connectionOptions;
    }

    public static String convertBinarySidToString(byte[] sid) {
        if (sid.length < 8) {
            throw new IllegalArgumentException("Binary SID representation must have at least 8 bytes but passed byte array has only " + sid.length + " bytes.");
        }
        int numberOfSubAuthorityParts = sid[1] & 0xFF;
        if (sid.length != 8 + numberOfSubAuthorityParts * 4) {
            throw new IllegalArgumentException("According to byte 1 of the SID it total length should be " + (8 + 4 * numberOfSubAuthorityParts) + " bytes, however its actual length is " + sid.length + " bytes.");
        }
        StringBuffer sidAsString = new StringBuffer("S-");
        sidAsString.append(sid[0]).append('-');
        StringBuffer sb = new StringBuffer();
        for (int t = 2; t <= 7; ++t) {
            String hexString = Integer.toHexString(sid[t] & 0xFF);
            sb.append(hexString);
        }
        sidAsString.append(Long.parseLong(sb.toString(), 16));
        int count = sid[1];
        for (int i = 0; i < count; ++i) {
            int currSubAuthOffset = i * 4;
            sb.setLength(0);
            sb.append(LDAPUtil.toHexString((byte)(sid[11 + currSubAuthOffset] & 0xFF)));
            sb.append(LDAPUtil.toHexString((byte)(sid[10 + currSubAuthOffset] & 0xFF)));
            sb.append(LDAPUtil.toHexString((byte)(sid[9 + currSubAuthOffset] & 0xFF)));
            sb.append(LDAPUtil.toHexString((byte)(sid[8 + currSubAuthOffset] & 0xFF)));
            sidAsString.append('-').append(Long.parseLong(sb.toString(), 16));
        }
        return sidAsString.toString();
    }

    private static String toHexString(byte b) {
        Object hexString = Integer.toHexString(b & 0xFF);
        if (((String)hexString).length() % 2 != 0) {
            hexString = "0" + (String)hexString;
        }
        return hexString;
    }

    @Deprecated
    public List<String> getDistinguishedName(String searchBase, String filter, int searchScope, String[] attrs, int countLimit) throws NamingException {
        LDAPUtilOptions ldapOptions = new LDAPUtilOptions(searchBase, filter, searchScope);
        ldapOptions.setAttributes(attrs);
        ldapOptions.setCount(countLimit);
        return this.getDistinguishedName(ldapOptions);
    }

    @Deprecated
    public List<AttributeMap> getAttributesOfMatchingObjects(String searchBase, String filter, int searchScope) throws NamingException {
        LDAPUtilOptions ldapOptions = new LDAPUtilOptions(searchBase, filter, searchScope);
        return this.getAttributesOfMatchingObjects(ldapOptions);
    }

    @Deprecated
    public List<AttributeMap> getAttributesOfMatchingObjects(String searchBase, String filter, int searchScope, String[] attrs) throws NamingException {
        LDAPUtilOptions ldapOptions = new LDAPUtilOptions(searchBase, filter, searchScope);
        ldapOptions.setAttributes(attrs);
        return this.getAttributesOfMatchingObjects(ldapOptions);
    }

    @Deprecated
    public List<AttributeMap> getAttributesOfMatchingObjects(String searchBase, String filter, int searchScope, int countLimit) throws NamingException {
        LDAPUtilOptions ldapOptions = new LDAPUtilOptions(searchBase, filter, searchScope);
        ldapOptions.setCount(countLimit);
        return this.getAttributesOfMatchingObjects(ldapOptions);
    }

    @Deprecated
    public List<AttributeMap> getAttributesOfMatchingObjects(String searchBase, String filter, int searchScope, String[] attrs, int countLimit) throws NamingException {
        LDAPUtilOptions ldapOptions = new LDAPUtilOptions(searchBase, filter, searchScope);
        ldapOptions.setAttributes(attrs);
        ldapOptions.setCount(countLimit);
        return this.getAttributesOfMatchingObjects(ldapOptions);
    }

    @Deprecated
    public AttributeMap getAttributesOfMatchingObject(String searchBase, String filter, int searchScope, String[] attrs) throws NamingException {
        LDAPUtilOptions ldapOptions = new LDAPUtilOptions(searchBase, filter, searchScope);
        ldapOptions.setAttributes(attrs);
        return this.getAttributesOfMatchingObject(ldapOptions);
    }

    public void resetPassword(String entryDn, String newPassword, String pwdAttribute, LdapDataSource dataSource, boolean enablePingDirectoryDetailedPwdReq) throws NamingException, LDAPPasswordPolicyViolationException {
        if (LDAPUtil.isPasswordChangeable(dataSource)) {
            boolean resetWithoutProxy = false;
            try (EventTimer ignored = this.getEventTimer("reset-password");){
                if (this.getExtendedOperationsOIDs().contains("1.3.6.1.4.1.30221.1.6.1")) {
                    boolean isDisabled;
                    LinkedList<Control> controlsList = new LinkedList<Control>();
                    this.addIntermediateClientRequestControl(controlsList);
                    this.addAccessLogFieldRequestControl(controlsList);
                    PasswordPolicyStateOperation disableOp = PasswordPolicyStateOperation.createGetAccountDisabledStateOperation();
                    PasswordPolicyStateExtendedRequest pwpStateRequest = new PasswordPolicyStateExtendedRequest(entryDn, controlsList.toArray(new Control[controlsList.size()]), new PasswordPolicyStateOperation[]{disableOp});
                    PasswordPolicyStateExtendedResult pwpStateResult = (PasswordPolicyStateExtendedResult)this.getSearchPool().processExtendedOperation((ExtendedRequest)pwpStateRequest);
                    if (pwpStateResult.getResultCode() == ResultCode.SUCCESS && (isDisabled = pwpStateResult.getBooleanValue(1))) {
                        throw new NamingException("Can't reset the password for a disabled account");
                    }
                    PasswordPolicyStateOperation expiredOp = PasswordPolicyStateOperation.createGetPasswordIsExpiredOperation();
                    PasswordPolicyStateOperation idleLockedOp = PasswordPolicyStateOperation.createGetAccountIsIdleLockedOperation();
                    pwpStateRequest = new PasswordPolicyStateExtendedRequest(entryDn, controlsList.toArray(new Control[controlsList.size()]), new PasswordPolicyStateOperation[]{expiredOp, idleLockedOp});
                    pwpStateResult = (PasswordPolicyStateExtendedResult)this.getSearchPool().processExtendedOperation((ExtendedRequest)pwpStateRequest);
                    if (pwpStateResult.getResultCode() == ResultCode.SUCCESS) {
                        boolean isIdleLocked;
                        boolean isExpired = pwpStateResult.getBooleanValue(67);
                        if (isExpired && (dataSource.isPingDirectoryOrPingDSType() || dataSource.isSunOneType())) {
                            resetWithoutProxy = true;
                        }
                        if ((isIdleLocked = pwpStateResult.getBooleanValue(62)) && dataSource.isPingDirectoryOrPingDSType()) {
                            resetWithoutProxy = true;
                        }
                    }
                }
                if (dataSource.isOracleUnifiedDirectoryType() && this.getExtendedOperationsOIDs().contains("1.3.6.1.4.1.26027.1.6.1")) {
                    boolean isDisabled;
                    PasswordPolicyStateOperation disableOp = PasswordPolicyStateOperation.createGetAccountDisabledStateOperation();
                    PasswordPolicyStateExtendedRequest pwpStateRequest = new PasswordPolicyStateExtendedRequest((ExtendedRequest)new OUDPasswordPolicyStateExtendedOperation(entryDn, disableOp));
                    PasswordPolicyStateExtendedResult pwpStateResult = (PasswordPolicyStateExtendedResult)this.getSearchPool().processExtendedOperation((ExtendedRequest)pwpStateRequest);
                    if (pwpStateResult.getResultCode() == ResultCode.SUCCESS && (isDisabled = pwpStateResult.getBooleanValue(1))) {
                        throw new NamingException("Can't reset the password for a disabled account");
                    }
                    PasswordPolicyStateOperation expiredOp = PasswordPolicyStateOperation.createGetSecondsUntilPasswordExpirationOperation();
                    pwpStateRequest = new PasswordPolicyStateExtendedRequest((ExtendedRequest)new OUDPasswordPolicyStateExtendedOperation(entryDn, expiredOp));
                    pwpStateResult = (PasswordPolicyStateExtendedResult)this.getSearchPool().processExtendedOperation((ExtendedRequest)pwpStateRequest);
                    if (pwpStateResult.getResultCode() == ResultCode.SUCCESS) {
                        try {
                            int OP_TYPE_GET_SECONDS_UNTIL_PW_EXPIRATION = pwpStateResult.getIntValue(14);
                            if (OP_TYPE_GET_SECONDS_UNTIL_PW_EXPIRATION == 0) {
                                resetWithoutProxy = true;
                            }
                        }
                        catch (IllegalStateException | NumberFormatException runtimeException) {
                            // empty catch block
                        }
                    }
                }
                if (dataSource.isActiveDirectoryType()) {
                    boolean isDisabled = false;
                    try {
                        isDisabled = this.isUserDisabled(new LdapName(entryDn));
                    }
                    catch (NamingException | ProvisioningException e) {
                        log.warn((Object)e.getMessage());
                    }
                    if (isDisabled) {
                        throw new NamingException("Can't reset the password for a disabled account");
                    }
                }
                if (this.getSupportedControlsOIDs().contains("2.16.840.1.113730.3.4.18") && !resetWithoutProxy) {
                    ProxiedAuthorizationV2RequestControl control = new ProxiedAuthorizationV2RequestControl("dn:" + entryDn);
                    this.resetPasswordProxyAuth(entryDn, newPassword, pwdAttribute, (Control)control, enablePingDirectoryDetailedPwdReq);
                }
                if (this.getSupportedControlsOIDs().contains("2.16.840.1.113730.3.4.12") && !resetWithoutProxy) {
                    ProxiedAuthorizationV1RequestControl control = new ProxiedAuthorizationV1RequestControl("dn:" + entryDn);
                    this.resetPasswordProxyAuth(entryDn, newPassword, pwdAttribute, (Control)control, enablePingDirectoryDetailedPwdReq);
                }
                this.resetPasswordWithoutProxy(entryDn, newPassword, pwdAttribute, dataSource, resetWithoutProxy, enablePingDirectoryDetailedPwdReq);
            }
            catch (LDAPException e) {
                ResultCode resultCode = e.getResultCode();
                String errorMessageFromServer = e.getDiagnosticMessage();
                if (dataSource.isSunOneType() && ResultCode.UNWILLING_TO_PERFORM == resultCode && errorMessageFromServer.contains("password expired")) {
                    try {
                        this.resetPasswordWithoutProxy(entryDn, newPassword, pwdAttribute, dataSource, true, enablePingDirectoryDetailedPwdReq);
                    }
                    catch (LDAPException e1) {
                        throw LDAPUtil.convertLdapException(e1, this.getLdapId());
                    }
                }
                throw LDAPUtil.convertLdapException(e, this.getLdapId());
            }
            catch (LDAPPasswordPolicyViolationException e) {
                if (dataSource.isPingDirectoryOrPingDSType() && !resetWithoutProxy) {
                    List<LDAPPasswordQualityRequirement> revisedPwdPolicyReqMetList = e.getPasswordPolicyReqMet().stream().filter(pwdQualityReq -> !(pwdQualityReq instanceof SimilarityPasswordValidator)).collect(Collectors.toList());
                    throw new LDAPPasswordPolicyViolationException(e.getMessage(), revisedPwdPolicyReqMetList, e.getPasswordPolicyReqNotMet());
                }
                throw e;
            }
        } else {
            throw new IllegalStateException("Password changes are not allowed on this LDAP data source. Prevent this exception by calling isPasswordChangeable() before calling resetPassword().");
        }
    }

    private void resetPasswordWithoutProxy(String entryDn, String newPassword, String pwdAttribute, LdapDataSource dataSource, boolean isPasswordExpired, boolean enablePingDirectoryDetailedPwdReq) throws LDAPException, NamingException, LDAPPasswordPolicyViolationException {
        if (this.getExtendedOperationsOIDs().contains("1.3.6.1.4.1.4203.1.11.1") && !dataSource.isSunOneType()) {
            this.resetPasswordExtended(entryDn, null, newPassword, isPasswordExpired, enablePingDirectoryDetailedPwdReq);
        } else {
            this.resetPasswordField(entryDn, newPassword, pwdAttribute, dataSource, enablePingDirectoryDetailedPwdReq);
        }
    }

    private void resetPasswordProxyAuth(String entryDn, String newPassword, String pwdAttribute, Control control, boolean enablePingDirectoryDetailedPwdReq) throws LDAPException, LDAPPasswordPolicyViolationException {
        LinkedList<Control> controls = new LinkedList<Control>();
        boolean getPwdReqMessagingForPingDirectory = enablePingDirectoryDetailedPwdReq ? this.addPasswordValidationDetailsRequestControl(controls) : false;
        controls.add(control);
        ModifyRequest modifyRequest = this.getModifyRequestForReplacePwd(entryDn, newPassword, pwdAttribute, controls);
        try {
            this.getSearchPool().modify(modifyRequest);
        }
        catch (LDAPException e) {
            this.processPasswordValidationResults(getPwdReqMessagingForPingDirectory, e.toLDAPResult());
            if (this.isInsufficientRightsForPasswordValidationDetailsRequest(e.getResultCode(), e.getDiagnosticMessage())) {
                log.error((Object)("Reset password with proxy auth and password validation details request control [LDAP: error code " + e.getResultCode().intValue() + " - " + e.getDiagnosticMessage() + "]"));
                log.debug((Object)"Redoing reset password without password validation details request control.");
                this.resetPasswordProxyAuth(entryDn, newPassword, pwdAttribute, control, false);
            }
            throw e;
        }
    }

    private boolean isInsufficientRightsForPasswordValidationDetailsRequest(ResultCode resultCode, String diagnosticMsg) {
        return ResultCode.INSUFFICIENT_ACCESS_RIGHTS.equals((Object)resultCode) && diagnosticMsg != null && diagnosticMsg.contains("1.3.6.1.4.1.30221.2.5.40");
    }

    private void processPasswordValidationResults(boolean getPwdReqMessagingForPingDirectory, LDAPResult ldapResult) throws LDAPPasswordPolicyViolationException {
        if (ldapResult != null && ResultCode.SUCCESS != ldapResult.getResultCode() && getPwdReqMessagingForPingDirectory) {
            LDAPUtil.getPasswordPolicyValidationDetails(ldapResult);
        }
    }

    private ModifyRequest getModifyRequestForReplacePwd(String entryDn, String newPassword, String pwdAttribute, List<Control> controls) {
        ArrayList<Modification> mods = new ArrayList<Modification>();
        mods.add(new Modification(ModificationType.REPLACE, pwdAttribute, newPassword));
        return new ModifyRequest(entryDn, mods, controls.toArray(new Control[controls.size()]));
    }

    private boolean addPasswordValidationDetailsRequestControl(List<Control> controls) {
        boolean supportsPasswordValidationDetailsRequestControl = this.getSupportedControlsOIDs().contains("1.3.6.1.4.1.30221.2.5.40");
        if (supportsPasswordValidationDetailsRequestControl) {
            controls.add((Control)new PasswordValidationDetailsRequestControl(false));
        }
        return supportsPasswordValidationDetailsRequestControl;
    }

    private void resetPasswordExtended(String entryDn, String currentPassword, String newPassword, boolean isExpired, boolean enablePingDirectoryDetailedPwdReq) throws NamingException, LDAPPasswordPolicyViolationException {
        block7: {
            try {
                boolean isReset = StringUtils.isBlank((String)currentPassword);
                boolean supportsPasswordUpdateBehaviorRequestControl = isReset && this.getSupportedControlsOIDs().contains("1.3.6.1.4.1.30221.2.5.51");
                boolean supportsPasswordPolicyExtendedRequest = this.getExtendedOperationsOIDs().contains("1.3.6.1.4.1.30221.1.6.1");
                LinkedList<Object> controls = new LinkedList<Control>();
                this.addIntermediateClientRequestControl(controls);
                this.addAccessLogFieldRequestControl(controls);
                if (!isExpired && supportsPasswordUpdateBehaviorRequestControl) {
                    controls.add((Control)new PasswordUpdateBehaviorRequestControl(LDAPPasswordPolicyProperties.getPasswordUpdateBehaviorRequestControlProperties(), false));
                }
                boolean getPwdReqMessagingForPingDirectory = enablePingDirectoryDetailedPwdReq ? this.addPasswordValidationDetailsRequestControl(controls) : false;
                PasswordModifyExtendedRequest passwordModifyRequest = new PasswordModifyExtendedRequest(entryDn, currentPassword, newPassword, controls.toArray(new Control[controls.size()]));
                ExtendedResult passwordModifyResult = this.getSearchPool().processExtendedOperation((ExtendedRequest)passwordModifyRequest);
                if (ResultCode.SUCCESS == passwordModifyResult.getResultCode()) {
                    if (isReset && (isExpired || !supportsPasswordUpdateBehaviorRequestControl) && supportsPasswordPolicyExtendedRequest) {
                        controls = new LinkedList();
                        this.addIntermediateClientRequestControl(controls);
                        this.addAccessLogFieldRequestControl(controls);
                        PasswordPolicyStateOperation changeUponReset = PasswordPolicyStateOperation.createSetPasswordResetStateOperation((boolean)false);
                        PasswordPolicyStateExtendedRequest passwordStateRequest = new PasswordPolicyStateExtendedRequest(entryDn, controls.toArray(new Control[controls.size()]), new PasswordPolicyStateOperation[]{changeUponReset});
                        ExtendedResult changeOnResetResult = this.getSearchPool().processExtendedOperation((ExtendedRequest)passwordStateRequest);
                        if (ResultCode.SUCCESS != changeOnResetResult.getResultCode()) {
                            throw LDAPUtil.convertExtendedResult((LDAPResult)changeOnResetResult);
                        }
                    }
                    break block7;
                }
                this.processPasswordValidationResults(getPwdReqMessagingForPingDirectory, (LDAPResult)passwordModifyResult);
                if (this.isInsufficientRightsForPasswordValidationDetailsRequest(passwordModifyResult.getResultCode(), passwordModifyResult.getDiagnosticMessage())) {
                    log.error((Object)("Reset password using password modify extended operation with password validation details request control [LDAP: error code " + passwordModifyResult.getResultCode().intValue() + " - " + passwordModifyResult.getDiagnosticMessage() + "]"));
                    log.debug((Object)"Redoing reset password without password validation details request control.");
                    this.resetPasswordExtended(entryDn, currentPassword, newPassword, isExpired, false);
                    break block7;
                }
                throw LDAPUtil.convertExtendedResult((LDAPResult)passwordModifyResult);
            }
            catch (LDAPException e) {
                throw LDAPUtil.convertLdapException(e, this.getLdapId());
            }
        }
    }

    private void resetPasswordField(String entryDn, String newPassword, String pwdAttribute, LdapDataSource dataSource, boolean enablePingDirectoryDetailedPwdReq) throws NamingException, LDAPPasswordPolicyViolationException, LDAPException {
        ArrayList<Modification> mods = new ArrayList<Modification>();
        LinkedList<Control> controls = new LinkedList<Control>();
        boolean getPwdReqMessagingForPingDirectory = enablePingDirectoryDetailedPwdReq ? this.addPasswordValidationDetailsRequestControl(controls) : false;
        try {
            if (dataSource.isActiveDirectoryType()) {
                mods.add(new Modification(ModificationType.REPLACE, pwdAttribute, LDAPUtil.encodePassword(newPassword)));
                PolicyHintsControl policyHintControl = this.getPolicyHintsControl();
                controls.add(policyHintControl);
            } else {
                mods.add(new Modification(ModificationType.REPLACE, pwdAttribute, newPassword));
            }
            this.addIntermediateClientRequestControl(controls);
            this.addAccessLogFieldRequestControl(controls);
            ModifyRequest modifyRequest = new ModifyRequest(entryDn, mods, controls.toArray(new Control[controls.size()]));
            this.getSearchPool().modify(modifyRequest);
        }
        catch (LDAPException e) {
            this.processPasswordValidationResults(getPwdReqMessagingForPingDirectory, e.toLDAPResult());
            if (this.isInsufficientRightsForPasswordValidationDetailsRequest(e.getResultCode(), e.getDiagnosticMessage())) {
                log.error((Object)("Reset password without proxy auth using modify request and password validation details request control [LDAP: error code " + e.getResultCode().intValue() + " - " + e.getDiagnosticMessage() + "]"));
                log.debug((Object)"Redoing reset password without password validation details request control.");
                this.resetPasswordField(entryDn, newPassword, pwdAttribute, dataSource, false);
            }
            throw e;
        }
        catch (UnsupportedEncodingException e) {
            NamingException ne = new NamingException("Error encoding password");
            ne.initCause(e);
            throw ne;
        }
    }

    private PolicyHintsControl getPolicyHintsControl() throws LDAPException {
        if (this.getSupportedControlsOIDs().contains("1.2.840.113556.1.4.2239")) {
            return new PolicyHintsControl();
        }
        if (this.getSupportedControlsOIDs().contains("1.2.840.113556.1.4.2066")) {
            return new PolicyHintsControl(true);
        }
        log.warn((Object)"The reset password enforce history capability is not supported, because the data source  uses Active Directory and is not configured with the POLICY_HINTS OID.");
        return null;
    }

    static NamingException convertExtendedResult(LDAPResult result) {
        String msg = "[ExtendedResult: error code " + result.getResultCode().intValue() + " - " + result.getDiagnosticMessage() + "]";
        return new NamingException(msg);
    }

    private static void getPasswordPolicyValidationDetails(LDAPResult result) throws LDAPPasswordPolicyViolationException {
        LinkedList<LDAPPasswordQualityRequirement> passwordPolicyReqMet = new LinkedList<LDAPPasswordQualityRequirement>();
        LinkedList<LDAPPasswordQualityRequirement> passwordPolicyReqNotMet = new LinkedList<LDAPPasswordQualityRequirement>();
        if (result != null) {
            try {
                PasswordValidationDetailsResponseControl passwordValidationDetailsResponseControl = PasswordValidationDetailsResponseControl.get((LDAPResult)result);
                LDAPUtil.populatePwdPolicyViolationFromPwdValidationDetailsResponse(passwordPolicyReqMet, passwordPolicyReqNotMet, passwordValidationDetailsResponseControl);
                if (CollectionUtils.isNotEmpty(passwordPolicyReqNotMet)) {
                    throw new LDAPPasswordPolicyViolationException("[ExtendedResult: error code " + result.getResultCode().intValue() + " - " + result.getDiagnosticMessage() + "]", passwordPolicyReqMet, passwordPolicyReqNotMet);
                }
            }
            catch (LDAPException e) {
                log.error((Object)"Problem was encountered while attempting to decode the password validation details response control contained in the provided LDAP result.", (Throwable)e);
            }
        }
    }

    private static void populatePwdPolicyViolationFromPwdValidationDetailsResponse(List<LDAPPasswordQualityRequirement> passwordPolicyReqMet, List<LDAPPasswordQualityRequirement> passwordPolicyReqNotMet, PasswordValidationDetailsResponseControl passwordValidationDetailsResponseControl) {
        if (passwordValidationDetailsResponseControl != null) {
            log.debug((Object)"Get password policy from LDAP password validation details response");
            for (PasswordQualityRequirementValidationResult pwdQualityReqValidationResult : passwordValidationDetailsResponseControl.getValidationResults()) {
                boolean isSatisfied = pwdQualityReqValidationResult.requirementSatisfied();
                Optional<PasswordQualityRequirement> optionalPwdQualityReq = Optional.of(pwdQualityReqValidationResult).map(PasswordQualityRequirementValidationResult::getPasswordRequirement);
                String passwordValidationType = optionalPwdQualityReq.map(PasswordQualityRequirement::getClientSideValidationType).orElse("");
                Map validationPropMap = optionalPwdQualityReq.map(PasswordQualityRequirement::getClientSideValidationProperties).orElse(new HashMap());
                List<LDAPPasswordQualityRequirement> listToPopulate = isSatisfied ? passwordPolicyReqMet : passwordPolicyReqNotMet;
                try {
                    switch (passwordValidationType) {
                        case "length": {
                            log.debug((Object)("Length password validator: " + isSatisfied));
                            listToPopulate.add(new LengthPasswordValidator(validationPropMap, isSatisfied));
                            break;
                        }
                        case "character-set": {
                            log.debug((Object)("Character set validator: " + isSatisfied));
                            listToPopulate.add(new CharacterSetPasswordValidator(validationPropMap, isSatisfied));
                            break;
                        }
                        case "attribute-value": {
                            log.debug((Object)("Attribute value validator: " + isSatisfied));
                            listToPopulate.add(new AttributeValuePasswordValidator(validationPropMap, isSatisfied));
                            break;
                        }
                        case "dictionary": {
                            log.debug((Object)("Dictionary validator: " + isSatisfied));
                            listToPopulate.add(new DictionaryPasswordValidator(validationPropMap, isSatisfied));
                            break;
                        }
                        case "haystack": {
                            log.debug((Object)("Haystack validator: " + isSatisfied));
                            listToPopulate.add(new HaystackPasswordValidator(validationPropMap, isSatisfied));
                            break;
                        }
                        case "regular-expression": {
                            log.debug((Object)("Regular expression validator: " + isSatisfied));
                            listToPopulate.add(new RegularExpressionPasswordValidator(validationPropMap, isSatisfied));
                            break;
                        }
                        case "repeated-characters": {
                            log.debug((Object)("Repeated characters validator: " + isSatisfied));
                            listToPopulate.add(new RepeatedCharactersPasswordValidator(validationPropMap, isSatisfied));
                            break;
                        }
                        case "similarity": {
                            log.debug((Object)("Similarity validator: " + isSatisfied));
                            listToPopulate.add(new SimilarityPasswordValidator(validationPropMap, isSatisfied));
                            break;
                        }
                        case "unique-characters": {
                            log.debug((Object)("Unique characters validator: " + isSatisfied));
                            listToPopulate.add(new UniqueCharactersPasswordValidator(validationPropMap, isSatisfied));
                            break;
                        }
                        case "not-current-password": {
                            log.debug((Object)("Not current password validator: " + isSatisfied));
                            listToPopulate.add(new NotCurrentPasswordValidator(validationPropMap, isSatisfied));
                            break;
                        }
                        default: {
                            listToPopulate.add(new LDAPPasswordQualityRequirement(passwordValidationType, validationPropMap, isSatisfied));
                            log.warn((Object)("Password validation type of " + passwordValidationType + " not supported.\nValidator description: " + optionalPwdQualityReq.map(PasswordQualityRequirement::getDescription).orElse("") + "\nPlease ensure message with key " + LDAPPasswordQualityRequirement.getRootMsgKeyPrefix(passwordValidationType) + " is present in the localization message file."));
                            break;
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)("Invalid password policy violation attributes provided.\nPolicy Description: " + optionalPwdQualityReq.map(PasswordQualityRequirement::getDescription).orElse("")), (Throwable)e);
                }
            }
        } else {
            log.debug((Object)"Cannot access password validation details from LDAP response. This may be due to insufficient privileges or the LDAP server does not support this control.");
        }
    }

    public boolean unlockAccount(String subjectDn, LdapDataSource dataSource) throws NamingException {
        boolean accountUnlocked = false;
        try (EventTimer ignored = this.getEventTimer("unlock-account");){
            SearchResultEntry resultEntry = this.getEntry(subjectDn, StaticUtils.NO_STRINGS);
            if (resultEntry != null) {
                if (dataSource.isActiveDirectoryType()) {
                    accountUnlocked = this.unlockActiveDirAccount(resultEntry);
                } else if (dataSource.isPingDirectoryOrPingDSType()) {
                    accountUnlocked = this.unlockPingDirectoryAccount(subjectDn);
                }
            } else {
                log.debug((Object)("Entry: " + subjectDn + ": could not unlock as the user attribute was not found."));
            }
        }
        catch (LDAPException e) {
            throw LDAPUtil.convertLdapException(e, this.getLdapId());
        }
        catch (UnsupportedEncodingException e) {
            throw new NamingException(e.getMessage());
        }
        return accountUnlocked;
    }

    private boolean unlockActiveDirAccount(SearchResultEntry resultEntry) throws LDAPException, UnsupportedEncodingException {
        Modification mod = new Modification(ModificationType.REPLACE, "lockoutTime", "0".getBytes(StandardCharsets.UTF_8));
        ModifyRequest modifyRequest = new ModifyRequest(resultEntry.getDN(), mod);
        this.getSearchPool().modify(modifyRequest);
        return true;
    }

    private boolean unlockUnboundIdAccount(String subjectDn) throws LDAPException {
        return this.unlockPingDirectoryAccount(subjectDn);
    }

    private boolean unlockPingDirectoryAccount(String subjectDn) throws LDAPException {
        PasswordPolicyStateOperation accountEnableState = PasswordPolicyStateOperation.createClearAuthenticationFailureTimesOperation();
        LinkedList<Control> controlsList = new LinkedList<Control>();
        controlsList.add((Control)new PasswordPolicyRequestControl());
        this.addIntermediateClientRequestControl(controlsList);
        this.addAccessLogFieldRequestControl(controlsList);
        PasswordPolicyStateExtendedRequest pwpStateRequest = new PasswordPolicyStateExtendedRequest(subjectDn, controlsList.toArray(new Control[controlsList.size()]), new PasswordPolicyStateOperation[]{accountEnableState});
        PasswordPolicyStateExtendedResult pwpStateResult = (PasswordPolicyStateExtendedResult)this.getSearchPool().processExtendedOperation((ExtendedRequest)pwpStateRequest);
        return pwpStateResult.getResultCode() == ResultCode.SUCCESS;
    }

    private static void doLdapGatewayTest(ConnectionInfo connInfo) throws NamingException {
        PingOneConnectionsManager connectionsMgr = MgmtFactory.getPingOneConnectionsManager();
        String credential = connectionsMgr.getConnection(connInfo.getPingOneConnection()).getCredential();
        UUID envID = UUID.fromString(connInfo.getPingOneEnvironment());
        UUID gatewayID = UUID.fromString(connInfo.getPingOneGateway());
        try (DSEventTimer ignored = DSEventTimer.getLdapInstance(connInfo, "test-connection", null);){
            PingOneTunneledLDAPInterface ldapInterface = new PingOneTunneledLDAPInterface((HttpClient)HttpConnectionPoolingManager.getInstance().getDefaultClient(), credential, envID, gatewayID);
            ldapInterface.getRootDSE();
        }
        catch (LDAPException e) {
            throw LDAPUtil.convertLdapException(e, connInfo.getId());
        }
        catch (InvalidCredentialException e) {
            log.error((Object)e);
        }
    }

    public DirectLdapSearchesThenOpResponse searchesThenOp(DirectLdapSearchesThenOpRequest combinedRequests) throws NamingException {
        SearchRequest[] searchRequests = combinedRequests.getSearchRequests();
        if (searchRequests == null || searchRequests.length == 0) {
            throw new IllegalArgumentException("DirectLdapSearchesThenOpRequest missing search requests");
        }
        if (searchRequests.length > 1) {
            throw new IllegalArgumentException("Only one search request is currently supported");
        }
        if (combinedRequests.getPostSearchRequest() == null) {
            throw new IllegalArgumentException("DirectLdapSearchesThenOpRequest missing post-search request");
        }
        if (!(combinedRequests.getPostSearchRequest() instanceof BindRequest)) {
            throw new IllegalArgumentException("Only BindRequest is currently supported for post-search request");
        }
        if (this.isGatewayEnabled) {
            EventTimer ignored = this.getEventTimer("searches-then-op");
            try {
                DirectLdapSearchesThenOpResponse directLdapSearchesThenOpResponse = ((PingOneTunneledLDAPInterface)this.getSearchPool()).searchesThenOp(combinedRequests);
                if (ignored != null) {
                    ignored.close();
                }
                return directLdapSearchesThenOpResponse;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidCredentialException | IOException e) {
                    DSEventTimer.incrementLdapErrors(this.getLdapId());
                    log.error((Object)"Error connecting to PingOne gateway", e);
                    throw new LDAPErrorException.ConnectionFailedException("Error connecting to PingOne gateway", e);
                }
            }
        }
        DirectLdapSearchesThenOpResponse response = new DirectLdapSearchesThenOpResponse();
        Entry matchedEntry = null;
        try (EventTimer ignored = this.getEventTimer("search");){
            SearchResult searchResult = this.getSearchPool().search(searchRequests[0]);
            response.setSearchResults(new SearchResult[]{searchResult});
            if (searchResult.getResultCode() == ResultCode.SUCCESS) {
                if (searchResult.getEntryCount() > 1) {
                    throw new LDAPException(ResultCode.SIZE_LIMIT_EXCEEDED, "Search returned more than one entry");
                }
                if (searchResult.getEntryCount() == 1) {
                    matchedEntry = (Entry)searchResult.getSearchEntries().get(0);
                }
            }
        }
        catch (LDAPException e) {
            DSEventTimer.incrementLdapErrors(this.getLdapId());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received LDAPException from search in DirectLdapSearchesThenOpRequest: " + e));
            }
            response.setSearchResults(new SearchResult[]{new SearchResult(e)});
        }
        if (matchedEntry != null) {
            try {
                LDAPRequest postSearchRequest = this.setTargetDn(combinedRequests.getPostSearchRequest(), matchedEntry.getDN());
                try (EventTimer ignored = this.getEventTimer("bind");){
                    BindResult bindResult = this.getBindPool().bind((BindRequest)postSearchRequest);
                    response.setPostSearchResult((LDAPResult)bindResult);
                }
            }
            catch (LDAPException e) {
                if (e.getResultCode() != ResultCode.INVALID_CREDENTIALS) {
                    DSEventTimer.incrementLdapErrors(this.getLdapId());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Received LDAPException from bind in DirectLdapSearchesThenOpRequest: " + e));
                    }
                }
                response.setPostSearchResult(e.toLDAPResult());
            }
        }
        return response;
    }

    private static SSLSocketFactory getClientTlsSocketFactory(String alias) {
        SSLSocketFactory sslSocketFactory = null;
        try {
            sslSocketFactory = PingCustomSSLSocketFactoryUtil.getSSLSocketFactoryWithSingleKey(alias);
        }
        catch (GeneralSecurityException e) {
            throw new ProcessRuntimeException("Unexpected error while creating single-key SSLSocketFactory", e);
        }
        return sslSocketFactory;
    }

    private LDAPRequest setTargetDn(LDAPRequest request, String dn) throws LDAPException {
        if (request instanceof SimpleBindRequest) {
            SimpleBindRequest bindRequest = (SimpleBindRequest)request;
            return new SimpleBindRequest(dn, bindRequest.getPassword().getValue(), bindRequest.getControls());
        }
        if (request instanceof ModifyRequest) {
            ((ModifyRequest)request).setDN(dn);
            return request;
        }
        if (request instanceof DeleteRequest) {
            ((DeleteRequest)request).setDN(dn);
            return request;
        }
        throw new LDAPException(ResultCode.PARAM_ERROR, "Unsupported operation type: " + request.getClass());
    }

    public boolean isAccountLocked(String subjectDn, LdapDataSource dataSource) throws NamingException {
        boolean accountLocked = false;
        try (EventTimer ignored = this.getEventTimer("account-lock-status-check");){
            if (dataSource.isPingDirectoryOrPingDSType()) {
                accountLocked = this.isPingDirectoryUserAccountLocked(subjectDn);
            } else if (dataSource.isActiveDirectoryType()) {
                accountLocked = this.isActiveDirUserAccountLocked(subjectDn);
            }
        }
        catch (LDAPException e) {
            throw LDAPUtil.convertLdapException(e, this.getLdapId());
        }
        return accountLocked;
    }

    private boolean isPingDirectoryUserAccountLocked(String subjectDn) throws LDAPException {
        if (this.getExtendedOperationsOIDs().contains("1.3.6.1.4.1.30221.1.6.1")) {
            LinkedList<Control> controlsList = new LinkedList<Control>();
            this.addIntermediateClientRequestControl(controlsList);
            this.addAccessLogFieldRequestControl(controlsList);
            PasswordPolicyStateExtendedRequest pwpStateRequest = new PasswordPolicyStateExtendedRequest(subjectDn, controlsList.toArray(new Control[0]), new PasswordPolicyStateOperation[]{PasswordPolicyStateOperation.createGetAccountIsFailureLockedOperation(), PasswordPolicyStateOperation.createGetAccountIsValidationLockedOperation(), PasswordPolicyStateOperation.createGetAccountIsResetLockedOperation()});
            PasswordPolicyStateExtendedResult pwpStateResult = (PasswordPolicyStateExtendedResult)this.getSearchPool().processExtendedOperation((ExtendedRequest)pwpStateRequest);
            if (pwpStateResult.getResultCode() == ResultCode.SUCCESS) {
                return pwpStateResult.getBooleanValue(59) || pwpStateResult.getBooleanValue(86) || pwpStateResult.getBooleanValue(64);
            }
            log.debug((Object)("Error determining account locked status using password policy state extended request [LDAP: error code " + pwpStateResult.getResultCode().intValue() + " - " + pwpStateResult.getDiagnosticMessage() + "]"));
        } else {
            log.debug((Object)"Password policy state extended request is not supported");
        }
        log.debug((Object)"Determining account locked status using pwdAccountLockedTime attribute");
        SearchRequest searchRequest = new SearchRequest(subjectDn, SearchScope.SUB, Filter.createPresenceFilter((String)"pwdAccountLockedTime"), new String[0]);
        this.addIntermediateClientRequestControl((UpdatableLDAPRequest)searchRequest);
        this.addAccessLogFieldRequestControl((UpdatableLDAPRequest)searchRequest);
        SearchResult searchResult = this.getSearchPool().search(searchRequest);
        return searchResult.getEntryCount() != 0;
    }

    private boolean isActiveDirUserAccountLocked(String subjectDn) throws LDAPException {
        SearchResultEntry resultEntry = this.getEntry(subjectDn, StaticUtils.NO_STRINGS);
        String lockedTime = resultEntry.getAttributeValue("lockoutTime");
        return lockedTime != null && !"0".equals(lockedTime);
    }

    private String getPingDirectoryAccountLockedReason(String entryDn) {
        String errorMessage = PasswordPolicyErrorType.ACCOUNT_LOCKED.getName();
        try {
            if (this.getExtendedOperationsOIDs().contains("1.3.6.1.4.1.30221.1.6.1")) {
                PasswordPolicyStateOperation disabledOp = PasswordPolicyStateOperation.createGetAccountDisabledStateOperation();
                LinkedList<Control> controlsList = new LinkedList<Control>();
                this.addIntermediateClientRequestControl(controlsList);
                this.addAccessLogFieldRequestControl(controlsList);
                PasswordPolicyStateExtendedRequest pwpStateRequest = new PasswordPolicyStateExtendedRequest(entryDn, controlsList.toArray(new Control[controlsList.size()]), new PasswordPolicyStateOperation[]{disabledOp});
                PasswordPolicyStateExtendedResult pwpStateResult = (PasswordPolicyStateExtendedResult)this.getSearchPool().processExtendedOperation((ExtendedRequest)pwpStateRequest);
                if (pwpStateResult.getResultCode() == ResultCode.SUCCESS && pwpStateResult.getBooleanValue(1)) {
                    errorMessage = "account-disabled";
                }
            }
        }
        catch (LDAPException e) {
            log.error((Object)("Error determining account status using password policy state extended request [LDAP: error code " + e.getResultCode().intValue() + " - " + e.getDiagnosticMessage() + "]"));
        }
        return errorMessage;
    }

    public static synchronized boolean isAccountUnLockable(LdapDataSource dataSource) {
        return dataSource.isActiveDirectoryType() || dataSource.isPingDirectoryOrPingDSType();
    }

    private static ServerSet getServerSet(ConnectionInfo connectionInfo, LDAPConnectionOptions connectionOptions, SSLSocketFactory socketFactory, BindRequest bindRequest, PostConnectProcessor postConnectProcessor) {
        return LDAPUtil.getServerSet(connectionInfo, connectionOptions, socketFactory, null, bindRequest, postConnectProcessor);
    }

    private static ServerSet getServerSet(ConnectionInfo connectionInfo, LDAPConnectionOptions connectionOptions, SSLSocketFactory socketFactory, String providerURL, BindRequest bindRequest, PostConnectProcessor postConnectProcessor) {
        if (connectionInfo == null) {
            throw new IllegalArgumentException("connectionInfo argument cannot be null");
        }
        if (connectionOptions == null) {
            throw new IllegalArgumentException("connectionOptions argument cannot be null");
        }
        Integer dnsTtlMillis = connectionInfo.getDnsTtlMillis();
        String serverUrl = connectionInfo.getServerUrl();
        return new DNSSRVRecordServerSet(serverUrl, providerURL, null, (long)dnsTtlMillis.intValue(), (SocketFactory)socketFactory, connectionOptions, bindRequest, postConnectProcessor);
    }

    public void releaseConnectionToPool(FullLDAPInterface conn) {
        LDAPInterfaceUtil.releaseInterface((LDAPInterface)this.getSearchPool(), (LDAPInterface)conn);
    }

    public static void getPwdViolationMsgs(List<Message> pwdReqMetMsgList, List<Message> pwdReqNotMetMsgList, LDAPPasswordPolicyViolationException e) {
        for (LDAPPasswordQualityRequirement passwordPolicyViolation : e.getPasswordPolicyReqMet()) {
            pwdReqMetMsgList.addAll(passwordPolicyViolation.getPwdReqMsgList());
        }
        for (LDAPPasswordQualityRequirement passwordPolicyViolation : e.getPasswordPolicyReqNotMet()) {
            pwdReqNotMetMsgList.addAll(passwordPolicyViolation.getPwdReqMsgList());
        }
    }

    public static PasswordPolicyRequirementValidationException convertLDAPPasswordPolicyViolationException(String exceptionMessage, LDAPPasswordPolicyViolationException exception) {
        ArrayList<Message> pwdReqMetMsgList = new ArrayList<Message>();
        ArrayList<Message> pwdReqNotMetMsgList = new ArrayList<Message>();
        LDAPUtil.getPwdViolationMsgs(pwdReqMetMsgList, pwdReqNotMetMsgList, exception);
        return new PasswordPolicyRequirementValidationException(exceptionMessage, pwdReqMetMsgList, pwdReqNotMetMsgList);
    }

    EventTimer getEventTimer(String eventType) {
        return DSEventTimer.getLdapInstance(this.getLdapId(), this.connectionPoolWrapper.connectionInfo.getName(), eventType, this.serviceInformation);
    }

    public static ConnectionPoolMetrics getConnectionPoolMetrics(String dataSourceId) {
        ConnectionInfo connInfo = _wrapperCache.keySet().stream().filter(info -> info.getId().equals(dataSourceId)).findFirst().orElse(null);
        if (connInfo != null && _wrapperCache.containsKey(connInfo)) {
            boolean isGateway = StringUtils.isNotBlank((String)connInfo.getPingOneConnection());
            if (isGateway) {
                return null;
            }
            ConnectionPoolWrapper wrapper = (ConnectionPoolWrapper)_wrapperCache.get(connInfo);
            if (!(wrapper.searchPool instanceof LDAPConnectionPool)) {
                throw new RuntimeException("Unexpected LDAP connection pool class '" + wrapper.searchPool.getClass().getName() + "' for " + dataSourceId);
            }
            LDAPConnectionPool connPool = (LDAPConnectionPool)wrapper.searchPool;
            int maxAvailableConnections = connPool.getMaximumAvailableConnections();
            int curAvailableConnections = connPool.getCurrentAvailableConnections();
            int minConnections = connInfo.getMin();
            int activeConnections = 0;
            return new ConnectionPoolMetrics(maxAvailableConnections, activeConnections, curAvailableConnections, minConnections);
        }
        log.debug((Object)("LdapConnectionPoolWrapper for " + dataSourceId + " has not been created and cached yet, no connection pool metrics found."));
        return null;
    }

    static {
        executorService.scheduleAtFixedRate(connectionPoolCleaner, 0L, connectionPoolCleanupIntervalSeconds, TimeUnit.SECONDS);
    }

    private static enum UserStatus {
        ENABLE,
        DISABLE;

    }

    private static class ConnectionPoolWrapper {
        private final FullLDAPInterface bindPool;
        private final FullLDAPInterface searchPool;
        private final List<String> binaryAttributes;
        private Set<String> supportedControlsOIDs = new HashSet<String>();
        private Set<String> extendedOperationsOIDs = new HashSet<String>();
        private final ConnectionInfo connectionInfo;
        private final String bindPoolName;
        private final String searchPoolName;

        ConnectionPoolWrapper(LDAPConnectionPool bindPool, LDAPConnectionPool searchPool, ConnectionInfo connInfo) throws NamingException {
            this.connectionInfo = connInfo;
            this.bindPool = bindPool;
            this.searchPool = searchPool;
            this.bindPoolName = bindPool.getConnectionPoolName();
            this.searchPoolName = searchPool.getConnectionPoolName();
            this.binaryAttributes = connInfo.getBinaryAttributes() != null ? connInfo.getBinaryAttributes() : new ArrayList<String>();
            this.populateSupportedControls();
        }

        ConnectionPoolWrapper(PingOneTunneledLDAPInterface tunneledLdap, ConnectionInfo connInfo) throws NamingException {
            this.connectionInfo = connInfo;
            this.bindPool = tunneledLdap;
            this.searchPool = tunneledLdap;
            this.bindPoolName = connInfo.getName();
            this.searchPoolName = connInfo.getName();
            this.binaryAttributes = connInfo.getBinaryAttributes() != null ? connInfo.getBinaryAttributes() : new ArrayList<String>();
            this.populateSupportedControls();
        }

        private void populateSupportedControls() throws NamingException {
            if (this.searchPool != null) {
                this.populateSupportedOperations(this.searchPool);
            } else {
                this.populateSupportedOperations(this.bindPool);
            }
        }

        public void cleanup() {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Closing the search and bind pools of %s", this.connectionInfo));
            }
            this.bindPool.close();
            if (this.searchPool instanceof LDAPConnectionPool) {
                this.searchPool.close();
            }
            this.supportedControlsOIDs.clear();
            this.extendedOperationsOIDs.clear();
        }

        private void populateSupportedOperations(FullLDAPInterface connectionPool) throws NamingException {
            try {
                if (connectionPool != null) {
                    RootDSE rootDSE = connectionPool.getRootDSE();
                    if (rootDSE.getSupportedControlOIDs() != null && rootDSE.getSupportedControlOIDs().length > 0) {
                        this.supportedControlsOIDs = Arrays.stream(rootDSE.getSupportedControlOIDs()).collect(Collectors.toSet());
                    }
                    if (rootDSE.getSupportedExtendedOperationOIDs() != null && rootDSE.getSupportedExtendedOperationOIDs().length > 0) {
                        this.extendedOperationsOIDs = Arrays.stream(rootDSE.getSupportedExtendedOperationOIDs()).collect(Collectors.toSet());
                    }
                }
            }
            catch (LDAPException e) {
                throw LDAPUtil.convertLdapException(e, this.connectionInfo.getId());
            }
        }

        boolean isConnectionActive() {
            if (this.connectionInfo != null && StringUtils.isNotBlank((String)this.connectionInfo.getPingOneConnection())) {
                PingOneConnection connection = connectionsMgr.getConnection(this.connectionInfo.getPingOneConnection());
                return connection != null && connection.isActive();
            }
            return true;
        }
    }
}

