/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.ldap;

import com.pingidentity.common.util.ldap.PingSslClientTrustManager;
import com.pingidentity.crypto.SecurityProviderUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PingLdapSSLSocketFactory
extends SSLSocketFactory {
    public static final String DEFAULT_SSL_CONTEXT_TYPE = "SSL";
    private static Log log = LogFactory.getLog(PingLdapSSLSocketFactory.class);
    private static volatile SSLSocketFactory factory;
    private static volatile PingLdapSSLSocketFactory defaultInstance;

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return PingLdapSSLSocketFactory.getFactory().createSocket(s, host, port, autoClose);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return PingLdapSSLSocketFactory.getFactory().createSocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return PingLdapSSLSocketFactory.getFactory().createSocket(host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return PingLdapSSLSocketFactory.getFactory().createSocket(host, port, localHost, localPort);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return PingLdapSSLSocketFactory.getFactory().createSocket(address, port, localAddress, localPort);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return PingLdapSSLSocketFactory.getFactory().getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return PingLdapSSLSocketFactory.getFactory().getSupportedCipherSuites();
    }

    public static SSLSocketFactory getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new PingLdapSSLSocketFactory();
        }
        return defaultInstance;
    }

    private static SSLSocketFactory getFactory() {
        if (factory == null) {
            try {
                PingLdapSSLSocketFactory.createFactory();
            }
            catch (KeyManagementException e) {
                log.error((Object)"KeyManagementException in createFactory()", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (NoSuchAlgorithmException e) {
                log.error((Object)"NoSuchAlgorithmException in createFactory()", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return factory;
    }

    private static synchronized void createFactory() throws NoSuchAlgorithmException, KeyManagementException {
        if (factory == null) {
            TrustManager[] trustMgrArray = null;
            PingSslClientTrustManager pingTrustMgr = PingSslClientTrustManager.getInstance();
            trustMgrArray = new TrustManager[]{pingTrustMgr};
            SSLContext sslc = SSLContext.getInstance(DEFAULT_SSL_CONTEXT_TYPE);
            sslc.init(null, trustMgrArray, SecurityProviderUtil.getSecureRandom());
            SSLSocketFactory ssfc = sslc.getSocketFactory();
            log.debug((Object)("SSLSocketFactory = " + ssfc));
            factory = ssfc;
        }
    }
}

