/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.ldap;

import com.pingidentity.crypto.RevocationChecker;
import com.pingidentity.crypto.RevokedCertException;
import com.pingidentity.crypto.SecurityProviderUtil;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Set;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigurationException;
import org.sourceid.config.GlobalRegistry;

public class PingSslClientTrustManager
implements X509TrustManager {
    private volatile X509TrustManager trustManager = null;
    private RevocationChecker revocationChecker = GlobalRegistry.getService(RevocationChecker.class);
    private Log log = LogFactory.getLog(this.getClass());
    private static PingSslClientTrustManager instance = new PingSslClientTrustManager();

    private PingSslClientTrustManager() {
    }

    public static PingSslClientTrustManager getInstance() {
        return instance;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        throw new CertificateException("PingSslClientTrustManager.checkClientTrusted() is not implemented");
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.trustManager == null) {
            throw new CertificateException("x509TrustManager is not properly initialized");
        }
        this.trustManager.checkServerTrusted(chain, authType);
        if (SecurityProviderUtil.doLegacyRevocationCheck()) {
            try {
                this.revocationChecker.check(chain);
            }
            catch (RevokedCertException e) {
                throw new CertificateException("The server certificate or its issuer has been revoked", e);
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }

    public X509TrustManager createTrustManagerWithCAs(Set<X509Certificate> trustedCerts) {
        try {
            TrustManagerFactory tm = TrustManagerFactory.getInstance(SecurityProviderUtil.getTrustManagerFactoryAlgorithm());
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType(), "SUN");
            keyStore.load(null, new char[]{'n', 'o', 's', 'e', 'c', 'r', 'e', 't'});
            int aliasIdx = 0;
            for (X509Certificate x509Certificate : trustedCerts) {
                keyStore.setCertificateEntry(String.valueOf(aliasIdx++), x509Certificate);
            }
            tm.init(keyStore);
            TrustManager[] trustManagers = tm.getTrustManagers();
            return (X509TrustManager)trustManagers[0];
        }
        catch (Exception e) {
            this.log.error((Object)"Exception while creating trust manager.", (Throwable)e);
            throw new ConfigurationException(e);
        }
    }

    public void setTrustedCAs(Set<X509Certificate> trustedCerts) {
        this.log.debug((Object)"PingSslClientTrustManager.setTrustedCAs()...");
        this.trustManager = this.createTrustManagerWithCAs(trustedCerts);
    }
}

