/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.ldap.passwordvalidator;

import com.pingidentity.common.util.ldap.passwordvalidator.LDAPPasswordQualityRequirement;
import com.pingidentity.sdk.locale.Message;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CharacterSetPasswordValidator
extends LDAPPasswordQualityRequirement {
    private static Logger log = LogManager.getLogger(CharacterSetPasswordValidator.class);
    public static final String VALIDATION_TYPE_KEY = "character-set";
    public static final String PREFIX_CHAR_SET = "set-";
    public static final String SUFFIX_CHAR_SET = "-characters";
    public static final String SUFFIX_MIN_COUNT = "-min-count";
    static final String DETAILED_MSG_SUFFIX = "min.from.character.set";

    public CharacterSetPasswordValidator(Map<String, String> validationPropMap, boolean isSatisfied) {
        super(VALIDATION_TYPE_KEY, validationPropMap, isSatisfied);
    }

    @Override
    protected void processPasswordRequirementsToMessages() {
        ArrayList nestedMsgList = new ArrayList();
        String charSetRegex = "set-(\\d)-characters";
        Pattern charSetPattern = Pattern.compile("set-(\\d)-characters");
        Set propMapKeys = this.validationPropMap.keySet();
        propMapKeys.stream().filter(key -> key.contains(SUFFIX_CHAR_SET)).forEach(key -> {
            Matcher charSetPatternMatch = charSetPattern.matcher((CharSequence)key);
            if (charSetPatternMatch.find()) {
                String counter = charSetPatternMatch.group(1);
                String charset = (String)this.validationPropMap.get(PREFIX_CHAR_SET + counter + SUFFIX_CHAR_SET);
                String minNum = this.validationPropMap.getOrDefault(PREFIX_CHAR_SET + counter + SUFFIX_MIN_COUNT, "Any");
                nestedMsgList.add(new Message(this.getNestedMsgLocalizeFileMsgKey(), new String[]{minNum, charset}));
            } else if (log.isDebugEnabled()) {
                log.debug("Unknown character set validator properties map key: " + key);
            }
        });
        this.pwdReqMsgList.add(new Message(this.rootMsgKeyPrefix, null, nestedMsgList));
    }

    String getNestedMsgLocalizeFileMsgKey() {
        return this.prefixMsgKey(DETAILED_MSG_SUFFIX);
    }
}

