/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.ldap.passwordvalidator;

import com.pingidentity.sdk.locale.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class LDAPPasswordQualityRequirement {
    static final String MESSAGE_PROPERTIES_PREFIX = "password.policy.requirement.";
    static final String MESSAGE_PROPERTIES_SEPERATOR = ".";
    final boolean isSatisfied;
    final Map<String, String> validationPropMap;
    final List<Message> pwdReqMsgList = new ArrayList<Message>();
    final String rootMsgKeyPrefix;

    public LDAPPasswordQualityRequirement(String rootViolationKey, Map<String, String> validationPropMap, boolean isSatisfied) {
        if (StringUtils.isEmpty((String)rootViolationKey)) {
            throw new IllegalArgumentException("Cannot have null value for password policy violation client-side validation type.");
        }
        if (validationPropMap == null) {
            throw new IllegalArgumentException("Cannot have null value for password policy violation client-side validation properties map.");
        }
        this.validationPropMap = new LinkedHashMap<String, String>(validationPropMap);
        this.rootMsgKeyPrefix = LDAPPasswordQualityRequirement.getRootMsgKeyPrefix(rootViolationKey);
        this.isSatisfied = isSatisfied;
        this.processPasswordRequirementsToMessages();
    }

    protected void processPasswordRequirementsToMessages() {
        String[] params = (String[])this.validationPropMap.values().stream().toArray(String[]::new);
        this.pwdReqMsgList.add(new Message(this.rootMsgKeyPrefix, params));
    }

    public List<Message> getPwdReqMsgList() {
        return Collections.unmodifiableList(this.pwdReqMsgList);
    }

    public static String getRootMsgKeyPrefix(String validationType) {
        return MESSAGE_PROPERTIES_PREFIX + LDAPPasswordQualityRequirement.formatMsgKey(validationType);
    }

    String prefixMsgKey(String msgKey) {
        if (StringUtils.isNotEmpty((String)msgKey)) {
            return this.rootMsgKeyPrefix + MESSAGE_PROPERTIES_SEPERATOR + LDAPPasswordQualityRequirement.formatMsgKey(msgKey);
        }
        return "";
    }

    static String formatMsgKey(String msgKey) {
        return msgKey.replace("-", MESSAGE_PROPERTIES_SEPERATOR);
    }
}

