/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.ldap.passwordvalidator;

import com.pingidentity.common.util.ldap.passwordvalidator.LDAPPasswordQualityRequirement;
import com.pingidentity.sdk.locale.Message;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LengthPasswordValidator
extends LDAPPasswordQualityRequirement {
    private static final Log log = LogFactory.getLog(LengthPasswordValidator.class);
    public static final String VALIDATION_TYPE_KEY = "length";
    static final String MIN_PASSWORD_LENGTH = "min-password-length";
    static final String MAX_PASSWORD_LENGTH = "max-password-length";

    public LengthPasswordValidator(Map<String, String> violationPropertiesMap, boolean isSatisfied) {
        super(VALIDATION_TYPE_KEY, violationPropertiesMap, isSatisfied);
    }

    @Override
    protected void processPasswordRequirementsToMessages() {
        String maxLenStr;
        LinkedList<Message> nestedMessages = new LinkedList<Message>();
        String minLenStr = (String)this.validationPropMap.get(MIN_PASSWORD_LENGTH);
        if (StringUtils.isNotEmpty((String)minLenStr)) {
            try {
                nestedMessages.add(new Message(this.prefixMsgKey(MIN_PASSWORD_LENGTH), new String[]{minLenStr}));
            }
            catch (NumberFormatException e) {
                log.debug((Object)"Could not parse integer value for minimum password length from LDAP length password validator.");
            }
        }
        if (StringUtils.isNotEmpty((String)(maxLenStr = (String)this.validationPropMap.get(MAX_PASSWORD_LENGTH)))) {
            try {
                nestedMessages.add(new Message(this.prefixMsgKey(MAX_PASSWORD_LENGTH), new String[]{maxLenStr}));
            }
            catch (NumberFormatException e) {
                log.debug((Object)"Could not parse integer value for maximum password length from LDAP length password validator.");
            }
        }
        this.pwdReqMsgList.add(new Message(this.rootMsgKeyPrefix, null, nestedMessages));
    }
}

