/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.resiliency;

import com.pingidentity.common.util.resiliency.BulkheadStatus;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BulkheadMetricsMeter
implements MeterBinder {
    private final BulkheadRegistry bulkheadRegistry;
    private final ConcurrentMap<String, Set<Meter.Id>> meterIdMap;
    private final Map<String, BulkheadStatus> bulkheadStatusMap;
    private final BulkheadConfig backoffConfig;
    private static final Log log = LogFactory.getLog(BulkheadMetricsMeter.class);

    public BulkheadMetricsMeter(BulkheadRegistry bulkheadRegistry, Map<String, BulkheadStatus> bulkheadStatusMap, BulkheadConfig backoffConfig) {
        this.bulkheadRegistry = bulkheadRegistry;
        this.meterIdMap = new ConcurrentHashMap<String, Set<Meter.Id>>();
        this.bulkheadStatusMap = bulkheadStatusMap;
        this.backoffConfig = backoffConfig;
    }

    public void bindTo(MeterRegistry meterRegistry) {
        for (Bulkhead bulkhead : this.bulkheadRegistry.getAllBulkheads()) {
            this.addMetrics(bulkhead, meterRegistry);
        }
        this.bulkheadRegistry.getEventPublisher().onEntryAdded(event -> this.addMetrics((Bulkhead)event.getAddedEntry(), meterRegistry));
        this.bulkheadRegistry.getEventPublisher().onEntryRemoved(event -> this.removeMetrics(((Bulkhead)event.getRemovedEntry()).getName(), meterRegistry));
        this.bulkheadRegistry.getEventPublisher().onEntryReplaced(event -> {
            this.removeMetrics(((Bulkhead)event.getOldEntry()).getName(), meterRegistry);
            this.addMetrics((Bulkhead)event.getNewEntry(), meterRegistry);
        });
    }

    private void addMetrics(Bulkhead bulkhead, MeterRegistry meterRegistry) {
        log.debug((Object)("Adding metrics for " + bulkhead.getName()));
        HashSet<Meter.Id> idSet = new HashSet<Meter.Id>();
        Counter exceptionCounter = Counter.builder((String)"exception.count").tag("bulkhead", bulkhead.getName()).register(meterRegistry);
        bulkhead.getEventPublisher().onCallRejected(event -> exceptionCounter.increment());
        idSet.add(exceptionCounter.getId());
        Gauge availableCallsGauge = Gauge.builder((String)"available.concurrent.calls", (Object)bulkhead, this::getAvailableConcurrentCalls).tag("bulkhead", bulkhead.getName()).register(meterRegistry);
        idSet.add(availableCallsGauge.getId());
        Gauge maxConcurrentCallsGauge = Gauge.builder((String)"max.concurrent.calls", (Object)bulkhead, this::getMaxAllowedConcurrentCalls).tag("bulkhead", bulkhead.getName()).register(meterRegistry);
        idSet.add(maxConcurrentCallsGauge.getId());
        this.meterIdMap.put(bulkhead.getName(), idSet);
    }

    private int getMaxAllowedConcurrentCalls(Bulkhead bulkhead) {
        BulkheadStatus status = this.bulkheadStatusMap.get(bulkhead.getName());
        if (status != null && status.getState() == BulkheadStatus.BulkheadState.HALF_OPEN) {
            return this.backoffConfig.getMaxConcurrentCalls();
        }
        return bulkhead.getMetrics().getMaxAllowedConcurrentCalls();
    }

    private int getAvailableConcurrentCalls(Bulkhead bulkhead) {
        BulkheadStatus status = this.bulkheadStatusMap.get(bulkhead.getName());
        if (status != null && status.getState() == BulkheadStatus.BulkheadState.HALF_OPEN) {
            int inUseCalls = bulkhead.getMetrics().getMaxAllowedConcurrentCalls() - bulkhead.getMetrics().getAvailableConcurrentCalls();
            int availableCalls = this.backoffConfig.getMaxConcurrentCalls() - inUseCalls;
            return Math.max(availableCalls, 0);
        }
        return bulkhead.getMetrics().getAvailableConcurrentCalls();
    }

    private void removeMetrics(String bulkheadName, MeterRegistry meterRegistry) {
        log.debug((Object)("Removing metrics for " + bulkheadName));
        Set ids = (Set)this.meterIdMap.get(bulkheadName);
        if (ids != null) {
            ids.forEach(arg_0 -> ((MeterRegistry)meterRegistry).remove(arg_0));
        }
        this.meterIdMap.remove(bulkheadName);
    }

    public void clearAllMetrics(MeterRegistry meterRegistry) {
        this.meterIdMap.forEach((bulkheadName, ids) -> ids.forEach(arg_0 -> ((MeterRegistry)meterRegistry).remove(arg_0)));
        this.meterIdMap.clear();
    }
}

