/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.resiliency;

import com.pingidentity.common.util.Substituter;
import com.pingidentity.email.util.NotificationSupportHelper;
import com.pingidentity.monitoring.ThreadDumpLogger;
import com.pingidentity.monitoring.Util;
import com.pingidentity.sdk.notification.NotificationEventType;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.NotificationMode;
import org.sourceid.saml20.domain.NotificationSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.NotificationMgr;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.util.license.Synchronizer;

public class BulkheadNotificationService {
    private static final BulkheadNotificationService instance = new BulkheadNotificationService();
    private static final Log log = LogFactory.getLog(BulkheadNotificationService.class);
    private static final String THREAD_DUMP_GENERATED = "THREAD_DUMP_GENERATED";
    private Timer timer;
    private final ConcurrentMap<String, BulkheadNotificationEvent> alertEvents = new ConcurrentHashMap<String, BulkheadNotificationEvent>();
    private final ConcurrentMap<String, BulkheadNotificationEvent> warningEvents = new ConcurrentHashMap<String, BulkheadNotificationEvent>();
    private NotificationMgr notificationManager = MgmtFactory.getNotificationMgr();

    public static BulkheadNotificationService getInstance() {
        return instance;
    }

    public void start() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    BulkheadNotificationService.this.checkSendNotification();
                }
                catch (Throwable t) {
                    log.error((Object)"Unexpected error during check for bulkhead notification events.", t);
                }
            }
        }, 0L, 5000L);
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    private void checkSendNotification() {
        if (this.notificationManager.getNotificationSettings().isEnableBulkheadAlertNotification()) {
            for (BulkheadNotificationEvent warningEvent : this.warningEvents.values()) {
                this.publishNotification(warningEvent.getParams(), NotificationEventType.BULKHEAD_WARNING);
            }
            for (BulkheadNotificationEvent event : this.alertEvents.values()) {
                if (this.threadDumpEnabled()) {
                    this.logThreadDump(event.getBulkheadId());
                    event.getParams().put(THREAD_DUMP_GENERATED, true);
                }
                this.publishNotification(event.getParams(), NotificationEventType.BULKHEAD_FULL);
            }
        }
        this.warningEvents.clear();
        this.alertEvents.clear();
    }

    public void registerAlertEvent(BulkheadNotificationEvent event) {
        this.alertEvents.put(event.getBulkheadId(), event);
    }

    public void registerWarning(BulkheadNotificationEvent event) {
        this.warningEvents.put(event.getBulkheadId(), event);
    }

    private void publishNotification(Map<String, Object> params, NotificationEventType eventType) {
        NotificationSettings settings = this.notificationManager.getNotificationSettings();
        if (settings.getBulkheadAlertsNotificationMode() == NotificationMode.LOGGING_ONLY) {
            String logTemplate = this.getLogTemplate(eventType, params.containsKey(THREAD_DUMP_GENERATED));
            String msg = Substituter.substituteValuesTolarateUnkownKey((String)logTemplate, params);
            log.info((Object)msg);
        } else {
            String emailTemplateFile = this.getTemplateFile(eventType);
            String notificationPublisher = settings.getNotificationPublisherBulkheadAlerts();
            NotificationSupportHelper notificationSupportHelper = new NotificationSupportHelper();
            String to = settings.getBulkheadAlertsTo();
            notificationSupportHelper.publishNotification(notificationPublisher, emailTemplateFile, to, params, eventType.toString());
        }
    }

    private boolean threadDumpEnabled() {
        return MgmtFactory.getNotificationMgr().getNotificationSettings().getBulkheadThreadDump();
    }

    private void logThreadDump(String bulkheadId) {
        if (MgmtFactory.getNotificationMgr().getNotificationSettings().getBulkheadThreadDump()) {
            Mediator mediator = MgmtFactory.getMediator();
            String ipAddr = mediator.isStandalone() ? Synchronizer.getSynchronizer().getIP() : mediator.getClusterIpAddress();
            String threadDump = Util.dumpThreads();
            ThreadDumpLogger.logBulkheadFullThreadDump(threadDump, bulkheadId, ipAddr);
            log.debug((Object)"Thread dump logged.");
        }
    }

    private String getTemplateFile(NotificationEventType eventType) {
        switch (eventType) {
            case BULKHEAD_FULL: {
                return this.getBulkheadAlertEmailTemplateFile();
            }
            case BULKHEAD_WARNING: {
                return this.getBulkheadWarningEmailTemplateFile();
            }
        }
        return null;
    }

    private String getBulkheadAlertEmailTemplateFile() {
        return "message-template-bulkhead-alert.html";
    }

    private String getBulkheadWarningEmailTemplateFile() {
        return "message-template-bulkhead-warning.html";
    }

    private String getLogTemplate(NotificationEventType eventType, boolean threadDumpGenerated) {
        StringBuilder logTemplate = new StringBuilder();
        if (eventType == NotificationEventType.BULKHEAD_WARNING) {
            logTemplate.append("\n\tThe PingFederate bulkhead with ID ${BULKHEAD_ID} has reached its configured warning threshold for concurrent calls.\n");
        } else {
            logTemplate.append("\n\tThe PingFederate bulkhead with ID ${BULKHEAD_ID} has reached its maximum concurrent calls limit.\n");
        }
        logTemplate.append(threadDumpGenerated ? "\tA thread dump was generated.\n" : "");
        logTemplate.append("\tCurrent Concurrent Calls: ${IN_USE_CALLS}\n");
        logTemplate.append("\tMax Concurrent Calls: ${MAX_CALLS}\n");
        return logTemplate.toString();
    }

    public static class BulkheadNotificationEvent {
        private final String bulkheadId;
        private final Map<String, Object> params;

        public BulkheadNotificationEvent(String bulkheadId, Map<String, Object> params) {
            this.bulkheadId = bulkheadId;
            this.params = params;
        }

        public String getBulkheadId() {
            return this.bulkheadId;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }
    }
}

