/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.ssl;

import com.pingidentity.common.util.ldap.PingSslClientTrustManager;
import com.pingidentity.crypto.SecurityProviderUtil;
import com.pingidentity.util.tls.SingleClientX509KeyManager;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class PingCustomSSLSocketFactoryUtil {
    public static final String DEFAULT_SSL_CONTEXT_PROTOCOL = "TLS";

    public static SSLSocketFactory getSSLSocketFactoryWithSingleKey(String alias) throws KeyManagementException, NoSuchAlgorithmException {
        KeyManager[] km = new KeyManager[]{new SingleClientX509KeyManager(alias)};
        PingSslClientTrustManager pingTrustMgr = PingSslClientTrustManager.getInstance();
        TrustManager[] trustMgrArray = new TrustManager[]{pingTrustMgr};
        SSLContext sslc = SSLContext.getInstance(DEFAULT_SSL_CONTEXT_PROTOCOL);
        sslc.init(km, trustMgrArray, SecurityProviderUtil.getSecureRandom());
        return sslc.getSocketFactory();
    }
}

