/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.timers;

import com.pingidentity.common.util.LogGuard;
import com.pingidentity.common.util.resiliency.ResiliencyManager;
import com.pingidentity.common.util.resiliency.ResiliencyManagerFactory;
import com.pingidentity.common.util.resiliency.ResiliencyServiceReference;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public abstract class EventTimer
implements AutoCloseable {
    private static final Log log = LogFactory.getLog(EventTimer.class);
    private final long startTime;
    private final String timerName;
    private final String eventType;
    private final Map<String, Object> attributes;
    protected static final String RESILIENCY_SERVICE_REFERENCE = "resiliencyServiceReference";
    protected static final ResiliencyManagerFactory resiliencyManagerFactory = MgmtFactory.getResiliencyManagerFactory();

    EventTimer(String timerName, String eventType, Map<String, Object> attributes) {
        this.attributes = attributes;
        this.startTime = System.currentTimeMillis();
        this.timerName = timerName;
        this.eventType = eventType;
    }

    @Override
    public void close() {
        long timeSpend = System.currentTimeMillis() - this.startTime;
        this.done(timeSpend);
        this.cleanupResiliencyServiceInstance();
    }

    public void done(long timeSpend) {
        if (log.isDebugEnabled()) {
            StringBuilder msgBuilder = new StringBuilder(LogGuard.encode(this.timerName)).append("{");
            for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
                msgBuilder.append(LogGuard.encode(entry.getKey())).append("='");
                if (entry.getValue() != null) {
                    msgBuilder.append(LogGuard.encode(entry.getValue().toString()));
                }
                msgBuilder.append("', ");
            }
            msgBuilder.append("eventType='").append(LogGuard.encode(this.eventType)).append("', ");
            msgBuilder.append("timeSpentMs='").append(timeSpend).append("'}");
            log.debug((Object)msgBuilder.toString());
        }
    }

    protected void cleanupResiliencyServiceInstance() {
        ResiliencyServiceReference resiliencyServiceReference = (ResiliencyServiceReference)this.getAttributes().get(RESILIENCY_SERVICE_REFERENCE);
        if (resiliencyServiceReference != null) {
            ResiliencyManager resiliencyManager = resiliencyManagerFactory.getResiliencyManagerById(resiliencyServiceReference.getServiceId());
            resiliencyManager.cleanUpServiceInstance(resiliencyServiceReference.getInstanceId());
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getEventType() {
        return this.eventType;
    }

    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    protected String getStringValueFromAttributes(String attributeName) {
        return Optional.ofNullable(this.getAttributes().get(attributeName)).filter(obj -> obj instanceof String).map(obj -> (String)obj).orElse("Undefined");
    }
}

