/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.xml;

import com.pingidentity.common.util.xml.InvalidXmlException;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;

public class XPathUtil {
    private static final Log log = LogFactory.getLog(XPathUtil.class);

    public static <T extends XmlObject> T selectFirst(XmlObject src, String xpathexp, Class<T> type, String context) {
        XmlObject[] xmlObjects;
        XmlObject firstFound = null;
        XmlObject[] xmlObjectArray = xmlObjects = src != null ? src.selectPath(xpathexp) : null;
        if (xmlObjects != null && xmlObjects.length > 0) {
            XmlObject xmlObject = xmlObjects[0];
            try {
                firstFound = (XmlObject)type.cast(xmlObject);
                try {
                    XmlBeansUtil.validate(firstFound);
                }
                catch (InvalidXmlException e) {
                    log.warn((Object)("Invalid XML: " + context + " " + e));
                }
            }
            catch (ClassCastException e) {
                Class<?> xclass = xmlObject.getClass();
                String msg = "Wrong type found from xpath " + xpathexp + " expected " + type + " but found " + xclass;
                log.warn((Object)(msg + " " + e));
            }
        }
        return (T)firstFound;
    }
}

