/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.xml;

import com.pingidentity.common.util.xml.InvalidXmlException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.sourceid.protocol.saml11.xml.IDType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlBeansUtil {
    public static final String CLASS_SUFFIX_TYPE = "Type";
    public static final String CLASS_SUFFIX_DOCUMENT = "Document";
    public static final String CLASS_NAME_FACTORY = "Factory";
    public static final String METHOD_NAME_NEW_INSTANCE = "newInstance";
    public static final String METHOD_NAME_PREFIX_SET = "set";
    public static final String DOT = ".";
    public static final String NS_SAML = "urn:oasis:names:tc:SAML:1.0:assertion";
    public static final String NS_SAMLP = "urn:oasis:names:tc:SAML:1.0:protocol";
    public static final String NS_LIB = "urn:liberty:iff:2003-08";
    public static final String NS_XS = "http://www.w3.org/2001/XMLSchema";
    public static final String NS_SOAP11 = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String NS_SOAP12 = "http://www.w3.org/2003/05/soap-envelope";
    public static final String NS_DS = "http://www.w3.org/2000/09/xmldsig#";
    public static final String NS_XENC = "http://www.w3.org/2001/04/xmlenc#";
    public static final String NS_SAML2 = "urn:oasis:names:tc:SAML:2.0:assertion";
    public static final String NS_SAML2P = "urn:oasis:names:tc:SAML:2.0:protocol";
    public static final String NS_SAML2_ECP = "urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp";
    public static final String NS_PAOS = "urn:liberty:paos:2003-08";
    public static final String NS_WS_TRUST = "http://schemas.xmlsoap.org/ws/2005/02/trust";
    public static final String NS_WS_TRUST_13 = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
    public static final String NS_WS_TRUST_13_SLASH = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/";
    public static final String NS_WS_POLICY = "http://schemas.xmlsoap.org/ws/2004/09/policy";
    public static final String NS_WSDL11 = "http://schemas.xmlsoap.org/wsdl/";
    public static final String NS_WSDL_SOAP12 = "http://schemas.xmlsoap.org/wsdl/soap12/";
    public static final String NS_WS_ADDRESS = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
    public static final String NS_WS_ADDRESS10 = "http://www.w3.org/2005/08/addressing";
    public static final String NS_SAML2_MD = "urn:oasis:names:tc:SAML:2.0:metadata";
    public static final String NS_SAML1X_MD = "urn:oasis:names:tc:SAML:profiles:v1metadata";
    public static final String NS_SAML2_MD_EX_Q = "urn:oasis:names:tc:SAML:metadata:ext:query";
    public static final String NS_WSU = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    public static final String NS_WSSE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    public static final String NS_WSSE11 = "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd";
    public static final String NS_XML = "http://www.w3.org/XML/1998/namespace";
    public static final String NS_WS_FED = "http://docs.oasis-open.org/wsfed/federation/200706";
    public static final String NS_WS_FED_AUTH = "http://docs.oasis-open.org/wsfed/authorization/200706";
    public static final String NS_SAML_MD_ALGSUPPORT = "urn:oasis:names:tc:SAML:metadata:algsupport";
    public static final String NS_PREFIX_DS = "ds";
    private static Map<String, String> xmlNsPrefixMap;
    private static Log log;
    private static final XmlOptions SAVE_XML_OPTIONS;

    public static String getXmlNsPrefix(String key) {
        return xmlNsPrefixMap.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlObject wrapTypeInDocument(XmlObject type) throws XmlException {
        try {
            Class<?>[] declaredClasses;
            String methodNameSuffix;
            Object documentXmlObject = null;
            Class<?> typeClass = type.getClass();
            Class<?>[] interfaces = typeClass.getInterfaces();
            Class<?> typeInterface = null;
            for (Class<?> anInterface : interfaces) {
                if (!anInterface.getName().endsWith(CLASS_SUFFIX_TYPE)) continue;
                typeInterface = anInterface;
                break;
            }
            String typeInterfaceName = typeInterface.getName();
            int endIndex = typeInterfaceName.length() - CLASS_SUFFIX_TYPE.length();
            String baseInterfaceName = typeInterfaceName.substring(0, endIndex);
            StringBuffer docInterfaceNameBuf = new StringBuffer();
            XmlCursor xmlCursor = null;
            try {
                xmlCursor = type.newCursor();
                QName name = xmlCursor.getName();
                if (name != null) {
                    docInterfaceNameBuf.append(typeInterface.getPackage().getName());
                    docInterfaceNameBuf.append(DOT);
                    String localPart = name.getLocalPart();
                    docInterfaceNameBuf.append(localPart);
                    methodNameSuffix = localPart;
                } else {
                    methodNameSuffix = baseInterfaceName.substring(baseInterfaceName.lastIndexOf(DOT) + DOT.length());
                    docInterfaceNameBuf.append(baseInterfaceName);
                }
                docInterfaceNameBuf.append(CLASS_SUFFIX_DOCUMENT);
            }
            finally {
                XmlBeansUtil.disposeCursor(xmlCursor);
            }
            Class<?> docClass = Class.forName(docInterfaceNameBuf.toString());
            for (Class<?> declaredClass : declaredClasses = docClass.getDeclaredClasses()) {
                String declaredClassName = declaredClass.getName();
                if (!declaredClassName.endsWith(CLASS_NAME_FACTORY)) continue;
                Method newInstanceMethod = declaredClass.getMethod(METHOD_NAME_NEW_INSTANCE, new Class[0]);
                Object object = newInstanceMethod.invoke(null, new Object[0]);
                documentXmlObject = (XmlObject)object;
                break;
            }
            Class[] parameterTypes = new Class[]{typeInterface};
            String methodName = METHOD_NAME_PREFIX_SET + methodNameSuffix;
            Method setMethod = documentXmlObject.getClass().getMethod(methodName, parameterTypes);
            setMethod.invoke(documentXmlObject, type);
            return documentXmlObject;
        }
        catch (Exception e) {
            throw new XmlException("Attempt to wrap XmlObject 'Type' in 'Document' failed for " + type.getClass() + ".  XML: " + type, (Throwable)e);
        }
    }

    public static XmlObject unwrapDocumentToType(XmlObject document) {
        XmlObject type = XmlBeansUtil.isType(document) ? document : XmlBeansUtil.getFirstChild(document);
        return type;
    }

    public static boolean isType(XmlObject xmlObject) {
        return !XmlBeansUtil.isDocument(xmlObject);
    }

    public static boolean isDocument(XmlObject xmlObject) {
        return xmlObject.schemaType().isDocumentType();
    }

    public static void validate(XmlObject xmlObject) throws InvalidXmlException {
        XmlOptions xmlOptions = new XmlOptions();
        LinkedList errors = new LinkedList();
        xmlOptions.setErrorListener(errors);
        if (!xmlObject.validate(xmlOptions)) {
            throw new InvalidXmlException(errors, xmlObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlObject getFirstChild(XmlObject xml) {
        XmlCursor xmlCursor = null;
        try {
            xmlCursor = xml.newCursor();
            boolean hasFirstChild = xmlCursor.toFirstChild();
            if (hasFirstChild) {
                XmlObject xmlObject = xmlCursor.getObject();
                return xmlObject;
            }
        }
        finally {
            XmlBeansUtil.disposeCursor(xmlCursor);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<XmlObject> getChildren(XmlObject xml) {
        ArrayList<XmlObject> children = new ArrayList<XmlObject>();
        XmlCursor xmlCursor = null;
        if (xml != null) {
            try {
                xmlCursor = xml.newCursor();
                boolean hasFirstChild = xmlCursor.toFirstChild();
                if (hasFirstChild) {
                    children.add(xmlCursor.getObject());
                    while (xmlCursor.toNextSibling()) {
                        children.add(xmlCursor.getObject());
                    }
                }
            }
            finally {
                XmlBeansUtil.disposeCursor(xmlCursor);
            }
        }
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setChildren(XmlObject target, XmlObject ... children) {
        XmlCursor xmlCursor = null;
        try {
            xmlCursor = target.newCursor();
            xmlCursor.toEndToken();
            for (XmlObject child : children) {
                XmlCursor childCursor = null;
                try {
                    childCursor = child.newCursor();
                    childCursor.copyXml(xmlCursor);
                }
                finally {
                    XmlBeansUtil.disposeCursor(childCursor);
                }
            }
        }
        finally {
            XmlBeansUtil.disposeCursor(xmlCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prependChildren(XmlObject target, XmlObject ... children) {
        XmlCursor xmlCursor = null;
        try {
            xmlCursor = target.newCursor();
            boolean hasChild = xmlCursor.toFirstChild();
            if (!hasChild) {
                xmlCursor.toEndToken();
            }
            for (XmlObject child : children) {
                XmlCursor childCursor = null;
                try {
                    childCursor = child.newCursor();
                    childCursor.copyXml(xmlCursor);
                }
                finally {
                    XmlBeansUtil.disposeCursor(childCursor);
                }
            }
        }
        finally {
            XmlBeansUtil.disposeCursor(xmlCursor);
        }
    }

    public static String getAttributeValue(XmlObject xmlObject, String attrName) {
        return XmlBeansUtil.getAttributeValue(xmlObject, null, attrName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAttributeValue(XmlObject xmlObject, String attrNS, String attrName) {
        String attributeValue;
        XmlCursor xmlCursor = null;
        try {
            xmlCursor = xmlObject.newCursor();
            QName qn = attrNS == null ? new QName(attrName) : new QName(attrNS, attrName);
            attributeValue = xmlCursor.getAttributeText(qn);
        }
        finally {
            XmlBeansUtil.disposeCursor(xmlCursor);
        }
        return attributeValue;
    }

    public static String getTextValue(XmlObject xmlObject) {
        XmlCursor xmlCursor = null;
        try {
            xmlCursor = xmlObject.newCursor();
            String string = xmlCursor.getTextValue();
            return string;
        }
        finally {
            XmlBeansUtil.disposeCursor(xmlCursor);
        }
    }

    public static void setAttributeValue(XmlObject xmlObject, String attrValue, String attrName) {
        XmlBeansUtil.setAttributeValue(xmlObject, attrValue, null, attrName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAttributeValue(XmlObject xmlObject, String attrValue, String attrNS, String attrName) {
        XmlCursor xmlCursor = null;
        try {
            xmlCursor = xmlObject.newCursor();
            QName qn = attrNS == null ? new QName(attrName) : new QName(attrNS, attrName);
            xmlCursor.setAttributeText(qn, attrValue);
        }
        finally {
            XmlBeansUtil.disposeCursor(xmlCursor);
        }
    }

    public static void disposeCursor(XmlCursor cur) {
        if (cur != null) {
            cur.dispose();
        }
    }

    public static QName findIDAttribute(XmlObject obj) {
        SchemaProperty[] props;
        QName keyqn = null;
        for (SchemaProperty prop : props = obj.schemaType().getAttributeProperties()) {
            SchemaType type = prop.getType();
            if (type.getBuiltinTypeCode() != 40 && type != IDType.type) continue;
            keyqn = prop.getName();
            break;
        }
        return keyqn;
    }

    public static <T extends XmlObject> T parse(String xmlString, Class<T> type) throws XmlException {
        Node node = XmlBeansUtil.parseToNode(xmlString);
        XmlObject xmlObject = XmlObject.Factory.parse((Node)node);
        return XmlBeansUtil.checkedCast(type, xmlObject);
    }

    private static <T extends XmlObject> T checkedCast(Class<T> type, XmlObject xmlObject) throws XmlException {
        if (!type.isInstance(xmlObject)) {
            String interfaces = Arrays.toString(xmlObject.getClass().getInterfaces());
            throw new XmlException("Parse gave " + interfaces + " but was expecting " + type.getName());
        }
        return (T)((XmlObject)type.cast(xmlObject));
    }

    public static <T extends XmlObject> T parse(InputStream inStream, Class<T> type) throws XmlException {
        try {
            String xmlString = "";
            int ttlBytes = 0;
            byte[] buff = new byte[]{};
            byte[] tmpBuf = new byte[4096];
            int nBytesRead = inStream.read(tmpBuf);
            while (nBytesRead > 0) {
                if ((ttlBytes += nBytesRead) == nBytesRead) {
                    buff = new byte[nBytesRead];
                    System.arraycopy(tmpBuf, 0, buff, 0, nBytesRead);
                } else {
                    byte[] newBuf = new byte[ttlBytes];
                    System.arraycopy(buff, 0, newBuf, 0, buff.length);
                    System.arraycopy(tmpBuf, 0, newBuf, buff.length, nBytesRead);
                    buff = newBuf;
                }
                nBytesRead = inStream.read(tmpBuf);
            }
            xmlString = new String(buff, StandardCharsets.UTF_8);
            if (log.isTraceEnabled()) {
                log.trace((Object)("parsing " + xmlString));
            }
            Node node = XmlBeansUtil.parseToNode(new ByteArrayInputStream(buff));
            XmlObject xmlObject = XmlObject.Factory.parse((Node)node);
            return XmlBeansUtil.checkedCast(type, xmlObject);
        }
        catch (Exception e) {
            throw new XmlException((Throwable)e);
        }
    }

    public static <T extends XmlObject> T canonicalize(T xmlObj, Class<T> type) throws XmlException {
        if (!XmlBeansUtil.isDocument(xmlObj)) {
            throw new XmlException("canonicalize must take a document (not type) " + xmlObj.getClass());
        }
        try {
            ByteArrayOutputStream canonicalXmlOutputStream = new ByteArrayOutputStream();
            Canonicalizer c14ner = Canonicalizer.getInstance((String)"http://www.w3.org/2001/10/xml-exc-c14n#");
            c14ner.canonicalizeSubtree((Node)XmlBeansUtil.newDomNode(xmlObj), XmlBeansUtil.getXmlNsPrefix(NS_XS), (OutputStream)canonicalXmlOutputStream);
            ByteArrayInputStream canonicalXmlInputStream = new ByteArrayInputStream(canonicalXmlOutputStream.toByteArray());
            return XmlBeansUtil.parse(canonicalXmlInputStream, type);
        }
        catch (XMLSecurityException e) {
            throw new XmlException("Unable to canonicalize xml object.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNamespaceUri(XmlObject xmlObject) {
        SchemaType schemaType = xmlObject.schemaType();
        QName name = schemaType.getDocumentElementName();
        if (name == null) {
            XmlCursor xmlCursor = null;
            try {
                xmlCursor = xmlObject.newCursor();
                name = xmlCursor.getName();
            }
            finally {
                XmlBeansUtil.disposeCursor(xmlCursor);
            }
        }
        return name != null ? name.getNamespaceURI() : null;
    }

    public static String xmlText(XmlObject xmlObject) {
        return xmlObject.xmlText(SAVE_XML_OPTIONS);
    }

    public static XmlOptions getXmlOptions() {
        return new XmlOptions(SAVE_XML_OPTIONS);
    }

    public static Document newDomNode(XmlObject xmlObject) {
        Document document;
        StringReader reader = new StringReader(xmlObject.xmlText(SAVE_XML_OPTIONS));
        try {
            DocumentBuilder builder = XmlBeansUtil.getDocumentBuilder();
            document = builder.parse(new InputSource(reader));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Error occurred when converting XmlObject to DOM", e);
            }
        }
        ((Reader)reader).close();
        return document;
    }

    public static void save(XmlObject xmlObject, Writer writer) throws IOException {
        xmlObject.save(writer, SAVE_XML_OPTIONS);
    }

    public static void save(XmlObject xmlObject, OutputStream os) throws IOException {
        xmlObject.save(os, SAVE_XML_OPTIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceNamespacePrefix(XmlObject xmlObject) {
        XmlObject typeObject = XmlBeansUtil.unwrapDocumentToType(xmlObject);
        String nsUri = XmlBeansUtil.getNamespaceUri(typeObject);
        XmlCursor xmlCursor = null;
        try {
            xmlCursor = typeObject.newCursor();
            xmlCursor.toNextToken();
            xmlCursor.insertNamespace(XmlBeansUtil.getXmlNsPrefix(nsUri), nsUri);
        }
        finally {
            XmlBeansUtil.disposeCursor(xmlCursor);
        }
    }

    public static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        dbf.setNamespaceAware(true);
        DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
        documentBuilder.setErrorHandler(null);
        return documentBuilder;
    }

    public static Node parseToNode(InputStream inputStream) throws XmlException {
        try {
            DocumentBuilder documentBuilder = XmlBeansUtil.getDocumentBuilder();
            return documentBuilder.parse(inputStream);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new XmlException((Throwable)e);
        }
    }

    public static Node parseToNode(String string) throws XmlException {
        Document document;
        StringReader reader = new StringReader(string);
        try {
            DocumentBuilder documentBuilder = XmlBeansUtil.getDocumentBuilder();
            document = documentBuilder.parse(new InputSource(reader));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                throw new XmlException((Throwable)e);
            }
        }
        ((Reader)reader).close();
        return document;
    }

    static {
        log = LogFactory.getLog(XmlBeansUtil.class);
        SAVE_XML_OPTIONS = new XmlOptions();
        Init.init();
        xmlNsPrefixMap = new HashMap<String, String>();
        xmlNsPrefixMap.put(NS_SAML, "saml");
        xmlNsPrefixMap.put(NS_SAMLP, "samlp");
        xmlNsPrefixMap.put(NS_LIB, "lib");
        xmlNsPrefixMap.put(NS_XS, "xs");
        xmlNsPrefixMap.put(NS_SOAP11, "S11");
        xmlNsPrefixMap.put(NS_SOAP12, "s");
        xmlNsPrefixMap.put(NS_DS, NS_PREFIX_DS);
        xmlNsPrefixMap.put(NS_XENC, "xenc");
        xmlNsPrefixMap.put(NS_SAML2, "saml");
        xmlNsPrefixMap.put(NS_SAML2P, "samlp");
        xmlNsPrefixMap.put(NS_SAML2_ECP, "ecp");
        xmlNsPrefixMap.put(NS_PAOS, "paos");
        xmlNsPrefixMap.put(NS_WS_TRUST, "wst");
        xmlNsPrefixMap.put(NS_WS_TRUST_13, "wst13");
        xmlNsPrefixMap.put(NS_WS_TRUST_13_SLASH, "wst");
        xmlNsPrefixMap.put(NS_WS_POLICY, "wsp");
        xmlNsPrefixMap.put(NS_WS_ADDRESS, "wsa");
        xmlNsPrefixMap.put(NS_WS_ADDRESS10, "wsa");
        xmlNsPrefixMap.put(NS_SAML1X_MD, "saml1md");
        xmlNsPrefixMap.put(NS_SAML2_MD, "md");
        xmlNsPrefixMap.put(NS_SAML2_MD_EX_Q, "query");
        xmlNsPrefixMap.put(NS_WS_FED, "fed");
        xmlNsPrefixMap.put(NS_WS_FED_AUTH, "fedauth");
        xmlNsPrefixMap.put(NS_SAML_MD_ALGSUPPORT, "alg");
        xmlNsPrefixMap.put(NS_WSSE, "wsse");
        xmlNsPrefixMap.put(NS_WSSE11, "wsse11");
        xmlNsPrefixMap.put(NS_WSU, "wsu");
        SAVE_XML_OPTIONS.setSaveSuggestedPrefixes(xmlNsPrefixMap);
        SAVE_XML_OPTIONS.setSaveOuter();
    }
}

