/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.xml;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;

public class XmlObjectWalker {
    private XmlObject xmlObject;
    private List<VisitCallback> callbacks = new ArrayList<VisitCallback>();

    public XmlObjectWalker(XmlObject xmlObject) {
        this.xmlObject = xmlObject;
    }

    public void addCallback(VisitCallback callback) {
        this.callbacks.add(callback);
    }

    public void walkEveryNode() {
        this.recursivePreEvalDepthFirstTraversal(this.xmlObject);
    }

    public void walkChildern() {
        XmlCursor xmlCursor = this.xmlObject.newCursor();
        try {
            if (xmlCursor.isStartdoc()) {
                xmlCursor.toFirstChild();
            }
            boolean hasNext = xmlCursor.toFirstChild();
            while (hasNext) {
                this.eval(xmlCursor.getObject());
                hasNext = xmlCursor.toNextSibling();
            }
        }
        finally {
            XmlBeansUtil.disposeCursor(xmlCursor);
        }
    }

    public void walkThisAndChildern() {
        XmlCursor xmlCursor = this.xmlObject.newCursor();
        try {
            if (xmlCursor.isStartdoc()) {
                xmlCursor.toFirstChild();
            }
            this.eval(xmlCursor.getObject());
            boolean hasNext = xmlCursor.toFirstChild();
            while (hasNext) {
                this.eval(xmlCursor.getObject());
                hasNext = xmlCursor.toNextSibling();
            }
        }
        finally {
            XmlBeansUtil.disposeCursor(xmlCursor);
        }
    }

    private void recursivePreEvalDepthFirstTraversal(XmlObject obj) {
        if (obj == null) {
            return;
        }
        XmlCursor xmlCursor = obj.newCursor();
        try {
            this.eval(obj);
            xmlCursor.push();
            if (xmlCursor.toFirstChild()) {
                this.recursivePreEvalDepthFirstTraversal(xmlCursor.getObject());
            }
            xmlCursor.pop();
            if (xmlCursor.toNextSibling()) {
                this.recursivePreEvalDepthFirstTraversal(xmlCursor.getObject());
            }
        }
        finally {
            XmlBeansUtil.disposeCursor(xmlCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eval(XmlObject obj) {
        XmlCursor xmlCursor = obj.newCursor();
        try {
            QName qname = xmlCursor.getName();
            if (qname != null) {
                for (VisitCallback callback : this.callbacks) {
                    callback.visit(obj, qname);
                }
            }
        }
        finally {
            XmlBeansUtil.disposeCursor(xmlCursor);
        }
    }

    public static XmlObject findChild(QName searchFor, XmlObject root) {
        XmlObjectWalker finder = new XmlObjectWalker(root);
        FinderCallback finderCallback = new FinderCallback(searchFor);
        finder.addCallback(finderCallback);
        finder.walkChildern();
        return finderCallback.getSearchResult();
    }

    public static XmlObject find(QName searchFor, XmlObject root) {
        XmlObjectWalker finder = new XmlObjectWalker(root);
        FinderCallback finderCallback = new FinderCallback(searchFor);
        finder.addCallback(finderCallback);
        finder.walkEveryNode();
        return finderCallback.getSearchResult();
    }

    private static class FinderCallback
    implements VisitCallback {
        private QName searchFor;
        private XmlObject result;

        private FinderCallback(QName searchFor) {
            this.searchFor = searchFor;
        }

        @Override
        public void visit(XmlObject xmlObject, QName qName) {
            if (this.result == null && qName.equals(this.searchFor)) {
                this.result = xmlObject;
            }
        }

        public XmlObject getSearchResult() {
            return this.result;
        }
    }

    public static interface VisitCallback {
        public void visit(XmlObject var1, QName var2);
    }
}

