/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.zip;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class UnzipUtil {
    private static final int BUFFER_SIZE = 8192;

    public static Map<String, byte[]> unzip(byte[] zipFileData) throws IOException {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(zipFileData);){
            Map<String, byte[]> map = UnzipUtil.unzip(byteArrayInputStream);
            return map;
        }
    }

    public static Map<String, byte[]> unzip(File zipFile) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(zipFile);){
            Map<String, byte[]> map = UnzipUtil.unzip(fileInputStream);
            return map;
        }
    }

    public static Map<String, byte[]> unzip(InputStream inputStream) throws IOException {
        HashMap<String, byte[]> unzipped = new HashMap<String, byte[]>();
        byte[] buffer = new byte[8192];
        try (ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String entryName = zipEntry.getName();
                try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                    int count;
                    while ((count = zipInputStream.read(buffer, 0, buffer.length)) != -1) {
                        byteArrayOutputStream.write(buffer, 0, count);
                    }
                    unzipped.put(entryName, byteArrayOutputStream.toByteArray());
                }
            }
            HashMap<String, byte[]> hashMap = unzipped;
            return hashMap;
        }
    }

    public static void unzip(File zipFile, File targetDir) throws IOException {
        try (FileInputStream fis = new FileInputStream(zipFile);
             ZipInputStream zis = new ZipInputStream(fis);){
            ZipEntry zipEntry;
            while ((zipEntry = zis.getNextEntry()) != null) {
                File targetFile = new File(targetDir, zipEntry.getName());
                String targetDirPath = targetDir.getCanonicalPath();
                String targetFilePath = targetFile.getCanonicalPath();
                if (!targetFilePath.startsWith(targetDirPath + File.separator)) {
                    throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
                }
                if (zipEntry.isDirectory()) {
                    if (targetFile.mkdirs()) continue;
                    if (!targetFile.exists()) {
                        throw new IOException("Cannot create target folder: " + targetFile.getName() + " during bulk I/E for configStore");
                    }
                }
                byte[] buffer = new byte[8192];
                try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(targetFile));){
                    int count;
                    while ((count = zis.read(buffer)) != -1) {
                        out.write(buffer, 0, count);
                    }
                }
            }
        }
    }
}

