/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.zip;

import com.pingidentity.common.util.zip.FileEntry;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZipUtil {
    private static final Log log = LogFactory.getLog(ZipUtil.class);

    private ZipUtil() {
        throw new UnsupportedOperationException("not allowed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] zip(File baseDir, Set<File> excludes, Set<File> includes, Map<String, byte[]> additionalEntries) throws IOException {
        log.debug((Object)("Zip " + baseDir + " exclude: " + excludes));
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ZipOutputStream zipOut = new ZipOutputStream(byteArrayOutputStream);
        boolean added = false;
        try {
            List<String> pathElements = Collections.emptyList();
            added = ZipUtil.addDir(pathElements, baseDir, zipOut, buffer, excludes);
            for (File file : includes) {
                if (!file.exists()) {
                    log.warn((Object)("Include file does not exist: " + file));
                    continue;
                }
                if (file.isDirectory()) {
                    log.warn((Object)("Include file is a directory: " + file + ". Directory includes are not supported"));
                    continue;
                }
                if (!file.isFile()) continue;
                String parent = file.getParent();
                if (parent == null) {
                    log.warn((Object)("Include file has no parent: " + file));
                    continue;
                }
                if (parent.startsWith(baseDir.getAbsolutePath())) {
                    String[] parts = parent.substring(baseDir.getAbsolutePath().length()).split(File.pathSeparator);
                    LinkedList<String> subPathElements = new LinkedList<String>(Arrays.asList(parts));
                    added |= ZipUtil.addFile(subPathElements, file, zipOut, buffer, Collections.emptySet());
                    continue;
                }
                log.warn((Object)("Include file is not in base directory: " + file));
            }
            if (additionalEntries != null && !additionalEntries.isEmpty()) {
                ZipUtil.addEntries(zipOut, additionalEntries);
            }
        }
        finally {
            if (added) {
                zipOut.close();
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static boolean addDir(List<String> pathElements, File dir, ZipOutputStream zipOut, byte[] buffer, Set<File> excludes) throws IOException {
        boolean added = false;
        String zipPath = ZipUtil.getPath(pathElements).toString();
        if (!excludes.contains(dir)) {
            log.debug((Object)("Dir: " + zipPath));
            File[] fileList = dir.listFiles();
            if (fileList != null) {
                for (File file : fileList) {
                    if (file.isFile()) {
                        added |= ZipUtil.addFile(pathElements, file, zipOut, buffer, excludes);
                        continue;
                    }
                    if (!file.isDirectory()) continue;
                    LinkedList<String> subDirPathElements = new LinkedList<String>(pathElements);
                    subDirPathElements.add(file.getName());
                    added |= ZipUtil.addDir(subDirPathElements, file, zipOut, buffer, excludes);
                }
            }
        } else {
            log.debug((Object)("Excluding dir: " + zipPath));
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean addFile(List<String> pathElements, File file, ZipOutputStream zipOut, byte[] buffer, Set<File> excludes) throws IOException {
        boolean added = false;
        String zipEntryName = ZipUtil.getFileName(pathElements, file);
        if (!excludes.contains(file)) {
            ZipEntry zipEntry = new ZipEntry(zipEntryName);
            log.trace((Object)("ZIPPING " + zipEntry));
            zipEntry.setTime(file.lastModified());
            zipOut.putNextEntry(zipEntry);
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                int nRead;
                while ((nRead = fileInputStream.read(buffer, 0, buffer.length)) != -1) {
                    zipOut.write(buffer, 0, nRead);
                }
                added = true;
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Problem closing file input stream: " + e));
                }
            }
        }
        log.debug((Object)("SKIPPING " + zipEntryName));
        return added;
    }

    private static String getFileName(List<String> pathElements, File file) {
        StringBuffer sb = ZipUtil.getPath(pathElements);
        sb.append(file.getName());
        return sb.toString();
    }

    private static StringBuffer getPath(List<String> pathElements) {
        StringBuffer sb = new StringBuffer();
        for (String pathElement : pathElements) {
            sb.append(pathElement);
            sb.append("/");
        }
        return sb;
    }

    private static void addEntries(ZipOutputStream zipOut, Map<String, byte[]> entries) throws IOException {
        for (Map.Entry<String, byte[]> entry : entries.entrySet()) {
            String name = entry.getKey();
            byte[] data = entry.getValue();
            ZipEntry zipEntry = new ZipEntry(name);
            zipOut.putNextEntry(zipEntry);
            zipOut.write(data);
            zipOut.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] zip(List<FileEntry> fileList) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ZipOutputStream zipOut = new ZipOutputStream(byteArrayOutputStream);
        boolean added = false;
        try {
            if (fileList != null) {
                for (FileEntry entry : fileList) {
                    ZipEntry zipEntry = new ZipEntry(entry.getFileName());
                    log.trace((Object)("ZIPPING " + zipEntry));
                    zipOut.putNextEntry(zipEntry);
                    zipOut.write(entry.getData());
                    added = true;
                }
            }
        }
        finally {
            if (added) {
                zipOut.close();
            }
        }
        return byteArrayOutputStream.toByteArray();
    }
}

