/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.configservice;

import com.pingidentity.configservice.ConfigEventType;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractListenerRegistry {
    private static final Log log = LogFactory.getLog(AbstractListenerRegistry.class);
    private Map<ConfigEventType, List<ListenerInfo>> listenerInfosMap = new HashMap<ConfigEventType, List<ListenerInfo>>();

    protected synchronized <T> void doAddListener(ConfigEventType eventType, T listener, Consumer<T> callback) {
        List<ListenerInfo> listenerInfos = this.listenerInfosMap.get((Object)eventType);
        if (listenerInfos == null) {
            listenerInfos = new ArrayList<ListenerInfo>();
            this.listenerInfosMap.put(eventType, listenerInfos);
        }
        listenerInfos.add(new ListenerInfo<T>(listener, callback));
    }

    protected synchronized <T> void doRemoveListener(ConfigEventType eventType, T listener) {
        if (listener == null) {
            return;
        }
        List<ListenerInfo> listenerInfos = this.listenerInfosMap.get((Object)eventType);
        if (listenerInfos == null) {
            return;
        }
        listenerInfos.removeIf(info -> listener.equals(info.getListener()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> void doNotifyListeners(ConfigEventType eventType, Consumer<T> callbackOverride) {
        ArrayList<ListenerInfo> toNotify = new ArrayList<ListenerInfo>();
        AbstractListenerRegistry abstractListenerRegistry = this;
        synchronized (abstractListenerRegistry) {
            List<ListenerInfo> listenerInfos = this.listenerInfosMap.get((Object)eventType);
            if (listenerInfos == null) {
                return;
            }
            Iterator<ListenerInfo> iterator = listenerInfos.iterator();
            while (iterator.hasNext()) {
                ListenerInfo info = iterator.next();
                if (info.getListener() == null) {
                    iterator.remove();
                    continue;
                }
                toNotify.add(info);
            }
        }
        for (ListenerInfo info : toNotify) {
            Consumer callback;
            Object listener = info.getListener();
            if (listener == null) continue;
            Consumer consumer = callback = callbackOverride != null ? callbackOverride : info.callback;
            if (callback == null) {
                throw new IllegalStateException("callbackOverride is null and no callback was registered with the listener");
            }
            try {
                callback.accept(listener);
            }
            catch (Throwable t) {
                log.error((Object)"Unexpected error thrown by listener", t);
            }
        }
    }

    private static class ListenerInfo<T> {
        private WeakReference<T> listenerRef;
        private Consumer<T> callback;

        public ListenerInfo(T listener, Consumer<T> callback) {
            this.listenerRef = new WeakReference<T>(listener);
            this.callback = callback;
        }

        public T getListener() {
            return this.listenerRef.get();
        }

        public Consumer<T> getCallback() {
            return this.callback;
        }
    }
}

