/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.configservice;

import com.pingidentity.configservice.ConfigUpdateType;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;

public class ConfigUpdateCoordinator {
    private static final Log log = LogFactory.getLog(ConfigUpdateCoordinator.class);
    private static final String REQUESTS_IN_FLIGHT_TIMEOUT_MILLIS = "RequestsInFlightTimeoutMillis";
    private static final List<String> ALLOWED_ENDPOINTS_DURING_CONFIG_UPDATE = Arrays.asList("/pf/heartbeat.ping");
    private static ConfigUpdateCoordinator instance = new ConfigUpdateCoordinator();
    private ConfigStore coordConfig = ConfigStoreFarm.getConfig("com.pingidentity.configservice.ConfigUpdateCoordinator");
    private ConfigStore enforcerConfig = ConfigStoreFarm.getConfig("org.sourceid.websso.servlet.EnforcerServletBase");
    private boolean updateInProgress = false;
    private boolean queueRequests = false;
    private int requestsInFlight = 0;

    private ConfigUpdateCoordinator() {
    }

    public static ConfigUpdateCoordinator getInstance() {
        return instance;
    }

    public synchronized void incrementRequestsInFlight(HttpServletRequest req) {
        if (!this.isRequestQueueable(req)) {
            return;
        }
        if (this.queueRequests) {
            this.waitUntilUpdateComplete();
        }
        ++this.requestsInFlight;
    }

    public synchronized void decrementRequestsInFlight(HttpServletRequest req) {
        if (!this.isRequestQueueable(req)) {
            return;
        }
        --this.requestsInFlight;
        this.notifyAll();
    }

    public synchronized void setUpdateInProgress(ConfigUpdateType updateType) {
        if (this.updateInProgress) {
            this.waitUntilUpdateComplete();
        }
        this.updateInProgress = true;
        this.queueRequests = this.isQueueRequestsDuringConfigUpdate(updateType);
        if (this.queueRequests) {
            log.debug((Object)"Pausing runtime request threads");
        }
        if (this.queueRequests && this.requestsInFlight > 0) {
            log.info((Object)("Waiting for " + this.requestsInFlight + " in-progress requests to complete before starting configuration update..."));
            long currentTime = System.currentTimeMillis();
            long timeout = currentTime + this.getRequestsInFlightTimeoutMillis();
            while (this.requestsInFlight > 0 && currentTime < timeout) {
                try {
                    this.wait(timeout - currentTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                currentTime = System.currentTimeMillis();
            }
            if (this.requestsInFlight > 0) {
                log.info((Object)("Timed out while waiting for " + this.requestsInFlight + " in-progress requests to complete before starting configuration update. Proceeding with update."));
            }
        }
        log.info((Object)"Configuration update is in progress...");
    }

    public synchronized void clearUpdateInProgress() {
        this.updateInProgress = false;
        this.queueRequests = false;
        log.info((Object)"Configuration update has finished or was terminated.");
        this.notifyAll();
    }

    private void waitUntilUpdateComplete() {
        boolean waitRequired = false;
        if (this.updateInProgress) {
            waitRequired = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Waiting for configuration update to complete");
            }
        }
        while (this.updateInProgress) {
            try {
                this.wait(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (waitRequired && log.isDebugEnabled()) {
            log.debug((Object)"Finished waiting for configuration update to complete");
        }
    }

    private boolean isRequestQueueable(HttpServletRequest request) {
        if (!this.enforcerConfig.getBooleanValue("AllowHeartbeatDuringConfigUpdate", false)) {
            return true;
        }
        return !ALLOWED_ENDPOINTS_DURING_CONFIG_UPDATE.contains(request.getServletPath());
    }

    private boolean isQueueRequestsDuringConfigUpdate(ConfigUpdateType updateType) {
        if (updateType == ConfigUpdateType.HSM_RECONNECT || updateType == ConfigUpdateType.FULL_CONFIG_RELOAD) {
            return true;
        }
        return this.coordConfig.getBooleanValue("QueueRequestsDuringConfigUpdate", false);
    }

    private long getRequestsInFlightTimeoutMillis() {
        return this.coordConfig.getLongValue(REQUESTS_IN_FLIGHT_TIMEOUT_MILLIS, 1000L);
    }
}

