/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.configservice.impl;

import com.pingidentity.configservice.impl.ConfigStoreImpl;
import com.pingidentity.hivemind.AutoReloadableServiceFactory;
import com.pingidentity.hivemind.AutoReloadableServiceProxy;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFactory;
import org.sourceid.config.ConfigStoreLocation;

public class ConfigStoreFactoryImpl
implements ConfigStoreFactory {
    private static final Log log = LogFactory.getLog(ConfigStoreFactoryImpl.class);
    private Map<ConfigStoreLocation, Map<String, ConfigStore>> locationStores = new HashMap<ConfigStoreLocation, Map<String, ConfigStore>>();

    @Override
    public synchronized ConfigStore getConfig(ConfigStoreLocation location, String name) {
        Map<String, ConfigStore> stores = this.getStores(location);
        ConfigStore configStore = stores.get(name);
        if (configStore == null) {
            AutoReloadableServiceProxy proxy = new AutoReloadableServiceProxy(new ConfigStoreServiceFactory(location, name));
            configStore = (ConfigStore)proxy.createDynamicProxy();
            stores.put(name, configStore);
        }
        return configStore;
    }

    private Map<String, ConfigStore> getStores(ConfigStoreLocation location) {
        Map<String, ConfigStore> stores = this.locationStores.get((Object)location);
        if (stores == null) {
            stores = new HashMap<String, ConfigStore>();
            this.locationStores.put(location, stores);
        }
        return stores;
    }

    private static class ConfigStoreServiceFactory
    implements AutoReloadableServiceFactory {
        private final ConfigStoreLocation location;
        private final String storeName;
        private final String serviceId;

        public ConfigStoreServiceFactory(ConfigStoreLocation location, String storeName) {
            this.location = location;
            this.storeName = storeName;
            this.serviceId = "ConfigStore:" + location.name() + ":" + storeName;
        }

        @Override
        public String getServiceId() {
            return this.serviceId;
        }

        @Override
        public Object createServiceImplementation() {
            return new ConfigStoreImpl(this.location, this.storeName);
        }

        @Override
        public Class<?> getServiceInterface() {
            return ConfigStore.class;
        }
    }
}

