/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.configservice.impl;

import com.pingidentity.configservice.impl.ConfigStoreImpl;
import com.pingidentity.configservice.impl.ConfigStoreRegistry;
import com.pingidentity.configservice.impl.ConfigStoreRegistryEntry;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigStoreMBean
implements DynamicMBean {
    private String dClassName = this.getClass().getName();
    private String dDescription = "ConfigStore MBean";
    private MBeanAttributeInfo[] dAttributes = null;
    private MBeanConstructorInfo[] dConstructors = new MBeanConstructorInfo[1];
    private MBeanNotificationInfo[] dNotifications = new MBeanNotificationInfo[0];
    private MBeanOperationInfo[] dOperations = new MBeanOperationInfo[0];
    private MBeanInfo dMBeanInfo = null;
    private ConfigStoreRegistry configRegistry = ConfigStoreRegistry.getInstance();
    private Log log = LogFactory.getLog(this.getClass());

    @Override
    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Object retV = null;
        if (attributeName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke a getter of " + this.dClassName + " with null attribute name");
        }
        ConfigStoreRegistryEntry entry = this.configRegistry.getEntry(attributeName);
        if (entry != null) {
            retV = entry.getValue();
        }
        return retV;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Cannot invoke a setter of " + this.dClassName + " with null attribute");
        }
        this.log.debug((Object)("set " + attribute.getName() + " to " + attribute.getValue()));
        String name = attribute.getName();
        Object value = attribute.getValue();
        ConfigStoreRegistryEntry entry = this.configRegistry.getEntry(name);
        entry.setValue(value);
        ConfigStoreImpl storeInstance = (ConfigStoreImpl)entry.getStoreInstance();
        if (entry.getCategory() == ConfigStoreRegistryEntry.VALUE_CATEGORY.ATOM) {
            if (value instanceof String) {
                storeInstance.setStringValue(entry.getItemName(), (String)value);
            } else if (value instanceof Boolean) {
                storeInstance.setBooleanValue(entry.getItemName(), (Boolean)value);
            } else if (value instanceof Integer) {
                storeInstance.setIntValue(entry.getItemName(), (Integer)value);
            }
        } else if (entry.getCategory() == ConfigStoreRegistryEntry.VALUE_CATEGORY.MAP) {
            Map<String, Object> updatedMap = this.getUpdatedMap(entry);
            storeInstance.setMapValue(entry.getMapName(), updatedMap);
        } else if (entry.getCategory() == ConfigStoreRegistryEntry.VALUE_CATEGORY.LIST) {
            // empty if block
        }
    }

    private Map<String, Object> getUpdatedMap(ConfigStoreRegistryEntry entry) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        String keyPrefix = entry.getMapUriPrefix();
        List<String> keys = this.configRegistry.getKeyList();
        for (String key : keys) {
            if (!key.startsWith(keyPrefix)) continue;
            ConfigStoreRegistryEntry tmpEntry = this.configRegistry.getEntry(key);
            newMap.put(tmpEntry.getItemName(), tmpEntry.getValue());
        }
        return newMap;
    }

    @Override
    public AttributeList getAttributes(String[] attributeNames) {
        AttributeList resultList = new AttributeList();
        if (attributeNames != null && attributeNames.length != 0) {
            for (int i = 0; i < attributeNames.length; ++i) {
                try {
                    Object value = this.getAttribute(attributeNames[i]);
                    resultList.add(new Attribute(attributeNames[i], value));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return resultList;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return null;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        this.buildDynamicMBeanInfo();
        return this.dMBeanInfo;
    }

    private void buildDynamicMBeanInfo() {
        List<String> keyList = this.configRegistry.getKeyList();
        this.dAttributes = new MBeanAttributeInfo[keyList.size()];
        int i = 0;
        for (String key : keyList) {
            ConfigStoreRegistryEntry entry = this.configRegistry.getEntry(key);
            Object value = entry.getValue();
            String valueType = "java.lang.String";
            if (value instanceof Boolean) {
                valueType = "java.lang.Boolean";
            } else if (value instanceof Integer) {
                valueType = "java.lang.Integer";
            }
            this.dAttributes[i++] = new MBeanAttributeInfo(entry.getURI(), valueType, "No description", true, true, false);
        }
        Constructor<?>[] constructors = this.getClass().getConstructors();
        this.dConstructors[0] = new MBeanConstructorInfo("Constructs a SimpleDynamic object", constructors[0]);
        this.dMBeanInfo = new MBeanInfo(this.dClassName, this.dDescription, this.dAttributes, this.dConstructors, this.dOperations, this.dNotifications);
    }
}

