/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.configservice.impl;

public class ConfigStoreRegistryEntry {
    public static final String SEPARATOR = " : ";
    private Object storeInstance = null;
    private String configFileName = null;
    private VALUE_CATEGORY category = VALUE_CATEGORY.ATOM;
    private String mapName = null;
    private String itemName = null;
    private Object value = null;

    public ConfigStoreRegistryEntry(Object storeInstance, String configFileName, String itemName, Object value) {
        this.storeInstance = storeInstance;
        this.itemName = itemName;
        this.configFileName = configFileName;
        this.value = value;
        this.category = VALUE_CATEGORY.ATOM;
    }

    public ConfigStoreRegistryEntry(Object storeInstance, String configFileName, VALUE_CATEGORY category, String keyName, String itemName, Object value) {
        this.storeInstance = storeInstance;
        this.itemName = itemName;
        this.configFileName = configFileName;
        this.value = value;
        this.category = category;
        if (category == VALUE_CATEGORY.MAP) {
            this.mapName = keyName;
        } else if (category == VALUE_CATEGORY.LIST) {
            // empty if block
        }
    }

    public String getConfigFileName() {
        return this.configFileName;
    }

    public void setConfigFileName(String className) {
        this.configFileName = className;
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String keyName) {
        this.itemName = keyName;
    }

    public Object getStoreInstance() {
        return this.storeInstance;
    }

    public void setStoreInstance(Object storeInstance) {
        this.storeInstance = storeInstance;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public VALUE_CATEGORY getCategory() {
        return this.category;
    }

    public void setCategory(VALUE_CATEGORY category) {
        this.category = category;
    }

    public String getMapName() {
        return this.mapName;
    }

    public void setMapName(String mapName) {
        this.mapName = mapName;
    }

    public String getURI() {
        Object retV = null;
        if (this.configFileName != null) {
            retV = this.configFileName;
            if (this.category == VALUE_CATEGORY.MAP) {
                retV = (String)retV + SEPARATOR + this.mapName;
            }
            retV = (String)retV + SEPARATOR + this.itemName;
        }
        return retV;
    }

    public String getMapUriPrefix() {
        String retV = null;
        if (this.configFileName != null) {
            retV = ConfigStoreRegistryEntry.makeMapUriPrefix(this.configFileName, this.mapName);
        }
        return retV;
    }

    public static String makeMapUriPrefix(String filename, String mapName) {
        return filename + SEPARATOR + mapName + SEPARATOR;
    }

    public String toString() {
        return this.getURI() + " \t" + this.value;
    }

    public static enum VALUE_CATEGORY {
        ATOM,
        MAP,
        LIST;

    }
}

