/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.configservice.impl;

import com.pingidentity.common.util.DiffUtil;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class JaxbXmlLoader<ConfigType> {
    private Class<ConfigType> configClass;

    public JaxbXmlLoader(Class<ConfigType> configClass) {
        this.configClass = configClass;
    }

    public void save(String directory, String fileName, ConfigType obj) throws JAXBException {
        File file = new File(directory + File.separator + fileName);
        List<String> origXml = DiffUtil.fileToLines(directory, fileName);
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{this.configClass});
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        jaxbMarshaller.marshal(obj, file);
        List<String> savedXml = DiffUtil.fileToLines(directory, fileName);
        DiffUtil.generateDiff(fileName, origXml, savedXml);
    }

    public ConfigType load(String directory, String fileName) throws JAXBException, ParserConfigurationException, SAXException, IOException {
        return this.load(directory, fileName, false);
    }

    public ConfigType load(String directory, String fileName, boolean strictValidation) throws JAXBException, ParserConfigurationException, SAXException, IOException {
        DocumentBuilder db = XmlBeansUtil.getDocumentBuilder();
        File file = new File(directory + File.separator + fileName);
        Document document = db.parse(file);
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{this.configClass});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        jaxbUnmarshaller.setEventHandler(event -> !strictValidation);
        return (ConfigType)jaxbUnmarshaller.unmarshal((Node)document);
    }
}

