/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.configservice.impl;

import com.pingidentity.configservice.SysDirInfo;
import java.io.File;
import java.nio.file.Paths;
import org.apache.commons.lang.StringUtils;

public class JbossSysDirInfo
implements SysDirInfo {
    private static final String rootDir = JbossSysDirInfo.getAbsolutePath(System.getProperty("pf.server.default.dir"), "..", "..");
    private static final String homeDir = JbossSysDirInfo.getAbsolutePath(System.getProperty("pf.server.default.dir", "jboss"));
    private static final String dataDir = JbossSysDirInfo.getAbsolutePath(System.getProperty("pf.server.data.dir", homeDir + File.separator + "data"));
    private static final String tmpDir = JbossSysDirInfo.getAbsolutePath(System.getProperty("jboss.server.temp.dir", homeDir + File.separator + "temp"));
    private static final String binDir = JbossSysDirInfo.getAbsolutePath(System.getProperty("pf.server.default.dir"), "..", "..", "bin");
    private static final String localDataDir;
    private static final String instanceDataDir;
    private static final String replicationDir;
    private static final String deployDir;
    private static final String libDir;
    private static final String confDir;
    private static final String dataDefaultZipDir;
    private static final String templateDir;
    private static final String assetsDir;
    private static final String imagesDir;
    private static final String connectionTemplateDir;
    private static final String ldapTemplateDir;
    private static final String configStoreDir;
    private static final String moduleDir;
    private static final String archiveDir;
    private static final String connectionDeployerDir;
    private static final String dropInDeployerDir;
    private static final String languagePacksDir;
    private static final String upgradeDir;
    private static final String referenceFilesDir;

    private static String getAbsolutePath(String ... paths) {
        String path = StringUtils.join((Object[])paths, (String)File.separator);
        return Paths.get(path, new String[0]).normalize().toAbsolutePath().normalize().toFile().getAbsolutePath();
    }

    @Override
    public String getRootDir() {
        return rootDir;
    }

    @Override
    public String getHomeDirectory() {
        return homeDir;
    }

    @Override
    public String getDataDirectory() {
        return dataDir;
    }

    @Override
    public String getDeployDirectory() {
        return deployDir;
    }

    @Override
    public String getLibDirectory() {
        return libDir;
    }

    @Override
    public String getLocalDataDirectory() {
        return localDataDir;
    }

    @Override
    public String getInstanceDataDirectory() {
        return instanceDataDir;
    }

    @Override
    public String getDataDefaultZipDirectory() {
        return dataDefaultZipDir;
    }

    @Override
    public String getReplicationDirectory() {
        return replicationDir;
    }

    @Override
    public String getConfigDirectory() {
        return confDir;
    }

    @Override
    public String getTmpDirectory() {
        return tmpDir;
    }

    @Override
    public String getBinDirectory() {
        return binDir;
    }

    @Override
    public String getTemplateDirectory() {
        return templateDir;
    }

    @Override
    public String getAssetsDir() {
        return assetsDir;
    }

    @Override
    public String getImagesDir() {
        return imagesDir;
    }

    @Override
    public String getConnectionTemplateDirectory() {
        return connectionTemplateDir;
    }

    @Override
    public String getLdapTemplateDirectory() {
        return ldapTemplateDir;
    }

    @Override
    public String getConfigStoreDir() {
        return configStoreDir;
    }

    @Override
    public String getModuleDir() {
        return moduleDir;
    }

    @Override
    public String getArchiveDir() {
        return archiveDir;
    }

    @Override
    public String getConnectionDeployerDir() {
        return connectionDeployerDir;
    }

    @Override
    public String getDropInDeployerDir() {
        return dropInDeployerDir;
    }

    @Override
    public String getLanguagePacksDir() {
        return languagePacksDir;
    }

    @Override
    public String getUpgradeDir() {
        return upgradeDir;
    }

    @Override
    public String getUpgradeReferenceFilesDir() {
        return referenceFilesDir;
    }

    static {
        deployDir = JbossSysDirInfo.getAbsolutePath(homeDir, "deploy");
        libDir = JbossSysDirInfo.getAbsolutePath(homeDir, "lib");
        confDir = JbossSysDirInfo.getAbsolutePath(homeDir, "conf");
        dataDefaultZipDir = JbossSysDirInfo.getAbsolutePath(confDir, "data-default");
        templateDir = JbossSysDirInfo.getAbsolutePath(confDir, "template");
        assetsDir = JbossSysDirInfo.getAbsolutePath(templateDir, "assets");
        imagesDir = JbossSysDirInfo.getAbsolutePath(assetsDir, "images");
        connectionTemplateDir = JbossSysDirInfo.getAbsolutePath(templateDir, "connections");
        ldapTemplateDir = JbossSysDirInfo.getAbsolutePath(templateDir, "ldap-templates");
        configStoreDir = JbossSysDirInfo.getAbsolutePath(dataDir, "config-store");
        localDataDir = JbossSysDirInfo.getAbsolutePath(dataDir, "local");
        instanceDataDir = JbossSysDirInfo.getAbsolutePath(dataDir, "instance");
        replicationDir = JbossSysDirInfo.getAbsolutePath(dataDir, "replication");
        moduleDir = JbossSysDirInfo.getAbsolutePath(dataDir, "module");
        archiveDir = JbossSysDirInfo.getAbsolutePath(dataDir, "archive");
        connectionDeployerDir = JbossSysDirInfo.getAbsolutePath(dataDir, "connection-deployer");
        dropInDeployerDir = JbossSysDirInfo.getAbsolutePath(dataDir, "drop-in-deployer");
        languagePacksDir = JbossSysDirInfo.getAbsolutePath(confDir, "language-packs");
        upgradeDir = JbossSysDirInfo.getAbsolutePath(rootDir, "upgrade");
        referenceFilesDir = JbossSysDirInfo.getAbsolutePath(upgradeDir, "reference-files");
    }
}

