/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.configservice.impl;

import com.pingidentity.common.util.DiffUtil;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.configservice.StreamLoader;
import com.pingidentity.configservice.impl.AbstractXmlLoader;
import com.pingidentity.pingcommons.util.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.sourceid.config.ConfigurationException;
import org.w3c.dom.Node;

public class StreamXmlLoader
extends AbstractXmlLoader {
    private StreamLoader loader;

    public void setStreamLoader(StreamLoader loader) {
        this.loader = loader;
    }

    @Override
    public boolean xmlExists(String directory, String filename) {
        return this.loader.streamExists(new File(directory, filename));
    }

    @Override
    public XmlObject loadRawXml(String directory, String filename) {
        InputStream s = this.loader.getInputStream(directory, filename);
        try {
            Node node = XmlBeansUtil.parseToNode(s);
            XmlObject xmlObject = XmlObject.Factory.parse((Node)node);
            return xmlObject;
        }
        catch (XmlException e) {
            throw new ConfigurationException("Error parsing configuration stream: " + directory + ", " + filename, e);
        }
        finally {
            Closer.close((Closeable)s);
        }
    }

    @Override
    public void saveRawXml(String directory, String filename, XmlObject doc, XmlOptions opts) {
        List<String> origXml = DiffUtil.fileToLines(directory, filename);
        OutputStream s = this.loader.getOutputStream(directory, filename);
        try {
            if (doc != null) {
                doc.save(s, opts);
                List<String> savedXml = DiffUtil.fileToLines(directory, filename);
                DiffUtil.generateDiff(filename, origXml, savedXml);
            } else {
                s.flush();
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("Error writing configuration stream: " + directory + ", " + filename, e);
        }
        finally {
            Closer.close((Closeable)s);
        }
    }

    @Override
    public XmlObject load(InputStream inStream) {
        try {
            return XmlObject.Factory.parse((InputStream)inStream);
        }
        catch (XmlException e) {
            throw new ConfigurationException("Error parsing input metadata: ", e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading input metadata: ", e);
        }
    }

    @Override
    public boolean delete(String directory, String filename) {
        List<String> origXml = DiffUtil.fileToLines(directory, filename);
        DiffUtil.generateDiff(filename, origXml, new ArrayList<String>());
        return new File(directory + File.separator + filename).delete();
    }
}

