/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.configservice.impl;

import com.pingidentity.configservice.impl.AbstractXmlLoader;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.sourceid.config.ConfigurationException;

public class StringMapXmlLoader
extends AbstractXmlLoader {
    Map<String, String> data = new HashMap<String, String>();

    @Override
    public boolean xmlExists(String directory, String filename) {
        return this.data.containsKey(this.getKey(directory, filename));
    }

    @Override
    public XmlObject loadRawXml(String directory, String filename) {
        String key = this.getKey(directory, filename);
        if (this.data.containsKey(key)) {
            try {
                String xml = this.data.get(key);
                return XmlObject.Factory.parse((String)xml);
            }
            catch (XmlException e) {
                throw new ConfigurationException("Error parsing configuration file: " + key, e);
            }
        }
        throw new ConfigurationException("File does not exist: " + key);
    }

    @Override
    public void saveRawXml(String directory, String filename, XmlObject doc, XmlOptions opts) {
        String key = this.getKey(directory, filename);
        if (doc != null) {
            this.data.put(key, doc.xmlText(opts));
        } else {
            this.data.remove(key);
        }
    }

    @Override
    public XmlObject load(InputStream inStream) {
        return null;
    }

    private String getKey(String directory, String filename) {
        return directory + File.separator + filename;
    }

    @Override
    public boolean delete(String directory, String filename) {
        return false;
    }

    public String getContent(String directory, String filename) {
        return this.data.get(this.getKey(directory, filename));
    }

    public void setContent(String dir, String filename, String content) {
        this.data.put(this.getKey(dir, filename), content);
    }
}

