/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.pingcommons.crypto.B64;
import com.pingidentity.pingcommons.crypto.HashAlgorithm;
import com.pingidentity.pingcommons.crypto.HashUtil;
import com.pingidentity.pingcommons.util.Closer;
import com.pingidentity.pingcommons.util.NumberUtils;
import com.pingidentity.sdk.internal.interfaces.CertWrapper;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Cert
implements Serializable,
CertWrapper {
    private static final Log log = LogFactory.getLog(Cert.class);
    private static final long serialVersionUID = 20050515L;
    public static final String X509_TYPE = "X.509";
    public static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    private static final String CERT_EXP_DATE_DISPLAY_FORMAT = "MMM dd, yyyy";
    public static Comparator<Cert> COMPARE_BY_SERIAL = Comparator.comparing(cert -> cert.getX509Certificate().getSerialNumber());
    public static Comparator<Cert> COMPARE_BY_EXPIRATION_DATE = Comparator.comparing(cert -> cert.getX509Certificate().getNotAfter());
    public static Comparator<Cert> COMPARE_BY_SUBJECT_DN = (cert1, cert2) -> {
        Principal subjectDN1 = cert1.getX509Certificate().getSubjectDN();
        Principal subjectDN2 = cert2.getX509Certificate().getSubjectDN();
        return subjectDN1.toString().compareToIgnoreCase(subjectDN2.toString());
    };
    public static Comparator<Cert> COMPARE_BY_ID = (cert1, cert2) -> {
        if (cert1.id != null) {
            return cert1.id.compareTo(cert2.id);
        }
        return cert2.id != null ? -1 : 0;
    };
    protected String id;
    protected X509Certificate[] x509Certificates;
    private Boolean storedOnHSM;

    public Cert(Cert copy) {
        this.id = copy.getId();
        this.x509Certificates = copy.getChain() != null ? (X509Certificate[])copy.getChain().clone() : null;
        this.storedOnHSM = copy.storedOnHSM;
    }

    protected Cert(X509Certificate x509) {
        this(null, x509);
    }

    protected Cert(X509Certificate[] certificates) {
        this(null, certificates);
    }

    public Cert(String id, X509Certificate x509Certificate) {
        this(id, new X509Certificate[]{x509Certificate});
    }

    public Cert(String id, X509Certificate[] certificates) {
        this.id = id;
        this.x509Certificates = certificates;
    }

    public static Cert importCert(byte[] bytes) throws CertificateException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        return Cert.importCert(inputStream, false);
    }

    public static Cert importCert(String pemCert) throws CertificateException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pemCert.getBytes(StandardCharsets.UTF_8));
        return Cert.importCert(inputStream, false);
    }

    public static Cert importCert(InputStream certStream) throws CertificateException {
        return Cert.importCert(certStream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cert importCert(InputStream certStream, boolean checkValidity) throws CertificateException {
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance(X509_TYPE);
            Collection<? extends Certificate> collection = certFactory.generateCertificates(certStream);
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
            for (Certificate certificate : collection) {
                if (certificate instanceof X509Certificate) {
                    certs.add((X509Certificate)certificate);
                    continue;
                }
                log.debug((Object)"Not an X509Certificate instance");
            }
            if (certs.isEmpty()) {
                throw new CertificateException("Could not find a valid certificate.");
            }
            if (checkValidity) {
                ((X509Certificate)certs.get(0)).checkValidity();
            }
            Cert cert = new Cert((X509Certificate)certs.get(0));
            return cert;
        }
        finally {
            Closer.close((Closeable)certStream);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAlias() {
        return this.id;
    }

    public void setAlias(String alias) {
        this.id = alias;
    }

    public X509Certificate getX509Certificate() {
        return this.x509Certificates[0];
    }

    public X509Certificate[] getChain() {
        return this.x509Certificates;
    }

    public List<String> getX509CertificateSubjectAlternativeNames() throws CertificateParsingException {
        Collection<List<?>> subjectAlternativeNames = this.getX509Certificate().getSubjectAlternativeNames();
        if (subjectAlternativeNames != null) {
            ArrayList<String> names = new ArrayList<String>();
            for (List<?> name : subjectAlternativeNames) {
                names.add(name.get(1).toString());
            }
            Collections.sort(names);
            return names;
        }
        return Collections.emptyList();
    }

    private PublicKey getPublicKey() {
        return this.getX509Certificate().getPublicKey();
    }

    public String getPublicKeyAlgorithm() {
        return this.getPublicKey().getAlgorithm();
    }

    public Integer getPublicKeySize() {
        PublicKey publicKey = this.getPublicKey();
        if (publicKey instanceof RSAPublicKey) {
            return ((RSAPublicKey)publicKey).getModulus().bitLength();
        }
        if (publicKey instanceof DSAPublicKey) {
            return ((DSAPublicKey)publicKey).getParams().getP().bitLength();
        }
        if (publicKey instanceof ECPublicKey) {
            return ((ECPublicKey)publicKey).getParams().getCurve().getField().getFieldSize();
        }
        return null;
    }

    public byte[] getEncoded() {
        try {
            return this.getX509Certificate().getEncoded();
        }
        catch (CertificateEncodingException e) {
            log.error((Object)"Problem getting encoded certificate. ", (Throwable)e);
            return new byte[0];
        }
    }

    public String getFingerPrint(HashAlgorithm algo) {
        return HashUtil.hashToHexString((byte[])this.getEncoded(), (HashAlgorithm)algo);
    }

    public String getBase64FingerPrint(HashAlgorithm algo) {
        return B64.encode((byte[])HashUtil.hashToBytes((byte[])this.getEncoded(), (HashAlgorithm)algo));
    }

    public String getSerialNumberForDisplay() {
        return NumberUtils.createHexStringForDisplay((BigInteger)this.getX509Certificate().getSerialNumber());
    }

    public String getExpiryDateForDisplay() {
        return new SimpleDateFormat(CERT_EXP_DATE_DISPLAY_FORMAT).format(this.getX509Certificate().getNotAfter());
    }

    public String getSerialNumberAsHex() {
        return NumberUtils.createHexString((BigInteger)this.getX509Certificate().getSerialNumber());
    }

    public String getDescriptionForDisplay() {
        return this.getDescriptionForDisplay(Integer.MAX_VALUE);
    }

    public String getDescriptionForDisplay(int maximumSubjectDNLength) {
        String expDate = this.getExpiryDateForDisplay();
        String subjectDN = this.getX509Certificate().getSubjectDN().toString();
        String serialNumber = this.getSerialNumberForDisplay();
        if (subjectDN.length() <= maximumSubjectDNLength) {
            return String.format("%s (%s | Exp: %s)", subjectDN, serialNumber, expDate);
        }
        return String.format("%s... (%s | Exp: %s)", subjectDN.substring(0, maximumSubjectDNLength), serialNumber, expDate);
    }

    public String exportCert() throws CertificateEncodingException {
        StringWriter buff = new StringWriter();
        PrintWriter out = new PrintWriter(buff);
        byte[] derCert = this.getX509Certificate().getEncoded();
        String pemCert = new String(Base64.encodeBase64((byte[])derCert, (boolean)true), StandardCharsets.UTF_8);
        pemCert = pemCert.replace("\r\n", "\n");
        out.print("-----BEGIN CERTIFICATE-----\n");
        out.print(pemCert);
        out.print("-----END CERTIFICATE-----\n");
        out.close();
        return buff.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Cert) || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        return this.getX509Certificate().equals(((Cert)obj).getX509Certificate());
    }

    public int hashCode() {
        return this.getX509Certificate().hashCode();
    }

    public Boolean isStoredOnHSM() {
        return this.storedOnHSM;
    }

    public void setStoredOnHSM(Boolean storedOnHSM) {
        this.storedOnHSM = storedOnHSM;
    }

    public String toString() {
        X509Certificate x509 = this.getX509Certificate();
        return this.getClass().getSimpleName() + "[" + x509.getSubjectDN().toString() + " (" + this.getSerialNumberForDisplay() + ")]";
    }
}

