/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.google.common.collect.Maps;
import com.pingidentity.crypto.KeyAlgorithmInfo;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.ECParameterSpec;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500PrivateCredential;

public interface CertificateGenerator {
    public List<String> getSupportedSubjectAlternativeNameTypes();

    public boolean isValidSubjectAlternativeNameTypeValuePair(String var1, String var2);

    public Map<String, String> resolveSubjectAlternativeNameTypeFromValues(List<String> var1) throws IOException;

    public int getMaxValidDays();

    public Collection<String> getAvailableKeyAlgorithms();

    public KeyAlgorithmInfo getKeyAlgorithmInfo(String var1);

    public Map<String, KeyAlgorithmInfo> getKeyAlgorithmInfos();

    public KeyPair generateLocalRsaKeyPair(int var1) throws NoSuchAlgorithmException, NoSuchProviderException;

    public KeyPair generateLocalEcKeyPair(ECParameterSpec var1) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, NoSuchProviderException;

    public boolean isLocalEcKeyPairGenerationAvailable();

    public X500PrivateCredential createSelfSignedCertAndPrivateKey(String var1, String var2, String var3, String var4, String var5, String var6, int var7, String var8, int var9) throws GeneralSecurityException, IOException;

    public X500PrivateCredential createSelfSignedCertAndPrivateKey(String var1, String var2, String var3, String var4, String var5, String var6, int var7, String var8, int var9, String var10, Date var11) throws GeneralSecurityException, IOException;

    public X500PrivateCredential createSelfSignedCertAndPrivateKey(String var1, String var2, String var3, String var4, String var5, String var6, int var7, String var8, int var9, String var10, Date var11, Boolean var12) throws GeneralSecurityException, IOException;

    public X500PrivateCredential createSelfSignedCertAndPrivateKey(String var1, String var2, String var3, String var4, String var5, String var6, String var7, int var8, String var9, int var10, String var11, Date var12, Boolean var13, Map<String, String> var14, CertificateType var15) throws GeneralSecurityException, IOException;

    public X509Certificate createSelfSignedCert(String var1, String var2, String var3, String var4, String var5, String var6, int var7, KeyPair var8) throws GeneralSecurityException, IOException;

    public X509Certificate createSelfSignedCert(String var1, String var2, String var3, String var4, String var5, String var6, int var7, KeyPair var8, String var9, Date var10) throws GeneralSecurityException, IOException;

    public X509Certificate createSelfSignedCert(String var1, String var2, String var3, String var4, String var5, String var6, int var7, KeyPair var8, String var9, Date var10, Boolean var11) throws GeneralSecurityException, IOException;

    public X509Certificate createSelfSignedCert(String var1, String var2, String var3, String var4, String var5, String var6, int var7, KeyPair var8, String var9, Date var10, Boolean var11, Map<String, String> var12, CertificateType var13) throws GeneralSecurityException, IOException;

    public String encodeCSR(PrivateKey var1, X509Certificate var2, Boolean var3) throws GeneralSecurityException, IOException;

    public X509Certificate[] decodeCSRReply(InputStream var1, Collection<X509Certificate> var2) throws GeneralSecurityException;

    public Set<X509Certificate> getJavaTrustedCaCerts() throws GeneralSecurityException, IOException;

    public KeyStore getCacertsKeystore() throws KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException, IOException;

    public static enum CertificateType {
        dsigSigningCert,
        sslCertAuth,
        sslServerCerts,
        generalCerts;

        private static final Map<String, CertificateType> nameIndex;

        public static CertificateType lookupByName(String name) {
            return nameIndex.get(name);
        }

        static {
            nameIndex = Maps.newHashMapWithExpectedSize((int)CertificateType.values().length);
            for (CertificateType type : CertificateType.values()) {
                nameIndex.put(type.name(), type);
            }
        }
    }
}

