/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.common.util.Base64URL;
import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.CertificateValidity;
import com.pingidentity.crypto.RevocationChecker;
import com.pingidentity.crypto.RevokedCertException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.HashAlgorithm;
import org.sourceid.common.HashUtil;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class CertificateHelper {
    private static final Log log = LogFactory.getLog(CertificateHelper.class);

    private CertificateHelper() {
        throw new IllegalStateException("CertificateHelper class");
    }

    public static boolean isKnownToBeRevoked(Cert cert) {
        try {
            CertificateHelper.getRevocationChecker().check(cert.getChain());
            return false;
        }
        catch (RevokedCertException e) {
            return true;
        }
    }

    public static void checkRevocation(Cert cert) throws RevokedCertException {
        CertificateHelper.getRevocationChecker().check(cert.getChain());
    }

    public static boolean isSelfSigned(X509Certificate cert) {
        boolean selfSigned = false;
        if (cert != null && cert.getSubjectDN().equals(cert.getIssuerDN())) {
            selfSigned = true;
        }
        return selfSigned;
    }

    public static boolean isImportedCA(X509Certificate cert) {
        boolean retV = false;
        Set<X509Certificate> trustedCaSet = MgmtFactory.getTrustedCAsManager().getTrustedCaX509s();
        if (trustedCaSet.contains(cert)) {
            retV = true;
        }
        return retV;
    }

    public static String calculateThumb(X509Certificate cert) {
        if (cert == null) {
            return null;
        }
        try {
            return Base64URL.encodeToString((byte[])HashUtil.hashToBytes((byte[])cert.getEncoded(), (HashAlgorithm)HashAlgorithm.SHA1));
        }
        catch (Exception e) {
            log.warn((Object)("Unexpected problem getting " + HashAlgorithm.SHA1 + " thumbprint for  " + cert), (Throwable)e);
            return null;
        }
    }

    public static CertificateValidity getValidity(Cert cert) {
        try {
            cert.getX509Certificate().checkValidity();
            if (CertificateHelper.isKnownToBeRevoked(cert)) {
                return CertificateValidity.REVOKED;
            }
            return CertificateValidity.VALID;
        }
        catch (CertificateExpiredException e) {
            return CertificateValidity.EXPIRED;
        }
        catch (CertificateNotYetValidException e) {
            return CertificateValidity.NOT_YET_VALID;
        }
    }

    private static RevocationChecker getRevocationChecker() {
        return GlobalRegistry.getService(RevocationChecker.class);
    }

    public static Cert getCertForPluginField(Field certField) throws CertificateException {
        Cert pluginCertField = null;
        if (certField != null && StringUtils.isNotBlank((String)certField.getValue())) {
            String value = certField.getValue();
            if ((value = value.trim()).startsWith("-----BEGIN CERTIFICATE-----") && value.endsWith("-----END CERTIFICATE-----")) {
                pluginCertField = Cert.importCert(value);
            }
        }
        return pluginCertField;
    }
}

