/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.configservice.Reloadable;
import com.pingidentity.crypto.CertificateGenerator;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.sourceid.config.ConfigurationException;
import org.sourceid.saml20.domain.mgmt.impl.PkCertManagerBase;

public interface CertificateService
extends CertificateGenerator,
Reloadable {
    public void init();

    public KeyStore getDsigKeystore() throws ConfigurationException;

    public KeyStore getDsigHSMKeystore();

    public KeyStore getSslKeystore();

    public KeyStore getSslHSMKeystore();

    public KeyStore getSslServerKeystore();

    public KeyStore getSslServerHSMKeystore();

    public KeyStore getTrustKeystore();

    public KeyStore getTrustHSMKeystore();

    public KeyStore getGeneralKeystore();

    public KeyStore getGeneralHSMKeystore();

    public void writeDsigKeystore(KeyStore var1);

    public void writeDsigHSMKeystore(KeyStore var1);

    public void writeSslKeystore(KeyStore var1);

    public void writeSslHSMKeystore(KeyStore var1);

    public void writeSslServerKeystore(KeyStore var1);

    public void writeSslServerHSMKeystore(KeyStore var1);

    public void writeTrustKeystore(KeyStore var1);

    public void writeTrustHSMKeystore(KeyStore var1);

    public void writeGeneralKeystore(KeyStore var1);

    public void writeGeneralHSMKeystore(KeyStore var1);

    public String getKeystoreType();

    default public String getKeystoreType(String fileName) {
        return this.getKeystoreType();
    }

    public void setupSslClientTrustStore();

    default public String getHSMProviderName() {
        return null;
    }

    public InputStream getKeystoreInputStream(String var1) throws FileNotFoundException;

    public String getKeystorePassword(String var1);

    public PrivateKey findPrivateKeyById(String var1) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException, UnrecoverableKeyException;

    public boolean doPrivateKeyAndCertificateMatch(PrivateKey var1, X509Certificate var2) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException;

    default public Enumeration<String> getAliases(String keystoreName, KeyStore keystore) throws KeyStoreException {
        return keystore.aliases();
    }

    default public String buildAlias() {
        return PkCertManagerBase.generateNewAlias();
    }
}

