/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

public enum EncryptAlgorithms {
    AES_128("Aes_128", "AES_128", "http://www.w3.org/2001/04/xmlenc#aes128-cbc"),
    AES_256("Aes_256", "AES_256", "http://www.w3.org/2001/04/xmlenc#aes256-cbc"),
    TRIPLE_DES("Triple_des", "Triple_DES", "http://www.w3.org/2001/04/xmlenc#tripledes-cbc"),
    AES_128_GCM("Aes_128_gcm", "AES_128_GCM", "http://www.w3.org/2009/xmlenc11#aes128-gcm"),
    AES_192_GCM("Aes_192_gcm", "AES_192_GCM", "http://www.w3.org/2009/xmlenc11#aes192-gcm"),
    AES_256_GCM("Aes_256_gcm", "AES_256_GCM", "http://www.w3.org/2009/xmlenc11#aes256-gcm"),
    RSA_V1DOT5("Rsa_v15", "RSA_v15", "http://www.w3.org/2001/04/xmlenc#rsa-1_5"),
    RSA_OAEP("Rsa_oaep", "RSA_OAEP", "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p"),
    RSA_OAEP_256("Rsa_oaep_256", "RSA_OAEP_256", "http://www.w3.org/2009/xmlenc11#rsa-oaep");

    private final String label;
    private final String displayName;
    private final String matchingXmlCipher;

    private EncryptAlgorithms(String label, String displayName, String xmlCipher) {
        this.label = label;
        this.displayName = displayName;
        this.matchingXmlCipher = xmlCipher;
    }

    public String getLabel() {
        if (this.label == null || this.label.isEmpty()) {
            return "Common_None";
        }
        return this.label;
    }

    public String getDisplayName() {
        if (this.displayName == null || this.displayName.isEmpty()) {
            return "Common_None";
        }
        return this.displayName;
    }

    public String getMatchingXmlCipher() {
        return this.matchingXmlCipher;
    }

    public static EncryptAlgorithms fromXMLCipher(String xmlCipher) throws AlgorithmNotFoundException {
        for (EncryptAlgorithms alg : EncryptAlgorithms.values()) {
            if (!alg.getMatchingXmlCipher().equals(xmlCipher)) continue;
            return alg;
        }
        throw new AlgorithmNotFoundException("The xmlCipher '" + xmlCipher + "' does not match any of the EncryptedAlgorithms");
    }

    public static EncryptAlgorithms fromLabel(String algorithmLabel) throws AlgorithmNotFoundException {
        for (EncryptAlgorithms alg : EncryptAlgorithms.values()) {
            if (!alg.getLabel().equalsIgnoreCase(algorithmLabel)) continue;
            return alg;
        }
        throw new AlgorithmNotFoundException("The label '" + algorithmLabel + "' does not match any of the EncryptedAlgorithms");
    }

    public static EncryptAlgorithms fromDisplayName(String algorithm) throws AlgorithmNotFoundException {
        for (EncryptAlgorithms alg : EncryptAlgorithms.values()) {
            if (!alg.getDisplayName().equalsIgnoreCase(algorithm)) continue;
            return alg;
        }
        throw new AlgorithmNotFoundException("The displayName '" + algorithm + "' does not match any of the EncryptedAlgorithms");
    }

    public static class AlgorithmNotFoundException
    extends Exception {
        public AlgorithmNotFoundException(String message) {
            super(message);
        }
    }
}

