/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.common.util.Substituter;
import com.pingidentity.common.util.TimerTaskBase;
import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.CertificateHelper;
import com.pingidentity.crypto.CertificateReferenceType;
import com.pingidentity.crypto.CertificateStatus;
import com.pingidentity.crypto.CertificateType;
import com.pingidentity.crypto.CertificateValidity;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.crypto.expiry.notification.CertificateExpiryNotification;
import com.pingidentity.crypto.expiry.notification.CertificateExpiryNotificationManager;
import com.pingidentity.email.util.NotificationSupportHelper;
import com.pingidentity.pingcommons.crypto.HashAlgorithm;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.notification.NotificationEventType;
import java.security.cert.CertificateException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.format.ISODateTimeFormat;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.adapter.AuthnAdapterDescriptor;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.gui.EncryptionCertificateFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.domain.BasePluginInstance;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.MetadataUrlCertPair;
import org.sourceid.saml20.domain.NotificationMode;
import org.sourceid.saml20.domain.NotificationSettings;
import org.sourceid.saml20.domain.mgmt.AdapterManager;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.NotificationMgr;
import org.sourceid.saml20.domain.mgmt.PkCertAndConnectionCertManager;
import org.sourceid.saml20.domain.mgmt.impl.Mode;
import org.sourceid.saml20.domain.mgmt.impl.ModeSupport;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.util.license.Synchronizer;
import org.sourceid.wstrust.mgmt.TokenGeneratorManager;
import org.sourceid.wstrust.mgmt.TokenPluginInstance;
import org.sourceid.wstrust.mgmt.TokenPluginManager;
import org.sourceid.wstrust.mgmt.TokenProcessorManager;
import org.sourceid.wstrust.plugin.process.TokenPluginDescriptor;

public class ExpirationNotifier
extends TimerTaskBase {
    private final ConfigStore configStore = ConfigStoreFarm.getConfig("com.pingidentity.crypto.ExpirationNotifier");
    private static final String DELIM = "|";
    private static final String LEGACY_DELIM = ":";
    static final String IP = "IP_ADDR";
    static final String SUBJECT_DN = "SUBJECT_DN";
    static final String SERIAL_NUMBER = "SERIAL_NUMBER";
    static final String EX_DATE = "EX_DATE";
    static final String EX_TYPE = "EX_TYPE";
    static final String CONN_NAME = "CONN_NAME";
    static final String INSTANCE_NAME = "INSTANCE_NAME";
    static final String DAYS_LEFT = "DAYS_LEFT";
    static final String ACTION = "ACTION";
    static final String METADATA_NOTIFICATION_ACTION = "To update the signature verification certificate of the metadata URL, sign on to the PingFederate administrative console, verify the metadata URL and replicate the configuration to your cluster.";
    static final String CFG_STALE_CERT_THRESHOLD_DAYS = "StaleCertThresholdDays";
    private static final CertificateExpiryNotificationManager certificateExpiryNotificationManager = MgmtFactory.getCertificateExpiryNotificationManager();
    private static final ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
    private static final BearerAccessTokenMgmtPluginManager atmManager = MgmtFactory.getBearerAccessTokenMgmtPluginMgr();
    private static final Log log = LogFactory.getLog(ExpirationNotifier.class);
    private Synchronizer synchronizer;
    private Clock clock = Clock.systemDefaultZone();

    public ExpirationNotifier() {
        this.init();
    }

    public ExpirationNotifier(Clock clock) {
        this.clock = clock;
        this.init();
    }

    private void init() {
        this.synchronizer = Synchronizer.getSynchronizer();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doTask() {
        if (this.skipCertificateExpiryTask()) {
            return;
        }
        this.logRevokedTrustedCAs();
        this.purgeStaleEntries();
        ArrayList<CertificateExpiryNotification> consoleWarnings = new ArrayList<CertificateExpiryNotification>();
        boolean populateConsoleWarnings = true;
        for (CertificateStatus status : CertificateStatus.values()) {
            Object certTokenProcessorIds2;
            for (PkCert pkCert : MgmtFactory.getDsigPkCertManager().getPkCerts()) {
                this.checkWriteLogAndNotify(pkCert, status, CertificateType.DIGITAL_SIGNATURE_DECRYPTION, consoleWarnings, populateConsoleWarnings);
            }
            for (PkCert pkCert : MgmtFactory.getSslServerPkCertManager().getPkCerts()) {
                this.checkWriteLogAndNotify(pkCert, status, CertificateType.SSL_SERVER, consoleWarnings, populateConsoleWarnings);
            }
            for (PkCert pkCert : MgmtFactory.getSslAuthPkCertManager().getPkCerts()) {
                this.checkWriteLogAndNotify(pkCert, status, CertificateType.SSL_CLIENT, consoleWarnings, populateConsoleWarnings);
            }
            for (Cert cert : MgmtFactory.getTrustedCAsManager().getTrustedCAs()) {
                this.checkWriteLogAndNotify(cert, status, CertificateType.TRUSTED_CA, consoleWarnings, populateConsoleWarnings);
            }
            PkCertAndConnectionCertManager certMgr = (PkCertAndConnectionCertManager)MgmtFactory.getDsigPkCertManager();
            Map<String, Set<String>> map = this.getCertTokenGenerators();
            for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
                Cert cert = null;
                try {
                    cert = certMgr.getCert(entry.getKey());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    log.debug((Object)("No cert found for alias " + entry.getKey()));
                }
                if (cert == null) continue;
                CertificateExpiryNotification certificateExpiryNotification = new CertificateExpiryNotification(cert.getId(), CertificateType.TOKEN_GENERATOR_ENCRYPTION);
                this.checkWriteLogAndNotify(cert, status, certificateExpiryNotification, status.getAction(), entry.getValue(), consoleWarnings, populateConsoleWarnings);
            }
            Map<String, Set<String>> certTokenProcessorsMap = this.getCertTokenProcessors();
            for (Object certTokenProcessorIds2 : certTokenProcessorsMap.entrySet()) {
                void var12_30;
                Object var12_28 = null;
                try {
                    Cert cert = certMgr.getCert((String)certTokenProcessorIds2.getKey());
                }
                catch (IllegalArgumentException e) {
                    log.debug((Object)("No cert found for alias " + (String)certTokenProcessorIds2.getKey()));
                }
                if (var12_30 == null) continue;
                CertificateExpiryNotification certificateExpiryNotification = new CertificateExpiryNotification(var12_30.getId(), CertificateType.TOKEN_PROCESSOR_ENCRYPTION);
                this.checkWriteLogAndNotify((Cert)var12_30, status, certificateExpiryNotification, status.getAction(), (Set)certTokenProcessorIds2.getValue(), consoleWarnings, populateConsoleWarnings);
            }
            Set<Cert> set = certMgr.getCertsForFeature("Revocation Settings OCSP Responder Certs");
            certTokenProcessorIds2 = set.iterator();
            while (certTokenProcessorIds2.hasNext()) {
                Cert cert = (Cert)certTokenProcessorIds2.next();
                this.checkWriteLogAndNotify(cert, status, CertificateType.OCSP_DSIG_VERIFICATION, consoleWarnings, populateConsoleWarnings);
            }
            Set<Cert> certs = certMgr.getCertsForFeature("STS Settings Mutual SSL Authentication Certs");
            for (Cert cert : certs) {
                this.checkWriteLogAndNotify(cert, status, CertificateType.STS_CLIENT_AUTH, consoleWarnings, populateConsoleWarnings);
            }
            for (Cert idpAdapterCert : this.getIdpAdapterCerts(certMgr)) {
                this.checkWriteLogAndNotify(idpAdapterCert, status, CertificateType.ADAPTER_VERIFICATION_ENCRYPTION, consoleWarnings, populateConsoleWarnings);
            }
            for (Cert spAdapterCert : this.getSpAdapterCerts(certMgr)) {
                this.checkWriteLogAndNotify(spAdapterCert, status, CertificateType.ADAPTER_VERIFICATION_ENCRYPTION, consoleWarnings, populateConsoleWarnings);
            }
            for (ConnectionBase connection : connectionManager.getAllConnections()) {
                Cert encryptionCert = connection.getEncryptionSettings().getEncryptionCert();
                if (encryptionCert != null) {
                    Object encryptionCertType = CertificateType.CONNECTION_ENCRYPTION;
                    for (Cert cert2 : connection.getDsigVerificationCerts().getActiveVerificationCerts()) {
                        if (!cert2.equals(encryptionCert)) continue;
                        encryptionCertType = CertificateType.CONNECTION_VERIFICATION_ENCRYPTION;
                        break;
                    }
                    CertificateExpiryNotification certificateExpiryNotification = new CertificateExpiryNotification(encryptionCert.getId(), (CertificateType)((Object)encryptionCertType), connection.getId(), connection.getName(), ExpirationNotifier.getCertificateReferenceType(connection.getRoleType()));
                    this.checkWriteLogAndNotify(encryptionCert, status, certificateExpiryNotification, status.getAction(), null, consoleWarnings, populateConsoleWarnings);
                }
                for (Cert cert : connection.getDsigVerificationCerts().getActiveVerificationCerts()) {
                    if (encryptionCert != null && cert.getId().equals(encryptionCert.getId())) continue;
                    this.notifyDsignVerificationCert(status, connection, cert, consoleWarnings, populateConsoleWarnings);
                }
            }
            Collection<MetadataUrlCertPair> collection = MgmtFactory.getMetadataUrlManager().getMetadataUrlPairs();
            if (collection != null) {
                for (MetadataUrlCertPair metadataCert : collection) {
                    Set<Cert> metadataVerCert = certMgr.getCertsForFeature(metadataCert.getId());
                    for (Cert cert : metadataVerCert) {
                        CertificateExpiryNotification certificateExpiryNotification = new CertificateExpiryNotification(cert.getId(), CertificateType.METADATA_VERIFICATION, metadataCert.getId(), metadataCert.getName(), null);
                        this.checkWriteLogAndNotify(cert, status, certificateExpiryNotification, METADATA_NOTIFICATION_ACTION, consoleWarnings, populateConsoleWarnings);
                    }
                }
            }
            for (ConfigurablePluginInstance atmInstance : atmManager.getInstances()) {
                void var16_48;
                Field encryptionField = atmInstance.getConfiguration().getField("Asymmetric Encryption Key");
                Object var16_46 = null;
                try {
                    Cert cert = CertificateHelper.getCertForPluginField(encryptionField);
                }
                catch (CertificateException e) {
                    log.debug((Object)("Unable to validate and obtain expiry date of encryption certificate for ATM with ID : '" + atmInstance.getId() + "'."));
                }
                if (var16_48 == null) continue;
                CertificateExpiryNotification certificateExpiryNotification = new CertificateExpiryNotification(var16_48.getId(), CertificateType.ACCESS_TOKEN_MANAGER_ENCRYPTION, atmInstance.getId(), atmInstance.getName(), null);
                this.checkWriteLogAndNotify((Cert)var16_48, status, certificateExpiryNotification, status.getAction(), consoleWarnings, populateConsoleWarnings);
            }
            if (!populateConsoleWarnings) continue;
            certificateExpiryNotificationManager.saveCertificateExpiryNotificationEntries(consoleWarnings);
            populateConsoleWarnings = false;
        }
    }

    private boolean skipCertificateExpiryTask() {
        NotificationSettings notificationSettings = this.getNotificationSettings();
        if (!notificationSettings.isEnableCertificateExpirationNotification()) {
            if (Mode.CLUSTERED_ENGINE == ModeSupport.getMode()) {
                return true;
            }
            if (ModeSupport.isConsole() && Integer.parseInt(notificationSettings.getExpiringCertUIWarning()) == 0 && Integer.parseInt(notificationSettings.getExpiredCertThresholdUIWarning()) == 0) {
                certificateExpiryNotificationManager.clearExpiryNotifications();
                return true;
            }
        }
        return false;
    }

    private void notifyDsignVerificationCert(CertificateStatus status, ConnectionBase connection, Cert cert, Collection<CertificateExpiryNotification> consoleWarnings, boolean populateConsoleWarnings) {
        if (cert != null) {
            CertificateExpiryNotification dsignCertificateExpiryNotification = new CertificateExpiryNotification(cert.getId(), CertificateType.CONNECTION_VERIFICATION);
            dsignCertificateExpiryNotification.setReferenceItemName(connection.getName());
            dsignCertificateExpiryNotification.setReferenceItemId(connection.getId());
            CertificateReferenceType certificateReferenceType = ExpirationNotifier.getCertificateReferenceType(connection.getRoleType());
            dsignCertificateExpiryNotification.setReferenceItemType(certificateReferenceType);
            this.checkWriteLogAndNotify(cert, status, dsignCertificateExpiryNotification, status.getAction(), consoleWarnings, populateConsoleWarnings);
        }
    }

    private static CertificateReferenceType getCertificateReferenceType(Role connectionRole) {
        CertificateReferenceType certificateReferenceType = Role.SP == connectionRole ? CertificateReferenceType.SP_CONNECTION : (Role.IDP == connectionRole ? CertificateReferenceType.IDP_CONNECTION : null);
        return certificateReferenceType;
    }

    private Map<String, Set<String>> getCertTokenGenerators() {
        TokenGeneratorManager tokenGeneratorManager = MgmtFactory.getTokenGeneratorManager();
        return this.getCertTokenPluginIds(tokenGeneratorManager);
    }

    private Map<String, Set<String>> getCertTokenPluginIds(TokenPluginManager<TokenPluginInstance> tokenPluginManager) {
        HashMap<String, Set<String>> certTokenPluginIdsMap = new HashMap<String, Set<String>>();
        for (TokenPluginDescriptor descriptor : tokenPluginManager.getInstalledDescriptors()) {
            GuiConfigDescriptor guiConfigDescriptor = descriptor.getGuiConfigDescriptorBuilder().buildNewGuiDescriptor();
            if (!guiConfigDescriptor.getAllDescriptorTypesInUse().contains(EncryptionCertificateFieldDescriptor.class)) continue;
            HashSet<String> certificateFieldNames = new HashSet<String>();
            for (FieldDescriptor fieldDescriptor : guiConfigDescriptor.getFields()) {
                if (!(fieldDescriptor instanceof EncryptionCertificateFieldDescriptor)) continue;
                certificateFieldNames.add(fieldDescriptor.getName());
            }
            if (certificateFieldNames.isEmpty()) continue;
            List<TokenPluginInstance> tokenPlugins = tokenPluginManager.getInstancesForTokenType(descriptor.getTokenType());
            for (TokenPluginInstance tokenPlugin : tokenPlugins) {
                Set<String> certIds = this.getCertIds(tokenPlugin, certificateFieldNames);
                if (certIds.isEmpty()) continue;
                for (String certId : certIds) {
                    if (!certTokenPluginIdsMap.containsKey(certId)) {
                        certTokenPluginIdsMap.put(certId, new HashSet());
                    }
                    ((Set)certTokenPluginIdsMap.get(certId)).add(tokenPlugin.getId());
                }
            }
        }
        return certTokenPluginIdsMap;
    }

    private Set<String> getCertIds(BasePluginInstance pluginInstance, Set<String> certificateFieldNames) {
        HashSet<String> certIds = new HashSet<String>();
        for (String certFieldName : certificateFieldNames) {
            Field field = pluginInstance.getConfiguration().getField(certFieldName);
            if (field == null || !StringUtils.isNotBlank((String)field.getValue())) continue;
            certIds.add(field.getValue());
        }
        return certIds;
    }

    private Map<String, Set<String>> getCertTokenProcessors() {
        TokenProcessorManager tokenProcessorManager = MgmtFactory.getTokenProcessorManager();
        return this.getCertTokenPluginIds(tokenProcessorManager);
    }

    private Set<Cert> getIdpAdapterCerts(PkCertAndConnectionCertManager certMgr) {
        AdapterManager adapterMgr = MgmtFactory.getAdapterManager();
        return this.getCertSet(adapterMgr.getInstalledIdpAuthnAdapterDescriptors(), certMgr);
    }

    private Set<Cert> getSpAdapterCerts(PkCertAndConnectionCertManager certMgr) {
        AdapterManager adapterMgr = MgmtFactory.getAdapterManager();
        return this.getCertSet(adapterMgr.getInstalledSpAuthnAdapterDescriptors(), certMgr);
    }

    private Set<Cert> getCertSet(Collection<? extends AuthnAdapterDescriptor> descriptors, PkCertAndConnectionCertManager certMgr) {
        HashSet<Cert> certs = new HashSet<Cert>();
        for (AuthnAdapterDescriptor authnAdapterDescriptor : descriptors) {
            GuiConfigDescriptor guiConfigDescriptor = authnAdapterDescriptor.getGuiConfigDescriptor();
            if (!guiConfigDescriptor.getAllDescriptorTypesInUse().contains(EncryptionCertificateFieldDescriptor.class)) continue;
            for (FieldDescriptor fieldDescriptor : guiConfigDescriptor.getFields()) {
                if (!(fieldDescriptor instanceof EncryptionCertificateFieldDescriptor)) continue;
                String featureId = ((EncryptionCertificateFieldDescriptor)fieldDescriptor).getCertificateFeatureName();
                certs.addAll(certMgr.getCertsForFeature(featureId));
            }
        }
        return certs;
    }

    private boolean isNotificationThresholdReached(Cert cert, CertificateStatus status) {
        NotificationSettings settings = this.getNotificationSettings();
        if (status == CertificateStatus.EXPIRED || settings.isEnableCertificateExpirationNotification()) {
            int offset = 0;
            if (status == CertificateStatus.INITIAL_WARN) {
                String initialWarning = settings.getCertInitialWarningEvent();
                if ("".equals(initialWarning) || initialWarning == null) {
                    return false;
                }
                offset = Integer.parseInt(settings.getCertInitialWarningEvent());
            } else if (status == CertificateStatus.FINAL_WARN) {
                offset = Integer.parseInt(settings.getCertFinalWarningEvent());
            }
            return this.notifyCertExpiry(cert, offset);
        }
        return false;
    }

    private void handleUINotification(Cert cert, CertificateExpiryNotification certExpNotification, Set<String> pluginIds, Collection<CertificateExpiryNotification> consoleWarnings) {
        if (!ModeSupport.isConsole() || certExpNotification == null || cert.getId() == null && certExpNotification.getCertificateType() != CertificateType.ACCESS_TOKEN_MANAGER_ENCRYPTION) {
            return;
        }
        NotificationSettings notificationSettings = this.getNotificationSettings();
        if (this.notifyCertExpiry(cert, Integer.parseInt(notificationSettings.getExpiringCertUIWarning())) && !this.notifyCertExpiry(cert, -1 * Integer.parseInt(notificationSettings.getExpiredCertThresholdUIWarning()))) {
            if (pluginIds == null) {
                consoleWarnings.add(certExpNotification);
            } else {
                for (String pluginId : pluginIds) {
                    CertificateExpiryNotification pluginCertExpNotification = certExpNotification.clone();
                    pluginCertExpNotification.setReferenceItemId(pluginId);
                    consoleWarnings.add(pluginCertExpNotification);
                }
            }
        }
    }

    private boolean notifyCertExpiry(Cert cert, int warningDaysBeforeExp) {
        Date certExpiration = cert.getX509Certificate().getNotAfter();
        Date now = new Date(this.clock.millis());
        Date warnDate = new Date(certExpiration.getTime() - (long)warningDaysBeforeExp * Duration.ofDays(1L).toMillis());
        return now.after(warnDate);
    }

    private boolean checkNotificationSent(NotificationType notificationType, Cert cert, CertificateStatus status, CertificateExpiryNotification certificateExpiryNotification, boolean checkDistributedCache) {
        String connectionName = null;
        String connectionId = null;
        if (certificateExpiryNotification != null) {
            connectionId = certificateExpiryNotification.getReferenceItemId();
            connectionName = certificateExpiryNotification.getReferenceItemName();
        }
        String currentKey = this.makeKey(notificationType, cert, status, connectionId);
        String legacyKey = this.makeLegacyKey(cert, status, connectionName);
        for (String key : Arrays.asList(currentKey, legacyKey)) {
            if (!this.synchronizer.isNotificationSent(key, checkDistributedCache)) continue;
            return true;
        }
        return false;
    }

    private boolean isStaleExpiredCert(Cert cert) {
        Date expirationDate = cert.getX509Certificate().getNotAfter();
        return this.isStaleExpirationDate(expirationDate);
    }

    private boolean isStaleExpirationDate(Date expirationDate) {
        Instant staleInstant = expirationDate.toInstant().plus(Duration.ofDays(this.configStore.getIntValue(CFG_STALE_CERT_THRESHOLD_DAYS, 2)));
        return Instant.ofEpochMilli(this.clock.millis()).isAfter(staleInstant);
    }

    private void purgeStaleEntries() {
        Set<String> keys = this.synchronizer.getKeys();
        for (String key : keys) {
            if (!this.isStaleCertKey(key)) continue;
            this.synchronizer.removeEntry(key);
        }
    }

    private void logRevokedTrustedCAs() {
        for (Cert cert : MgmtFactory.getTrustedCAsManager().getTrustedCAs()) {
            CertificateValidity validity = CertificateHelper.getValidity(cert);
            if (validity != CertificateValidity.REVOKED) continue;
            log.warn((Object)("Trusted CA certificate " + cert + " is revoked"));
        }
    }

    private void checkWriteLogAndNotify(Cert cert, CertificateStatus status, CertificateType certType, Collection<CertificateExpiryNotification> consoleWarnings, boolean populateConsoleWarnings) {
        String action = status.getAction();
        CertificateExpiryNotification certificateExpiryNotification = new CertificateExpiryNotification(cert.getId(), certType);
        this.checkWriteLogAndNotify(cert, status, certificateExpiryNotification, action, null, consoleWarnings, populateConsoleWarnings);
    }

    private void checkWriteLogAndNotify(Cert cert, CertificateStatus status, CertificateExpiryNotification certificateExpiryNotification, String action, Collection<CertificateExpiryNotification> consoleWarnings, boolean populateConsoleWarnings) {
        this.checkWriteLogAndNotify(cert, status, certificateExpiryNotification, action, null, consoleWarnings, populateConsoleWarnings);
    }

    private void checkWriteLogAndNotify(Cert cert, CertificateStatus status, CertificateExpiryNotification certificateExpiryNotification, String action, Set<String> pluginIds, Collection<CertificateExpiryNotification> consoleWarnings, boolean populateConsoleWarnings) {
        boolean doEmail;
        boolean logCertificateExpiration;
        if (populateConsoleWarnings) {
            this.handleUINotification(cert, certificateExpiryNotification, pluginIds, consoleWarnings);
        }
        if (this.checkStaleExpiredCert(cert, status, certificateExpiryNotification)) {
            return;
        }
        if (!this.isNotificationThresholdReached(cert, status)) {
            return;
        }
        NotificationSettings settings = this.getNotificationSettings();
        if (!this.checkNotificationSent(NotificationType.CERT_EXPIRY_LOG, cert, status, certificateExpiryNotification, false)) {
            this.log(cert, status, certificateExpiryNotification);
            this.registerNotificationsSent(NotificationType.CERT_EXPIRY_LOG, cert, status, certificateExpiryNotification.getReferenceItemId(), false);
        }
        if ((logCertificateExpiration = settings.isEnableCertificateExpirationNotification()) && !this.checkNotificationSent(NotificationType.CERT_EXPIRY_LOG, cert, status, certificateExpiryNotification, false)) {
            this.log(cert, status, certificateExpiryNotification);
            this.registerNotificationsSent(NotificationType.CERT_EXPIRY_LOG, cert, status, certificateExpiryNotification.getReferenceItemId(), false);
        }
        boolean bl = doEmail = logCertificateExpiration && settings.getNotificationPublisherCertificates() != null && settings.getCertExpirationNotificationMode() != null && !settings.getCertExpirationNotificationMode().equals((Object)NotificationMode.LOGGING_ONLY) && this.synchronizer.isLead();
        if (doEmail && !this.checkNotificationSent(NotificationType.CERT_EXPIRY_EMAIL, cert, status, certificateExpiryNotification, true)) {
            this.mail(cert, status, certificateExpiryNotification, action, status.getEventType());
            this.registerNotificationsSent(NotificationType.CERT_EXPIRY_EMAIL, cert, status, certificateExpiryNotification.getReferenceItemId(), true);
        }
    }

    private boolean checkStaleExpiredCert(Cert cert, CertificateStatus status, CertificateExpiryNotification certificateExpiryNotification) {
        if (this.isStaleExpiredCert(cert)) {
            String legacyKey = this.makeLegacyKey(cert, status, certificateExpiryNotification.getReferenceItemName());
            this.synchronizer.removeEntry(legacyKey);
            return true;
        }
        return false;
    }

    private void registerNotificationsSent(NotificationType notificationType, Cert cert, CertificateStatus status, String refItemId, boolean writeDistributedCache) {
        List<CertificateStatus> statusNotificationsToRegister = this.getStatusNotificationsToRegister(status);
        for (CertificateStatus statusToRegister : statusNotificationsToRegister) {
            String key = this.makeKey(notificationType, cert, statusToRegister, refItemId);
            this.synchronizer.registerNotificationSent(key, writeDistributedCache);
        }
    }

    private List<CertificateStatus> getStatusNotificationsToRegister(CertificateStatus status) {
        ArrayList<CertificateStatus> result = new ArrayList<CertificateStatus>();
        result.add(status);
        if (status == CertificateStatus.EXPIRED) {
            result.add(CertificateStatus.FINAL_WARN);
            result.add(CertificateStatus.INITIAL_WARN);
        } else if (status == CertificateStatus.FINAL_WARN) {
            result.add(CertificateStatus.INITIAL_WARN);
        }
        return result;
    }

    protected String makeKey(NotificationType notificationType, Cert cert, CertificateStatus status, String connectionId) {
        if (connectionId == null) {
            connectionId = "";
        }
        String expirationDate = ISODateTimeFormat.dateTime().withZoneUTC().print(cert.getX509Certificate().getNotAfter().getTime());
        return notificationType.name() + DELIM + cert.getFingerPrint(HashAlgorithm.SHA256) + DELIM + connectionId + DELIM + status + DELIM + expirationDate;
    }

    protected String makeLegacyKey(Cert cert, CertificateStatus status, String connectionName) {
        if (connectionName == null) {
            return cert.getFingerPrint(HashAlgorithm.MD5) + LEGACY_DELIM + status;
        }
        return cert.getFingerPrint(HashAlgorithm.MD5) + LEGACY_DELIM + connectionName + LEGACY_DELIM + status;
    }

    private boolean isStaleCertKey(String key) {
        String[] parts = key.split("\\|");
        if (parts.length != 5) {
            return false;
        }
        if (!NotificationType.CERT_EXPIRY_EMAIL.name().equals(parts[0]) && !NotificationType.CERT_EXPIRY_LOG.name().equals(parts[0])) {
            return false;
        }
        String expirationStr = parts[4];
        try {
            Date expirationDate = ISODateTimeFormat.dateTimeParser().parseDateTime(expirationStr).toDate();
            return this.isStaleExpirationDate(expirationDate);
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)("Unexpected expiration date format: " + expirationStr));
            return false;
        }
    }

    private NotificationSettings getNotificationSettings() {
        NotificationMgr notificationMgr = MgmtFactory.getNotificationMgr();
        NotificationSettings existingSettings = notificationMgr.getNotificationSettings();
        NotificationSettings settings = new NotificationSettings(existingSettings);
        settings.setTo(existingSettings.getCertificateExpirationTo());
        settings.setEnableEmailNotification(true);
        return settings;
    }

    protected void log(Cert cert, CertificateStatus status, CertificateExpiryNotification notification) {
        String logTemplate = status.getLogTemplate();
        HashMap<String, String> substitutionValuesMap = new HashMap<String, String>();
        substitutionValuesMap.put(SUBJECT_DN, cert.getX509Certificate().getSubjectDN().toString());
        substitutionValuesMap.put(SERIAL_NUMBER, cert.getSerialNumberForDisplay());
        substitutionValuesMap.put(IP, Synchronizer.getSynchronizer().getIP());
        substitutionValuesMap.put(EX_TYPE, notification.getCertificateType().getTypeName());
        substitutionValuesMap.put(INSTANCE_NAME, notification.getReferenceItemName());
        substitutionValuesMap.put(EX_DATE, cert.getX509Certificate().getNotAfter().toString());
        substitutionValuesMap.put(DAYS_LEFT, this.getDaysUntil(cert.getX509Certificate().getNotAfter()));
        String msg = Substituter.substituteValuesTolarateUnkownKey((String)logTemplate, substitutionValuesMap);
        log.warn((Object)msg);
    }

    protected void mail(Cert cert, CertificateStatus status, CertificateExpiryNotification notification, String action, NotificationEventType eventType) {
        NotificationSettings settings = this.getNotificationSettings();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(IP, Synchronizer.getSynchronizer().getIP());
        params.put(SUBJECT_DN, cert.getX509Certificate().getSubjectDN().toString());
        params.put(SERIAL_NUMBER, cert.getSerialNumberForDisplay());
        params.put(EX_TYPE, notification.getCertificateType().getTypeName());
        params.put(CONN_NAME, notification.getReferenceItemName());
        params.put(INSTANCE_NAME, notification.getReferenceItemName());
        params.put(EX_DATE, cert.getX509Certificate().getNotAfter().toString());
        params.put(DAYS_LEFT, this.getDaysUntil(cert.getX509Certificate().getNotAfter()));
        params.put(ACTION, action);
        NotificationSupportHelper notificationSupportHelper = new NotificationSupportHelper();
        String notificationPublisher = settings.getNotificationPublisherCertificates();
        notificationSupportHelper.publishNotification(notificationPublisher, status.getEmailTemplateFile(), settings.getTo(), params, eventType != null ? eventType.toString() : "");
    }

    private String getDaysUntil(Date untilDate) {
        Date now = new Date(this.clock.millis());
        if (now.after(untilDate)) {
            return "0";
        }
        long milSecBetween = untilDate.getTime() - now.getTime();
        long warnDays = Math.round((double)milSecBetween / (double)Duration.ofDays(1L).toMillis());
        if (warnDays == NumberUtils.LONG_ZERO) {
            return "<1";
        }
        return Long.toString(warnDays);
    }

    private static enum NotificationType {
        CERT_EXPIRY_EMAIL,
        CERT_EXPIRY_LOG;

    }
}

