/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.common.util.Base64URL;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import org.sourceid.common.ByteUtil;
import org.sourceid.common.HashAlgorithm;
import org.sourceid.common.HashUtil;
import org.sourceid.common.IDGenerator;
import org.sourceid.common.Util;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;

public class HashedPassword {
    private String secret;
    private byte[] secretHash;
    private byte[] salt;
    private int algorithmId;
    private byte[] cacheHash;
    private static final String DOT = ".";
    private static final String REGEX = "\\.";
    private static final int NUM_DOTS = 3;
    private static final ConfigStore config = ConfigStoreFarm.getConfig(HashedPassword.class);
    private static int DEFAULT_ALGORITHM_ID = config.getIntValue("default-algorithm-id", 2);
    static boolean enableCache = config.getBooleanValue("enable-cache", true);
    private static final int RADIX = 36;
    static final Map<Integer, Algorithm> algorithms = new HashMap<Integer, Algorithm>();

    HashedPassword(String clearText, int algorithmId) {
        this.algorithmId = algorithmId;
        this.salt = this.getAlgorithm().generateSalt();
        this.secretHash = this.digest(this.textToBytes(clearText));
        this.secret = clearText;
    }

    HashedPassword(byte[] secretHash, byte[] salt, int algorithmId) {
        this.secretHash = secretHash;
        this.salt = salt;
        this.algorithmId = algorithmId;
        this.secret = null;
    }

    HashedPassword() {
    }

    public static HashedPassword fromClearText(String clearText) {
        return new HashedPassword(clearText, DEFAULT_ALGORITHM_ID);
    }

    public static HashedPassword fromEncodedText(String encodedText) {
        String[] parts = encodedText.split(REGEX);
        if (parts.length != 3) {
            throw new IllegalArgumentException("invalid encoded text format");
        }
        byte[] secretHash = HashedPassword.decode(parts[0]);
        byte[] salt = HashedPassword.decode(parts[1]);
        int algorithmId = Integer.parseInt(parts[2], 36);
        return new HashedPassword(secretHash, salt, algorithmId);
    }

    public static boolean isEncodedText(String encodedText) {
        String[] parts = encodedText.split(REGEX);
        return parts.length == 3;
    }

    private Algorithm getAlgorithm() {
        return algorithms.get(this.algorithmId);
    }

    private byte[] textToBytes(String secret) {
        return secret.getBytes(Util.UTF8CS);
    }

    public boolean checkSecret(String secret) {
        if (secret == null) {
            return false;
        }
        byte[] secretBytes = this.textToBytes(secret);
        if (this.cacheHash != null) {
            return ByteUtil.secureEquals(this.cacheHash(secretBytes), this.cacheHash);
        }
        boolean match = ByteUtil.secureEquals(this.digest(secretBytes), this.secretHash);
        if (enableCache && match) {
            this.cacheHash = this.cacheHash(secretBytes);
        }
        return match;
    }

    private byte[] cacheHash(byte[] secretBytes) {
        return this.getAlgorithm().cacheHash(secretBytes, this.salt);
    }

    private byte[] digest(byte[] secretBytes) {
        return this.getAlgorithm().digest(secretBytes, this.salt);
    }

    public String toEncodedText() {
        return HashedPassword.encode(this.secretHash) + DOT + HashedPassword.encode(this.salt) + DOT + Integer.toString(this.algorithmId, 36);
    }

    private static byte[] decode(String encoded) {
        return Base64URL.decode((String)encoded);
    }

    private static String encode(byte[] bytes) {
        return Base64URL.encodeToString((byte[])bytes);
    }

    public String getSecret() {
        return this.secret;
    }

    static {
        algorithms.put(0, new GeneralPurposeHashAlgorithm(HashAlgorithm.SHA256, 6, 1L));
        algorithms.put(1, new GeneralPurposeHashAlgorithm(HashAlgorithm.SHA256, 6, 1000L));
        algorithms.put(2, new GeneralPurposeHashAlgorithm(HashAlgorithm.SHA256, 6, 10000L));
        algorithms.put(3, new GeneralPurposeHashAlgorithm(HashAlgorithm.SHA256, 6, 100000L));
        algorithms.put(4, new GeneralPurposeHashAlgorithm(HashAlgorithm.SHA256, 6, 200000L));
        algorithms.put(5, new GeneralPurposeHashAlgorithm(HashAlgorithm.SHA256, 6, 1000000L));
        algorithms.put(6, new GeneralPurposeHashAlgorithm(HashAlgorithm.SHA256, 6, 5000000L));
    }

    private static class GeneralPurposeHashAlgorithm
    implements Algorithm {
        private HashAlgorithm algo;
        private int saltLen;
        private long rounds;

        private GeneralPurposeHashAlgorithm(HashAlgorithm algo, int saltLen, long rounds) {
            this.algo = algo;
            this.saltLen = saltLen;
            this.rounds = rounds;
        }

        @Override
        public byte[] digest(byte[] secret, byte[] salt) {
            return this.doDigest(secret, salt, this.rounds);
        }

        @Override
        public byte[] cacheHash(byte[] secret, byte[] salt) {
            return this.doDigest(secret, salt, 1L);
        }

        private byte[] doDigest(byte[] secret, byte[] salt, long iterations) {
            MessageDigest messageDigester = HashUtil.getMessageDigester((HashAlgorithm)this.algo);
            byte[] result = secret;
            int i = 0;
            while ((long)i <= iterations) {
                boolean b = i % 2 == 0;
                messageDigester.update(b ? salt : result);
                messageDigester.update(b ? result : salt);
                result = messageDigester.digest();
                ++i;
            }
            return result;
        }

        @Override
        public byte[] generateSalt() {
            return IDGenerator.generateBytes(this.saltLen);
        }
    }

    private static interface Algorithm {
        public byte[] digest(byte[] var1, byte[] var2);

        public byte[] generateSalt();

        public byte[] cacheHash(byte[] var1, byte[] var2);
    }
}

